/****************************************************************************
 *
 * Copyright (c) 2008-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/
 
package org.ow2.easywsdl.extensions.wsdl4complexwsdl;

import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlException;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlReader;

import com.ebmwebsourcing.easycommons.pooling.GenericResourcePool;
import com.ebmwebsourcing.easycommons.pooling.PoolException;
import com.ebmwebsourcing.easycommons.pooling.PoolPolicy;
import com.ebmwebsourcing.easycommons.pooling.ResourceHandler;

/**
 * This class represent a {@link WSDL4ComplexWsdlReader} pool, which provides {@link WSDL4ComplexWsdlReader}
 * objects as resources.
 * 
 * @author Nicolas Oddoux - EBM WebSourcing
 */
public class WSDL4ComplexWsdlReaderResourcePool {

    /**
     * {@link WSDL4ComplexWsdlReader} resource handler to manage {@link WSDL4ComplexWsdlReader} life cycle methods
     */
    private class WSDL4ComplexWsdlReaderResourceHandler implements ResourceHandler<WSDL4ComplexWsdlReader> {

        final WSDL4ComplexWsdlFactory wsdl4ComplexWsdlFactory;

        public WSDL4ComplexWsdlReaderResourceHandler() {
            try {
                this.wsdl4ComplexWsdlFactory = WSDL4ComplexWsdlFactory.newInstance();
            } catch (WSDL4ComplexWsdlException e) {
                throw new PoolException(e);
            }
        }

        @Override
        public WSDL4ComplexWsdlReader create() {
            try {
                return this.wsdl4ComplexWsdlFactory.newWSDLReader();
            } catch (WSDL4ComplexWsdlException e) {
                throw new PoolException(e);
            }
        }

        @Override
        public void onRelease(WSDL4ComplexWsdlReader wsdl4ComplexWsdlReader) {
        }

        @Override
        public void onTake(WSDL4ComplexWsdlReader wsdl4ComplexWsdlReader) {            
        }
    }
    
    private final GenericResourcePool<WSDL4ComplexWsdlReader> wsdl4ComplexWsdlReaderResourcePool;

    /**
     * Allowing to instantiate a new {@link WSDL4ComplexWsdlReaderResourcePool} containing {@link WSDL4ComplexWsdlReader} resources.
     * 
     * @param minPoolSize
     *            The minimum number of {@link WSDL4ComplexWsdlReader} instances in the pool (created at the
     *            initialization).
     * @param maxPoolSize
     *            the maximum number of {@link WSDL4ComplexWsdlReader} instances in the current pool (limit of the
     *            pool). It must be greater or equals to the specified minSize.
     *            The maximum value is Integer.MAX_VALUE
     * @param poolPolicy
     *            the {@link PoolPolicy} to adopt when the maximum size is reached. it
     *            must not be null.
     */
    public WSDL4ComplexWsdlReaderResourcePool(int minPoolSize, int maxPoolSize,
            PoolPolicy poolPolicy) {
        WSDL4ComplexWsdlReaderResourceHandler wsdl4ComplexWsdlReaderResourceHandler = new WSDL4ComplexWsdlReaderResourceHandler();
        this.wsdl4ComplexWsdlReaderResourcePool = new GenericResourcePool<WSDL4ComplexWsdlReader>(
                wsdl4ComplexWsdlReaderResourceHandler, minPoolSize, maxPoolSize, poolPolicy);
    }

    /**
     * Take one unused {@link WSDL4ComplexWsdlReader} in the current pool. After getting a
     * {@link WSDL4ComplexWsdlReader} from the pool and before returning a
     * {@link WSDL4ComplexWsdlReader}, the method onTake() of the {@link WSDL4ComplexWsdlReader}
     * resource handler is called.
     * 
     * @return one {@link WSDL4ComplexWsdlReader}
     * 
     * @throws PoolException
     *             if the current thread is interrupted for the pool policy WAIT
     *             or if there is no more available resource in the pool for the
     *             pool policy REJECT
     * 
     */
    public WSDL4ComplexWsdlReader take() {
        return this.wsdl4ComplexWsdlReaderResourcePool.take();
    }

    /**
     * Release the specified {@link WSDL4ComplexWsdlReader} After putting back the
     * {@link WSDL4ComplexWsdlReader} in the pool, the method onRelease() of the
     * {@link WSDL4ComplexWsdlReader} resource handler is called.
     * 
     * @param wsdl4ComplexWsdlReader
     *            The {@link WSDL4ComplexWsdlReader} to release
     */
    public final void release(final WSDL4ComplexWsdlReader wsdl4ComplexWsdlReader) {
        this.wsdl4ComplexWsdlReaderResourcePool.release(wsdl4ComplexWsdlReader);
    }
}
