/****************************************************************************
 *
 * Copyright (c) 2008-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/
 
package org.ow2.easywsdl.extensions.wsdl4complexwsdl;

import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlException;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlWriter;

import com.ebmwebsourcing.easycommons.pooling.GenericResourcePool;
import com.ebmwebsourcing.easycommons.pooling.PoolException;
import com.ebmwebsourcing.easycommons.pooling.PoolPolicy;
import com.ebmwebsourcing.easycommons.pooling.ResourceHandler;

/**
 * This class represent a {@link WSDL4ComplexWsdlWriter} pool, which provides {@link WSDL4ComplexWsdlWriter}
 * objects as resource.
 * 
 * @author Nicolas Oddoux - EBM WebSourcing
 */
public class WSDL4ComplexWsdlWriterResourcePool {

    /**
     * {@link WSDL4ComplexWsdlWriter} resource handler to manage {@link WSDL4ComplexWsdlWriter} life cycle methods
     */
    private class WSDL4ComplexWsdlWriterResourceHandler implements ResourceHandler<WSDL4ComplexWsdlWriter> {

        final WSDL4ComplexWsdlFactory wsdl4ComplexWsdlFactory;

        public WSDL4ComplexWsdlWriterResourceHandler() {
            try {
                this.wsdl4ComplexWsdlFactory = WSDL4ComplexWsdlFactory.newInstance();
            } catch (WSDL4ComplexWsdlException e) {
                throw new PoolException(e);
            }
        }

        @Override
        public WSDL4ComplexWsdlWriter create() {
            try {
                return this.wsdl4ComplexWsdlFactory.newWSDLWriter();
            } catch (WSDL4ComplexWsdlException e) {
                throw new PoolException(e);
            }
        }

        @Override
        public void onRelease(WSDL4ComplexWsdlWriter wsdl4ComplexWsdlWriter) {
        }

        @Override
        public void onTake(WSDL4ComplexWsdlWriter wsdl4ComplexWsdlWriter) {            
        }
    }
    
    private final GenericResourcePool<WSDL4ComplexWsdlWriter> wsdl4ComplexWsdlWriterResourcePool;

    /**
     * Allowing to instantiate a new {@link WSDL4ComplexWsdlWriterResourcePool} containing {@link WSDL4ComplexWsdlWriter} resources.
     * 
     * @param minPoolSize
     *            The minimum number of {@link WSDL4ComplexWsdlWriter} instances in the pool (created at the
     *            initialization).
     * @param maxPoolSize
     *            the maximum number of {@link WSDL4ComplexWsdlWriter} instances in the current pool (limit of the
     *            pool). It must be greater or equals to the specified minSize.
     *            The maximum value is Integer.MAX_VALUE
     * @param poolPolicy
     *            the {@link PoolPolicy} to adopt when the maximum size is reached. it
     *            must not be null.
     */
    public WSDL4ComplexWsdlWriterResourcePool(int minPoolSize, int maxPoolSize,
            PoolPolicy poolPolicy) {
        WSDL4ComplexWsdlWriterResourceHandler wsdl4ComplexWsdlWriterResourceHandler = new WSDL4ComplexWsdlWriterResourceHandler();
        this.wsdl4ComplexWsdlWriterResourcePool = new GenericResourcePool<WSDL4ComplexWsdlWriter>(
                wsdl4ComplexWsdlWriterResourceHandler, minPoolSize, maxPoolSize, poolPolicy);
    }

    /**
     * Take one unused {@link WSDL4ComplexWsdlWriter} in the current pool. After getting a
     * {@link WSDL4ComplexWsdlWriter} from the pool and before returning a
     * {@link WSDL4ComplexWsdlWriter}, the method onTake() of the {@link WSDL4ComplexWsdlWriter}
     * resource handler is called.
     * 
     * @return one {@link WSDL4ComplexWsdlWriter}
     * 
     * @throws PoolException
     *             if the current thread is interrupted for the pool policy WAIT
     *             or if there is no more available resource in the pool for the
     *             pool policy REJECT
     * 
     */
    public WSDL4ComplexWsdlWriter take() {
        return this.wsdl4ComplexWsdlWriterResourcePool.take();
    }

    /**
     * Release the specified {@link WSDL4ComplexWsdlWriter} After putting back the
     * {@link WSDL4ComplexWsdlWriter} in the pool, the method onRelease() of the
     * {@link WSDL4ComplexWsdlWriter} resource handler is called.
     * 
     * @param wsdl4ComplexWsdlWriter
     *            The {@link WSDL4ComplexWsdlWriter} to release
     */
    public final void release(final WSDL4ComplexWsdlWriter wsdl4ComplexWsdlWriter) {
        this.wsdl4ComplexWsdlWriterResourcePool.release(wsdl4ComplexWsdlWriter);
    }
}
