/****************************************************************************
 *
 * Copyright (c) 2008-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/
 
package org.ow2.easywsdl.extensions.wsdl4complexwsdl;

import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlWriter;

import com.ebmwebsourcing.easycommons.pooling.PoolException;
import com.ebmwebsourcing.easycommons.pooling.PoolPolicy;

/**
 * A static pool of {@link WSDL4ComplexWsdlWriter} to improve {@link WSDL4ComplexWsdlWriter} creation efficiency.
 * <p>
 * A {@link WSDL4ComplexWsdlWriter} is initialized the first time this class is used.
 * An infinite number (integer maximum value) of {@link WSDL4ComplexWsdlWriter} may be created. They are never evicted.
 * </p>
 * 
 * @author Nicolas Oddoux - EBM WebSourcing
 */
public final class WSDL4ComplexWsdlWriters {

    private static final WSDL4ComplexWsdlWriterResourcePool wsdl4ComplexWsdlWriterResourcePool = new WSDL4ComplexWsdlWriterResourcePool(1, Integer.MAX_VALUE, PoolPolicy.WAIT);

    /**
     * Take a {@link WSDL4ComplexWsdlWriter} from the pool
     * 
     * @return one {@link WSDL4ComplexWsdlWriter}
     * 
     * @throws PoolException
     *             if the current thread waits for a {@link WSDL4ComplexWsdlWriter}
     *             of the pool and is interrupted
     */
    public final static WSDL4ComplexWsdlWriter takeWSDL4ComplexWsdlWriter() throws PoolException {
       return wsdl4ComplexWsdlWriterResourcePool.take();
    }

    /**
     * Release a {@link WSDL4ComplexWsdlWriter} to the pool
     * 
     * @param wsdl4ComplexWsdlWriter a {@link WSDL4ComplexWsdlWriter} to release
     */
    public final static void releaseWSDL4ComplexWsdlWriter(WSDL4ComplexWsdlWriter wsdl4ComplexWsdlWriter) {
        wsdl4ComplexWsdlWriterResourcePool.release(wsdl4ComplexWsdlWriter);
    }
}
