/****************************************************************************
 *
 * Copyright (c) 2008-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/
 
package org.ow2.easywsdl.extensions.wsdl4complexwsdl.api;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;

import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLReader.FeatureConstants;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/**
 * This interface describes a collection of methods that enable conversion of a
 * WSDL document (in XML, following the WSDL schema described in the WSDL
 * specification) into a WSDL tag.
 * 
 * @author Nicolas Salatge - EBM WebSourcing
 */
public interface WSDL4ComplexWsdlReader {

    /**
     * Sets the specified feature to the specified value.
     * <p>
     * The minimum features that must be supported are:
     * <p>
     * <table border=1>
     * <tr>
     * <th>Name</th>
     * <th>DescriptionImpl</th>
     * <th>Default Value</th>
     * </tr>
     * <tr>
     * <td><center>org.ow2.easywsdl.schema.test.verbose</center></td>
     * <td>If set to true, status messages will be displayed.</td>
     * <td><center>type: boolean - default value: false</center></td>
     * </tr>
     * <tr>
     * <td><center>org.ow2.easywsdl.schema.test.importDocuments</center></td>
     * <td>If set to true, imported WSDL documents will be retrieved and
     * processed.</td>
     * <td><center>type: boolean - default value: true</center></td>
     * </tr>
     * <tr>
     * <td>
     * <center>org.ow2.easywsdl.schema.test.pathDirectoryOfImportLocations
     * </center></td>
     * <td>If the location is set, imported WSDL documents will be retrieved at
     * this location (Set the importDocuments Features at true).</td>
     * <td><center>type: String</center></td>
     * </tr>
     * </table>
     * <p>
     * All feature names must be fully-qualified, Java package style. All names
     * starting with om.ebmwebsourcing. are reserved for features defined by the
     * specification. It is recommended that implementation- specific features
     * be fully-qualified to match the package name of that implementation. For
     * example: com.abc.featureName
     * 
     * @param name
     *            the name of the feature to be set.
     * @param value
     *            the value to set the feature to.
     * @throws WSDLException
     *             TODO
     * @see #getFeature(String)
     */
    void setFeature(FeatureConstants name, Object value) throws WSDLException;

    /**
     * Gets the value of the specified feature.
     * 
     * @param name
     *            the name of the feature to get the value of.
     * @return the value of feature
     * @throws IllegalArgumentException
     *             if the feature name is not recognized.
     * @see #setFeature(String, boolean)
     */
    Object getFeature(FeatureConstants name);

    /**
     * Gets all features.
     * 
     * @return the features
     * @see #setFeature(String, boolean)
     */
    Map<FeatureConstants, Object> getFeatures();
    
    /**
     * <p>
     * Read the WSDL complex definition available at the location identified by
     * the specified URL, and bind it into a complex {@link Description} object.
     * </p>
     * <p>
     * <b>Note</b>: all relative URIs are resolved according to the specified
     * URL.
     * </p>
     * 
     * @param wsdlURL
     *            an URL pointing to a WSDL definition.
     * @return the {@link Description} definition.
     * @throws WSDL4ComplexWsdlException
     *             An error occurs during the parsing or the binding of the WSDL
     *             definition
     * @throws URISyntaxException
     *             If the URL is not formatted strictly according to to RFC2396
     *             and cannot be converted to a URI.
     * @throws IOException
     *             An I/O error occurs openning the URL stream.
     */
    Description read(final URL wsdlURL) throws WSDL4ComplexWsdlException, URISyntaxException, IOException;

    Description read(
			URL  wsdlURL, Map<URI, AbsItfDescription> descImports,
			Map<URI, AbsItfSchema> schemaImports) throws WSDLException;
    
    /**
     * <p>
     * Read the WSDL complex definition available at the specified
     * {@link InputSource}, and bind it into a complex {@link Description}
     * object.
     * </p>
     * <p>
     * <b>Note</b>: To be able to resolve relative URIs, the {@link InputSource}
     * system identifier must be set.
     * </p>
     * 
     * @param inputSource
     *            an {@link InputSource} pointing to a WSDL definition.
     * @return the {@link Description} definition.@throws MalformedURLException
     *         The {@link InputSource} system identifier is not a well-formed
     *         URL.
     * 
     * @throws WSDL4ComplexWsdlException
     *             An error occurs during the parsing or the binding of the WSDL
     *             definition.
     * @throws MalformedURLException
     *             The {@link InputSource} system identifier is not a
     *             well-formed URL.
     * @throws URISyntaxException
     *             the {@link InputSource} system identifier is not formatted
     *             strictly according to to RFC2396 and cannot be converted to a
     *             URI.
     */
    Description read(final InputSource wsdlInputSource) throws WSDL4ComplexWsdlException, MalformedURLException, URISyntaxException;
    
    /**
     * <p>
     * Read the WSDL complex definition available at the specified DOM {@link Document},
     * and bind it into a complex {@link Description} object.
     * </p>
     * <p>
     * <b>Note</b>: To be able to resolve relative URIs, the {@link Document}
     * base URI must be set.
     * </p>
     * 
     * @param document
     *            a DOM {@link Document} pointing to a WSDL definition.
     * @return the {@link Description} definition.
     * @throws WSDL4ComplexWsdlException
     *             An error occurs during the parsing or the binding of the WSDL
     *             definition
     * @throws URISyntaxException
     *             the DOM {@link Document} base URI is not formatted strictly
     *             according to to RFC2396 and cannot be converted to a URI.
     */
    Description read(final Document wsdlDocument) throws WSDL4ComplexWsdlException, URISyntaxException;

    /**
     * Read a WSDL document into a WSDL definition.
     * 
     * @param wslURI
     *            uri of the wsdl
     * @param inputSource
     *            an InputSource pointing to the WSDL document, an XML document
     *            obeying the WSDL schema.
     * @return the definition described in the document pointed to by the
     *         InputSource.
     */
    Description read(final InputSource doc, Map<URI, AbsItfDescription> descriptionImports, Map<URI, AbsItfSchema> schemaImports) throws WSDLException;
    
  /*  Description readWSDL4ComplexWsdl(URI wsdlURI, WSDLVersionConstants version, InputSource inputSource) throws WSDL4ComplexWsdlException;

    
	Description readWSDL4ComplexWsdl(final URI wsdlURI, Map<URI, AbsItfDescription> descriptionImports, Map<URI, AbsItfSchema> schemaImports) throws WSDLException;
	

	


	Description readWSDL4ComplexWsdl(final URI wsdlURI, WSDLVersionConstants version, InputSource source, Map<URI, AbsItfDescription> descriptionImports, Map<URI, AbsItfSchema> schemaImports) throws WSDLException;
*/
}
