/****************************************************************************
 *
 * Copyright (c) 2008-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/
 
package org.ow2.easywsdl.extensions.wsdl4complexwsdl.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Document;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.ImportedDocuments;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlException;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.SchemaReader;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.ow2.easywsdl.schema.api.extensions.NamespaceMapperImpl;
import org.ow2.easywsdl.schema.api.extensions.SchemaLocatorImpl;
import org.ow2.easywsdl.schema.impl.SchemaImpl;
import org.ow2.easywsdl.schema.impl.SchemaReaderImpl;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLImportException;
import org.ow2.easywsdl.wsdl.api.WSDLReader.FeatureConstants;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLElementImpl;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.org.w3.ns.wsdl.DescriptionType;
import org.ow2.easywsdl.wsdl.org.xmlsoap.schemas.wsdl.TDefinitions;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class DocumentImpl extends AbstractWSDLElementImpl<org.ow2.easywsdl.extensions.complexwsdl.Document> implements Document {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static Logger log = Logger.getLogger(DocumentImpl.class.getName());

	private Description imptDesc = null;

	private Schema imptSchema = null;
	
	private SchemaReader schemaReader = createSchemaReader();
	

    private static SchemaReader createSchemaReader() {
        try {
            return new SchemaReaderImpl();
        } catch (SchemaException e) {
            throw new RuntimeException(e);
        }
    }	


    public DocumentImpl(final org.ow2.easywsdl.extensions.complexwsdl.Document doc, final ImportedDocuments docs) throws WSDL4ComplexWsdlException {
		super(doc, (AbstractWSDLElementImpl) docs);
		try {
			if (doc.getDefinition() != null) {
				Map<FeatureConstants, Object> features = new HashMap<FeatureConstants, Object>();
				imptDesc = new org.ow2.easywsdl.wsdl.impl.wsdl11.DescriptionImpl(new URI("."), doc.getDefinition(), new NamespaceMapperImpl(), new SchemaLocatorImpl(), features, (Map<URI, AbsItfDescription>) docs.getAllDescriptions(), (Map<URI, AbsItfSchema>) docs.getAllSchemas(), null);
			} else if (doc.getDescription() != null) {
				Map<FeatureConstants, Object> features = new HashMap<FeatureConstants, Object>();
				imptDesc = new org.ow2.easywsdl.wsdl.impl.wsdl20.DescriptionImpl(new URI("."), doc.getDescription(), new NamespaceMapperImpl(), new SchemaLocatorImpl(), features, (Map<URI, AbsItfDescription>) docs.getAllDescriptions(), (Map<URI, AbsItfSchema>) docs.getAllSchemas(), null);
			} else if (doc.getSchema() != null) {
				Map<org.ow2.easywsdl.schema.api.SchemaReader.FeatureConstants, Object> features = new HashMap<org.ow2.easywsdl.schema.api.SchemaReader.FeatureConstants, Object>();
				imptSchema = new SchemaImpl(new URI("."), doc.getSchema(), new NamespaceMapperImpl(), new SchemaLocatorImpl(), features, (Map<URI, AbsItfSchema>) docs.getAllSchemas(), (SchemaReaderImpl) schemaReader);
				((SchemaImpl) imptSchema).initialize();
			}
		} catch (WSDLException e) {
			throw new WSDL4ComplexWsdlException(e);
		} catch (WSDLImportException e) {
			throw new WSDL4ComplexWsdlException(e);
		} catch (URISyntaxException e) {
			throw new WSDL4ComplexWsdlException(e);
		} catch (SchemaException e) {
			throw new WSDL4ComplexWsdlException(e);
		}
	}

	public URI getLocation() {
		URI res = null;
		if(this.model.getLocation() != null) {
			res = URI.create(this.model.getLocation());
		}
		return res;
	}

	public void setLocation(URI location) {
		this.model.setLocation(location.toString());
	}

	public Description getImportedDescription() {
		return this.imptDesc;
	}

	public Schema getImportedSchema() {
		return this.imptSchema;
	}

	public void setImportedDescription(Description desc) {
		this.imptDesc = desc;
		if (((AbstractWSDLElementImpl) desc).getModel() instanceof TDefinitions) {
			this.model.setDefinition((TDefinitions) ((AbstractWSDLElementImpl) desc).getModel());
		} else if (((AbstractWSDLElementImpl) desc).getModel() instanceof DescriptionType) {
			this.model.setDescription((DescriptionType) ((AbstractWSDLElementImpl) desc).getModel());
		}
	}

	public void setImportedSchema(Schema schema) {
		this.imptSchema = schema;
		this.model.setSchema((org.ow2.easywsdl.schema.org.w3._2001.xmlschema.Schema) ((AbstractSchemaElementImpl) schema).getModel());
	}

	public URI getOriginalLocation() {
		return URI.create(this.model.getOriginalLocation());
	}

	public void setOriginalLocation(URI originalLocation) {
		this.model.setOriginalLocation(originalLocation.toString());
	}
}
