/****************************************************************************
 *
 * Copyright (c) 2008-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/
 
package org.ow2.easywsdl.extensions.wsdl4complexwsdl.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Document;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.ImportedDocuments;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlException;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLElementImpl;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;

/** 
* @author Nicolas Salatge - EBM WebSourcing
*/
public class ImportedDocumentsImpl extends AbstractWSDLElementImpl<org.ow2.easywsdl.extensions.complexwsdl.ImportedDocuments> implements ImportedDocuments {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private List<Document> documents = new ArrayList<Document>();
	
	private Description description = null;
	
    public ImportedDocumentsImpl(final org.ow2.easywsdl.extensions.complexwsdl.ImportedDocuments documents, final Description desc) throws WSDL4ComplexWsdlException {
        super(documents, (AbstractWSDLElementImpl) desc);
        this.description = desc;

     
        for(org.ow2.easywsdl.extensions.complexwsdl.Document doc: this.model.getDocument()) {
        	this.documents.add(new DocumentImpl(doc, this));
        }
    }

	/**
	 * @return the desc
	 */
	public Description getDescription() {
		return description;
	}

	public void addDocument(Document doc) {
		this.model.getDocument().add((org.ow2.easywsdl.extensions.complexwsdl.Document) ((AbstractWSDLElementImpl)doc).getModel());
		this.documents.add(doc);
	}

	public List<Document> getDocuments() {
		return this.documents;
	}

	public void addAllDocuments(Collection<Document> docs) {
		for(Document doc: docs) {
			this.addDocument(doc);
		}
	}
	
	public Map<URI, AbsItfDescription> getAllDescriptions() {
		Map<URI, AbsItfDescription> res = new HashMap<URI, AbsItfDescription>();
		for(Document doc: this.documents) {
			if(doc.getImportedDescription() != null) {
				res.put(doc.getImportedDescription().getDocumentBaseURI(), doc.getImportedDescription());
			}
		}
		return res;
	}
	
	public Map<URI, AbsItfSchema> getAllSchemas() {
		Map<URI, AbsItfSchema> res = new HashMap<URI, AbsItfSchema>();
		for(Document doc: this.documents) {
			if(doc.getImportedSchema() != null) {
				res.put(doc.getImportedSchema().getDocumentURI(), doc.getImportedSchema());
			}
		}
		return res;
	}
	
}
