/****************************************************************************
 *
 * Copyright (c) 2008-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/
 
package org.ow2.easywsdl.extensions.wsdl4complexwsdl.impl.inout;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.ow2.easywsdl.extensions.complexwsdl.ImportedDocuments;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.WSDL4ComplexWsdlFactory;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Description;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlException;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlReader;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.impl.DescriptionImpl;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.impl.WSDL4ComplexWsdlJAXBContext;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.util.ImportedDocumentsFilter;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.schema.util.SourceHelper;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLReader;
import org.ow2.easywsdl.wsdl.api.WSDLReader.FeatureConstants;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLReaderImpl;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.impl.generic.WSDLReaderImpl;
import org.ow2.easywsdl.wsdl.util.InputStreamForker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

import com.ebmwebsourcing.easycommons.xml.Transformers;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class WSDL4ComplexWsdlReaderImpl implements WSDL4ComplexWsdlReader {

	private WSDLReader reader = null;

	
	public WSDL4ComplexWsdlReaderImpl() throws WSDL4ComplexWsdlException {
		try {
			WSDLFactory factory = WSDLFactory.newInstance();
			//factory.setJAXBObjectFactoryList(WSDL4ComplexWsdlJAXBContext.getInstance().getDefaultObjectFactories());
			this.reader = factory.newWSDLReader();
			this.reader.getFeatures().put(FeatureConstants.IMPORT_DOCUMENTS, false);

		} catch (final WSDLException e) {
			throw new WSDL4ComplexWsdlException(e);
		} 
	}

	public Object getFeature(final FeatureConstants name) {
		return this.reader.getFeature(name);
	}

	public Map<FeatureConstants, Object> getFeatures() {
		return this.reader.getFeatures();
	}

	public void setFeatures(final Map<FeatureConstants, Object> features) {
		((AbstractWSDLReaderImpl) this.reader).setFeatures(features);
	}

	/**
	 * {@inheritDoc}
	 * 
	 */
	public Description read(final URL wsdlURL) throws WSDL4ComplexWsdlException, IOException, URISyntaxException {
		try {
			InputSource inputSource = new InputSource(wsdlURL.openStream());
			inputSource.setSystemId(wsdlURL.toString());

			return this.read(inputSource);
		} catch (final MalformedURLException e) {
			throw new RuntimeException("The provided well-formed URL has been detected as malformed !!");
		}
	}

	/**
	 * {@inheritDoc}
	 * 
	 */
	public Description read(final InputSource wsdlInputSource) throws WSDL4ComplexWsdlException, MalformedURLException, URISyntaxException {
		Description res = null;
		try {

			final String systemId = wsdlInputSource.getSystemId();
			if (systemId != null ) {
				((WSDLReaderImpl)this.reader).setDocumentBaseURI(new URI(systemId));
			}

			final InputStream wsdlInputStream = wsdlInputSource.getByteStream();
			if (wsdlInputStream == null) {
				throw new UnsupportedOperationException("This method supports only InputSource with byte stream.");
			}
			else {
				InputStreamForker isf = new InputStreamForker(wsdlInputStream);
				InputStreamForker isf2 = new InputStreamForker(isf.getInputStreamOne());
				wsdlInputSource.setByteStream(isf.getInputStreamTwo());

				DOMSource source = SourceHelper.convertInputSource2DOMSource(wsdlInputSource);

				ImportedDocumentsFilter filter = new ImportedDocumentsFilter((Document) source.getNode(), this);

				wsdlInputSource.setByteStream(isf2.getInputStreamOne());


				org.ow2.easywsdl.wsdl.api.Description desc = this.reader.read(wsdlInputSource, filter.getDescriptions(), filter.getSchemas());
				res = new DescriptionImpl(desc);
					
				//	WSDL4ComplexWsdlFactory.newInstance().addComplexWsdlElmt2Description(desc);

			//	InputSource wsdlInputSource2 = SourceHelper.convertDOMSource2InputSource(new DOMSource((Document) source.getNode()));
			//	wsdlInputSource2.setSystemId(systemId);
				wsdlInputSource.setByteStream(isf2.getInputStreamTwo());
				
				if(res.getImportedDocuments() != null) {
					Map<URI, AbsItfDescription> descImports = new HashMap<URI, AbsItfDescription>();
					Map<URI, AbsItfSchema> schemaImports = new HashMap<URI, AbsItfSchema>();

					for(org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Document doc: res.getImportedDocuments().getDocuments()) {
						if(doc.getImportedDescription() != null) {
							ImportedDocumentsFilter.attachDescriptionInAllImportsAndIncludes(doc.getImportedDescription(), filter.getDescriptions(), filter.getSchemas());
							descImports.put(doc.getLocation(), doc.getImportedDescription());
						} else if(doc.getImportedSchema() != null) {
							ImportedDocumentsFilter.attachSchemaInAllImportsAndIncludes(doc.getImportedSchema(), filter.getSchemas());
							schemaImports.put(doc.getLocation(), doc.getImportedSchema());
						}
					}
					
//					this.reader.getFeatures().put(FeatureConstants.IMPORT_DOCUMENTS, true);
//					desc = this.reader.read(wsdlInputSource2, descImports, schemaImports);
//					res = WSDL4ComplexWsdlFactory.newInstance().addComplexWsdlElmt2Description(desc);
//					this.reader.getFeatures().put(FeatureConstants.IMPORT_DOCUMENTS, false);

				} else {
					this.reader.getFeatures().put(FeatureConstants.IMPORT_DOCUMENTS, true);
					desc = this.reader.read(wsdlInputSource);
					res = new DescriptionImpl(desc);
					//res = WSDL4ComplexWsdlFactory.newInstance().addComplexWsdlElmt2Description(desc);
					this.reader.getFeatures().put(FeatureConstants.IMPORT_DOCUMENTS, false);
				}
			}
		} catch (final WSDLException e) {
			throw new WSDL4ComplexWsdlException(e);
		} catch (IOException e) {
			throw new WSDL4ComplexWsdlException(e);
		} catch (XmlException e) {
			throw new WSDL4ComplexWsdlException(e);
		}
		return res;
	}

	/**
	 * {@inheritDoc}
	 * 
	 */
	public Description read(final Document wsdlDocument) throws WSDL4ComplexWsdlException, URISyntaxException {
		Description res = null;
		if(wsdlDocument == null) {
			throw new WSDL4ComplexWsdlException("Document cannot be null!!!");
		}
        // The DOM Document needs to be converted into an InputStource
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        final StreamResult streamResult = new StreamResult(baos);
        
        // FIXME: The Transformer creation is not thread-safe
        Transformer transformer = null;
        try {
            transformer = Transformers.takeTransformer();
            transformer.transform(new DOMSource(wsdlDocument), streamResult);

            final InputSource documentInputSource = new InputSource(new ByteArrayInputStream(
                    baos.toByteArray()));
            documentInputSource.setSystemId(wsdlDocument.getBaseURI());
            baos.flush();
            baos.close();

            res = this.read(documentInputSource);
        } catch (final TransformerException e) {
            throw new WSDL4ComplexWsdlException(e);
        } catch (final IOException e) {
            throw new WSDL4ComplexWsdlException(e);
        } catch (WSDLException e) {
            throw new WSDL4ComplexWsdlException(e);
        } finally {
            if (transformer != null) {
                Transformers.releaseTransformer(transformer);
            }
        }
	        
		return res;
	}

	/*	public Description readWSDL4ComplexWsdl(final URI wsdlURI, WSDLVersionConstants version, final InputSource inputSource) throws WSDL4ComplexWsdlException {
		Description res = null;
		try {
			final org.ow2.easywsdl.wsdl.api.Description desc = this.reader.readWSDL(wsdlURI,
					version, inputSource);
			res = WSDL4ComplexWsdlFactory.newInstance().addComplexWsdlElmt2Description(desc);
		} catch (final WSDLException e) {
			throw new WSDL4ComplexWsdlException(e);
		}
		return res;
	}*/

	public void setFeature(final FeatureConstants name, final Object value) throws WSDLException {
		this.reader.setFeature(name, value);
	}


	public JAXBElement<ImportedDocuments> convertElement2ImportedDocuments(final Element imptDocs)
	throws WSDLException {
		JAXBElement<ImportedDocuments> res = null;
		try {
			res = WSDL4ComplexWsdlJAXBContext.getInstance().getJaxbContext().createUnmarshaller().unmarshal(imptDocs, ImportedDocuments.class);
		} catch (final JAXBException e) {
			throw new WSDLException(
					"Failed to build Java bindings from WSDL descriptor XML document", e);
		}
		return res;
	}
	
	public JAXBElement<org.ow2.easywsdl.extensions.complexwsdl.Document> convertElement2Document(final Element imptDocs)
	throws WSDLException {
		JAXBElement<org.ow2.easywsdl.extensions.complexwsdl.Document> res = null;
		try {
			res = WSDL4ComplexWsdlJAXBContext.getInstance().getJaxbContext().createUnmarshaller().unmarshal(imptDocs, org.ow2.easywsdl.extensions.complexwsdl.Document.class);
		} catch (final JAXBException e) {
			throw new WSDLException(
					"Failed to build Java bindings from WSDL descriptor XML document", e);
		}
		return res;
	}

	/*public Description readWSDL4ComplexWsdl(
			URI wsdlURI, Map<URI, AbsItfDescription> descImports,
			Map<URI, AbsItfSchema> schemaImports) throws WSDLException {
		Description res = null;
		try {
			org.ow2.easywsdl.wsdl.api.Description desc = this.reader.readWSDL(wsdlURI);
			res = WSDL4ComplexWsdlFactory.newInstance().addComplexWsdlElmt2Description(desc);

			if(res.getImportedDocuments() != null) {
				this.reader.getFeatures().put(FeatureConstants.IMPORT_DOCUMENTS, false);
				desc = this.reader.readWSDL(wsdlURI, descImports, schemaImports);
				res = WSDL4ComplexWsdlFactory.newInstance().addComplexWsdlElmt2Description(desc);
				this.reader.getFeatures().put(FeatureConstants.IMPORT_DOCUMENTS, false);

			} else {
				this.reader.getFeatures().put(FeatureConstants.IMPORT_DOCUMENTS, false);
				desc = this.reader.readWSDL(wsdlURI);
				res = WSDL4ComplexWsdlFactory.newInstance().addComplexWsdlElmt2Description(desc);
				this.reader.getFeatures().put(FeatureConstants.IMPORT_DOCUMENTS, false);
			}
		} catch (final WSDLException e) {
			throw new WSDL4ComplexWsdlException(e);
		} 
		return res;
	}*/


	public Description read(
			URL  wsdlURL, Map<URI, AbsItfDescription> descImports,
			Map<URI, AbsItfSchema> schemaImports) throws WSDLException {
		try {
			InputSource inputSource = new InputSource(wsdlURL.openStream());
			inputSource.setSystemId(wsdlURL.toString());

			return this.read(inputSource, descImports, schemaImports);
		} catch (final MalformedURLException e) {
			throw new WSDLException("The provided well-formed URL has been detected as malformed !!");
		} catch (IOException e) {
			throw new WSDLException("The provided well-formed URL has been detected as malformed !!");
		}
	}

	public Description read(
			InputSource  wsdlsource, Map<URI, AbsItfDescription> descImports,
			Map<URI, AbsItfSchema> schemaImports) throws WSDLException {
		Description res = null;
		try {
			if (wsdlsource.getByteStream() != null) {
				final InputStream originalInputStream = wsdlsource.getByteStream();

				wsdlsource.setByteStream(originalInputStream);
				org.ow2.easywsdl.wsdl.api.Description desc = this.reader.read(wsdlsource, descImports, schemaImports);
				res = WSDL4ComplexWsdlFactory.newInstance().addComplexWsdlElmt2Description(desc);
				this.reader.getFeatures().put(FeatureConstants.IMPORT_DOCUMENTS, false);
				
				originalInputStream.close();
			}
		} catch (final WSDLException e) {
			throw new WSDL4ComplexWsdlException(e);
		} catch (IOException e) {
			throw new WSDL4ComplexWsdlException(e);
		} catch (URISyntaxException e) {
			throw new WSDL4ComplexWsdlException(e);
		} 
		return res;
	}

	/*	public Description readWSDL4ComplexWsdl(
			URI wsdlURI, WSDLVersionConstants version, InputSource source,
			Map<URI, AbsItfDescription> descImports,
			Map<URI, AbsItfSchema> schemaImports) throws WSDLException {
		Description res = null;
		try {
			org.ow2.easywsdl.wsdl.api.Description desc = this.reader.readWSDL(wsdlURI);
			res = WSDL4ComplexWsdlFactory.newInstance().addComplexWsdlElmt2Description(desc);

			if(res.getImportedDocuments() != null) {
				this.reader.getFeatures().put(FeatureConstants.IMPORT_DOCUMENTS, false);
				desc = this.reader.readWSDL(wsdlURI, version, source, descImports, schemaImports);
				res = WSDL4ComplexWsdlFactory.newInstance().addComplexWsdlElmt2Description(desc);
				this.reader.getFeatures().put(FeatureConstants.IMPORT_DOCUMENTS, false);

			} else {
				this.reader.getFeatures().put(FeatureConstants.IMPORT_DOCUMENTS, false);
				desc = this.reader.readWSDL(wsdlURI, version, source, descImports, schemaImports);
				res = WSDL4ComplexWsdlFactory.newInstance().addComplexWsdlElmt2Description(desc);
				this.reader.getFeatures().put(FeatureConstants.IMPORT_DOCUMENTS, false);
			}
		} catch (final WSDLException e) {
			throw new WSDL4ComplexWsdlException(e);
		} 
		return res;
	}*/
}
