/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.schema.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.ow2.easywsdl.schema.SchemaFactory;
import org.ow2.easywsdl.schema.api.ComplexContent;
import org.ow2.easywsdl.schema.api.ComplexType;
import org.ow2.easywsdl.schema.api.Element;
import org.ow2.easywsdl.schema.api.Enumeration;
import org.ow2.easywsdl.schema.api.Extension;
import org.ow2.easywsdl.schema.api.Import;
import org.ow2.easywsdl.schema.api.Include;
import org.ow2.easywsdl.schema.api.Restriction;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.Sequence;
import org.ow2.easywsdl.schema.api.SimpleType;
import org.ow2.easywsdl.schema.api.absItf.AbsItfComplexContent;
import org.ow2.easywsdl.schema.api.absItf.AbsItfElement;
import org.ow2.easywsdl.schema.api.absItf.AbsItfEnumeration;
import org.ow2.easywsdl.schema.api.absItf.AbsItfExtension;
import org.ow2.easywsdl.schema.api.absItf.AbsItfImport;
import org.ow2.easywsdl.schema.api.absItf.AbsItfInclude;
import org.ow2.easywsdl.schema.api.absItf.AbsItfRestriction;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSequence;
import org.ow2.easywsdl.schema.api.absItf.AbsItfType;
import org.xml.sax.InputSource;

public class CreateSchemaDescriptorTestCase
extends TestCase {
    private String TARGET_NAMESPACE = "http://petals.ow2.org/";

    private QName cName(String name) {
        return new QName(this.TARGET_NAMESPACE, name);
    }

    public void testCreateSchema() throws URISyntaxException, SchemaException, MalformedURLException {
        Schema createdSchema = SchemaFactory.newInstance().newSchema();
        Assert.assertNotNull((String)"Unable to create a new Schema.", (Object)createdSchema);
        createdSchema.setTargetNamespace(this.TARGET_NAMESPACE);
        Import impt = (Import)createdSchema.createImport();
        impt.setLocationURI(URI.create("descriptors/reservationDetails.xsd"));
        impt.setNamespaceURI("http://greath.example.com/2004/schemas/reservationDetails");
        createdSchema.addImport((AbsItfImport)impt);
        Include incl = (Include)createdSchema.createInclude();
        incl.setLocationURI(URI.create("descriptors/wsdl20-instance.xsd"));
        createdSchema.addInclude((AbsItfInclude)incl);
        Element element = (Element)createdSchema.createElement();
        element.setQName(this.cName("count"));
        element.setType((AbsItfType)SchemaFactory.getDefaultSchema().getTypeInt());
        createdSchema.addElement((AbsItfElement)element);
        ComplexType ct = (ComplexType)createdSchema.createComplexType();
        ct.setQName(this.cName("Address"));
        createdSchema.addType((AbsItfType)ct);
        SimpleType st = (SimpleType)createdSchema.createSimpleType();
        Restriction rest = (Restriction)st.createRestriction();
        rest.setBase(SchemaFactory.getDefaultSchema().getTypeString().getQName());
        Enumeration enum1 = (Enumeration)rest.createEnumeration();
        enum1.setValue("Paris");
        rest.addEnumeration((AbsItfEnumeration)enum1);
        Enumeration enum2 = (Enumeration)rest.createEnumeration();
        enum2.setValue("London");
        rest.addEnumeration((AbsItfEnumeration)enum2);
        st.setRestriction((AbsItfRestriction)rest);
        Sequence seq = (Sequence)ct.createSequence();
        Element elmt1 = (Element)seq.createElement();
        elmt1.setQName(this.cName("city"));
        elmt1.setType((AbsItfType)st);
        elmt1.setMinOccurs(0);
        elmt1.setMaxOccurs("unbounded");
        seq.addElement((AbsItfElement)elmt1);
        ct.setSequence((AbsItfSequence)seq);
        ComplexType ctEx = (ComplexType)createdSchema.createComplexType();
        ctEx.setQName(this.cName("AddressExtended"));
        ComplexContent cc = (ComplexContent)ctEx.createComplexContent();
        ctEx.setComplexContent((AbsItfComplexContent)cc);
        Extension ex = (Extension)cc.createExtension();
        ex.setBase((AbsItfType)ct);
        cc.setExtension((AbsItfExtension)ex);
        Sequence s = (Sequence)ex.createSequence();
        ex.setSequence((AbsItfSequence)s);
        Element e = (Element)s.createElement();
        e.setQName(this.cName("postcode"));
        e.setType((AbsItfType)SchemaFactory.getDefaultSchema().getTypeInt());
        s.addElement((AbsItfElement)e);
        createdSchema.addType((AbsItfType)ctEx);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SchemaFactory.newInstance().newSchemaWriter().writeSchema(createdSchema, (OutputStream)baos);
        InputSource xsdInputSource = new InputSource(new ByteArrayInputStream(baos.toByteArray()));
        URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors");
        xsdInputSource.setSystemId(xsdUrl.toString());
        Schema readSchema = SchemaFactory.newInstance().newSchemaReader().read(xsdInputSource);
        Assert.assertNotNull((String)"Unable to read the previous created Schema.", (Object)readSchema);
        Assert.assertEquals((String)"The expected import number isn't correct in the create schema.", (int)1, (int)readSchema.getImports().size());
        Assert.assertEquals((String)"The expected include number isn't correct in the create schema.", (int)1, (int)readSchema.getIncludes().size());
        Assert.assertEquals((String)"The expected type number isn't correct in the create schema.", (int)3, (int)readSchema.getTypes().size());
        Assert.assertEquals((String)"The expected element number isn't correct in the create schema.", (int)7, (int)readSchema.getElements().size());
        Assert.assertEquals((String)"The expected attribute number isn't correct in the create schema.", (int)1, (int)readSchema.getAttributes().size());
    }
}

