/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.schema;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.schema.DefaultSchema;
import org.ow2.easywsdl.schema.api.Documentation;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.Type;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.api.absItf.AbsItfAttribute;
import org.ow2.easywsdl.schema.api.absItf.AbsItfElement;
import org.ow2.easywsdl.schema.api.absItf.AbsItfImport;
import org.ow2.easywsdl.schema.api.absItf.AbsItfInclude;
import org.ow2.easywsdl.schema.api.absItf.AbsItfRedefine;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.schema.api.absItf.AbsItfType;
import org.ow2.easywsdl.schema.api.extensions.NamespaceMapperImpl;
import org.ow2.easywsdl.schema.impl.SchemaJAXBContext;
import org.ow2.easywsdl.schema.impl.SchemaReaderImpl;
import org.ow2.easywsdl.schema.org.w3._2001.xmlschema.FormChoice;

public final class DefaultSchemaImpl
implements DefaultSchema {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(DefaultSchemaImpl.class.getName());
    private static AbsItfSchema defaultSchema = null;
    private static final DefaultSchemaImpl INSTANCE;

    private DefaultSchemaImpl() {
    }

    public static DefaultSchema getInstance() {
        return INSTANCE;
    }

    @Override
    public Type getTypeInt() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "int"));
    }

    @Override
    public Type getTypeString() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "string"));
    }

    @Override
    public Type getTypeDateTime() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
    }

    @Override
    public Type getTypeBoolean() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "boolean"));
    }

    @Override
    public List<Type> getTypes() {
        List list = null;
        if (defaultSchema != null) {
            list = defaultSchema.getTypes();
        }
        return list;
    }

    @Override
    public Type getType(QName qName) {
        Type type = null;
        for (Type type2 : this.getTypes()) {
            if (!type2.getQName().getNamespaceURI().equals(qName.getNamespaceURI()) || !type2.getQName().getLocalPart().equals(qName.getLocalPart())) continue;
            type = type2;
            break;
        }
        return type;
    }

    @Override
    public Type getTypeDouble() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "double"));
    }

    @Override
    public Type getTypeDuration() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "duration"));
    }

    @Override
    public Type getTypeFloat() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "float"));
    }

    @Override
    public Type getTypeInteger() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "integer"));
    }

    @Override
    public Type getTypeLong() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "long"));
    }

    @Override
    public Type getTypeShort() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "short"));
    }

    public void addAttribute(AbsItfAttribute absItfAttribute) {
        defaultSchema.addAttribute(absItfAttribute);
    }

    public void addElement(AbsItfElement absItfElement) {
        defaultSchema.addElement(absItfElement);
    }

    public void addImport(AbsItfImport absItfImport) {
        defaultSchema.addImport(absItfImport);
    }

    public void addInclude(AbsItfInclude absItfInclude) throws SchemaException {
        defaultSchema.addInclude(absItfInclude);
    }

    public void addRedefine(AbsItfRedefine absItfRedefine) {
        defaultSchema.addRedefine(absItfRedefine);
    }

    public void addType(AbsItfType absItfType) {
        defaultSchema.addType(absItfType);
    }

    public AbsItfAttribute createAttribute() {
        return defaultSchema.createAttribute();
    }

    public AbsItfType createComplexType() {
        return defaultSchema.createComplexType();
    }

    public AbsItfElement createElement() {
        return defaultSchema.createElement();
    }

    public AbsItfImport createImport() throws SchemaException {
        return defaultSchema.createImport();
    }

    public AbsItfInclude createInclude() throws SchemaException {
        return defaultSchema.createInclude();
    }

    public AbsItfRedefine createRedefine() throws SchemaException {
        return defaultSchema.createRedefine();
    }

    public AbsItfType createSimpleType() {
        return defaultSchema.createSimpleType();
    }

    public List<AbsItfElement> findElementsInAllSchema(QName qName) {
        return defaultSchema.findElementsInAllSchema(qName);
    }

    @Override
    public NamespaceMapperImpl getAllNamespaces() {
        return defaultSchema.getAllNamespaces();
    }

    public AbsItfAttribute getAttribute(QName qName) {
        return defaultSchema.getAttribute(qName);
    }

    public List<AbsItfAttribute> getAttributes() {
        return defaultSchema.getAttributes();
    }

    @Override
    public List<String> getBlockDefault() {
        return defaultSchema.getBlockDefault();
    }

    @Override
    public URI getDocumentURI() {
        return defaultSchema.getDocumentURI();
    }

    public AbsItfElement getElement(QName qName) {
        return defaultSchema.getElement(qName);
    }

    public List<AbsItfElement> getElements() {
        return defaultSchema.getElements();
    }

    @Override
    public List<String> getFinalDefault() {
        return defaultSchema.getFinalDefault();
    }

    public List<AbsItfImport> getImports(String string) {
        return defaultSchema.getImports(string);
    }

    public List<AbsItfImport> getImports() {
        return defaultSchema.getImports();
    }

    public List<AbsItfInclude> getIncludes(URI uRI) throws URISyntaxException {
        return defaultSchema.getIncludes(uRI);
    }

    public List<AbsItfInclude> getIncludes() {
        return defaultSchema.getIncludes();
    }

    public List<AbsItfRedefine> getRedefines(String string) {
        return defaultSchema.getRedefines(string);
    }

    public List<AbsItfRedefine> getRedefines() {
        return defaultSchema.getRedefines();
    }

    @Override
    public String getLang() {
        return defaultSchema.getLang();
    }

    @Override
    public String getTargetNamespace() {
        return defaultSchema.getTargetNamespace();
    }

    @Override
    public String getVersion() {
        return defaultSchema.getVersion();
    }

    public AbsItfImport removeImport(AbsItfImport absItfImport) {
        return defaultSchema.removeImport(absItfImport);
    }

    public AbsItfInclude removeInclude(AbsItfInclude absItfInclude) throws SchemaException {
        return defaultSchema.removeInclude(absItfInclude);
    }

    public AbsItfRedefine removeRedefine(AbsItfRedefine absItfRedefine) {
        return defaultSchema.removeRedefine(absItfRedefine);
    }

    @Override
    public void setDocumentURI(URI uRI) {
        defaultSchema.setDocumentURI(uRI);
    }

    @Override
    public void setTargetNamespace(String string) {
        defaultSchema.setTargetNamespace(string);
    }

    @Override
    public Map<QName, String> getOtherAttributes() throws XmlException {
        return defaultSchema.getOtherAttributes();
    }

    @Override
    public void setDocumentation(Documentation documentation) {
        defaultSchema.setDocumentation(documentation);
    }

    @Override
    public FormChoice getAttributeFormDefault() {
        return defaultSchema.getAttributeFormDefault();
    }

    @Override
    public FormChoice getElementFormDefault() {
        return defaultSchema.getElementFormDefault();
    }

    @Override
    public void setAttributeFormDefault(FormChoice formChoice) {
        defaultSchema.setAttributeFormDefault(formChoice);
    }

    @Override
    public void setElementFormDefault(FormChoice formChoice) {
        defaultSchema.setElementFormDefault(formChoice);
    }

    @Override
    public Documentation createDocumentation() {
        return defaultSchema.createDocumentation();
    }

    @Override
    public Documentation getDocumentation() {
        return defaultSchema.getDocumentation();
    }

    static {
        URL uRL = SchemaJAXBContext.class.getResource("/schema/XMLSchemaWithoutDTD.xsd");
        try {
            defaultSchema = new SchemaReaderImpl().read(uRL);
        }
        catch (XmlException xmlException) {
            xmlException.printStackTrace();
            LOG.warning("Error to read default parent => " + xmlException.getMessage());
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            LOG.warning("Error to read default parent => " + uRISyntaxException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            LOG.warning("I/O error reading " + uRL.toString() + " : " + iOException.getMessage());
        }
        INSTANCE = new DefaultSchemaImpl();
    }
}

