/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.schema.impl;

import com.ebmwebsourcing.easycommons.xml.Transformers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.SchemaReader;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaReader;
import org.ow2.easywsdl.schema.impl.SchemaImpl;
import org.ow2.easywsdl.schema.impl.SchemaJAXBContext;
import org.ow2.easywsdl.schema.util.EasyXMLFilter;
import org.ow2.easywsdl.schema.util.URILocationResolver;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SchemaReaderImpl
extends AbstractSchemaReader
implements SchemaReader {
    private static final Logger LOG = Logger.getLogger(SchemaReaderImpl.class.getName());
    private Map<SchemaReader.FeatureConstants, Object> features = new HashMap<SchemaReader.FeatureConstants, Object>();
    private Map<URI, AbsItfSchema> importList = new HashMap<URI, AbsItfSchema>();
    private final URILocationResolver schemaLocationResolver = new URILocationResolver();
    private URI documentBaseURI;
    private static SchemaJAXBContext jaxbcontext = null;
    private static SchemaException contextException = null;

    public static SchemaJAXBContext getJaxbContext() throws SchemaException {
        if (contextException != null) {
            throw contextException;
        }
        return jaxbcontext;
    }

    public SchemaReaderImpl() throws SchemaException {
        SchemaReaderImpl.getJaxbContext();
        this.features.put(SchemaReader.FeatureConstants.VERBOSE, false);
        this.features.put(SchemaReader.FeatureConstants.IMPORT_DOCUMENTS, true);
    }

    @Override
    public void setDocumentBaseURI(URI uRI) {
        this.documentBaseURI = uRI;
    }

    @Override
    public URI getDocumentBaseURI() {
        return this.documentBaseURI;
    }

    @Override
    public Schema read(URL uRL) throws SchemaException, URISyntaxException, IOException {
        InputStream inputStream = uRL.openStream();
        try {
            Schema schema;
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(uRL.toString());
            Schema schema2 = schema = this.read(inputSource);
            return schema2;
        }
        catch (MalformedURLException malformedURLException) {
            throw new SchemaException("The provided well-formed URL has been detected as malformed !!", malformedURLException);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    @Override
    public Schema read(InputSource inputSource) throws SchemaException, URISyntaxException, MalformedURLException {
        this.documentBaseURI = inputSource.getSystemId() != null ? new URI(inputSource.getSystemId()) : new URI(".");
        return this.readSchema(inputSource, new HashMap<URI, AbsItfSchema>());
    }

    @Override
    public Schema read(Document document) throws SchemaException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(byteArrayOutputStream);
        Transformer transformer = null;
        try {
            transformer = Transformers.takeTransformer();
            transformer.transform(new DOMSource(document), streamResult);
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            InputSource inputSource = new InputSource(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            inputSource.setSystemId(document.getBaseURI());
            Schema schema = this.read(inputSource);
            return schema;
        }
        catch (TransformerException transformerException) {
            throw new SchemaException(transformerException);
        }
        catch (IOException iOException) {
            throw new SchemaException(iOException);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SchemaException(uRISyntaxException);
        }
        finally {
            if (transformer != null) {
                Transformers.releaseTransformer((Transformer)transformer);
            }
        }
    }

    @Override
    protected Schema readExternalPart(URI uRI, URI uRI2, Map<URI, AbsItfSchema> map) throws SchemaException, MalformedURLException, URISyntaxException {
        InputStream inputStream = null;
        try {
            Schema schema;
            inputStream = this.schemaLocationResolver.resolve(uRI2, uRI).openStream();
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(this.schemaLocationResolver.resolve(uRI2, uRI).toString());
            Schema schema2 = schema = this.readSchema(inputSource, map, false);
            return schema2;
        }
        catch (IOException iOException) {
            throw new SchemaException(iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    protected Schema readSchema(InputSource inputSource, Map<URI, AbsItfSchema> map) throws SchemaException, MalformedURLException, URISyntaxException {
        return this.readSchema(inputSource, map, true);
    }

    private Schema readSchema(InputSource inputSource, Map<URI, AbsItfSchema> map, boolean bl) throws SchemaException, MalformedURLException, URISyntaxException {
        try {
            URI uRI;
            String string = inputSource.getSystemId();
            if (string != null) {
                uRI = new URI(string);
                this.setDocumentBaseURI(uRI);
            } else {
                uRI = new File(".").toURI();
            }
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            EasyXMLFilter easyXMLFilter = new EasyXMLFilter(xMLReader);
            SAXSource sAXSource = new SAXSource(easyXMLFilter, inputSource);
            LOG.fine("Loading " + uRI);
            JAXBElement jAXBElement = SchemaReaderImpl.getJaxbContext().getJaxbContext().createUnmarshaller().unmarshal((Source)sAXSource, org.ow2.easywsdl.schema.org.w3._2001.xmlschema.Schema.class);
            org.ow2.easywsdl.schema.org.w3._2001.xmlschema.Schema schema = (org.ow2.easywsdl.schema.org.w3._2001.xmlschema.Schema)jAXBElement.getValue();
            SchemaImpl schemaImpl = new SchemaImpl(uRI, schema, easyXMLFilter.getNamespaceMapper(), easyXMLFilter.getSchemaLocator(), this.getFeatures(), map, this);
            if (bl) {
                schemaImpl.initialize();
            }
            return schemaImpl;
        }
        catch (SAXException sAXException) {
            throw new SchemaException("Can not get schema: ", sAXException);
        }
        catch (JAXBException jAXBException) {
            throw new SchemaException("Can not get schema: ", jAXBException);
        }
    }

    @Override
    public void setFeature(SchemaReader.FeatureConstants featureConstants, Object object) throws IllegalArgumentException {
        this.features.put(featureConstants, object);
        LOG.finest("set features: name = " + (Object)((Object)featureConstants) + " - value = " + object);
    }

    @Override
    public Object getFeature(SchemaReader.FeatureConstants featureConstants) throws IllegalArgumentException {
        return this.features.get((Object)featureConstants);
    }

    @Override
    public Map<SchemaReader.FeatureConstants, Object> getFeatures() {
        return this.features;
    }

    @Override
    public void setFeatures(Map<SchemaReader.FeatureConstants, Object> map) {
        this.features = map;
    }

    static {
        try {
            jaxbcontext = SchemaJAXBContext.getInstance();
        }
        catch (SchemaException schemaException) {
            contextException = schemaException;
        }
    }
}

