/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.tooling.xsd2xml.test;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.ow2.easywsdl.schema.DefaultSchemaImpl;
import org.ow2.easywsdl.schema.SchemaFactory;
import org.ow2.easywsdl.schema.api.Element;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.Type;
import org.ow2.easywsdl.schema.api.absItf.AbsItfElement;
import org.ow2.easywsdl.schema.api.absItf.AbsItfType;
import org.ow2.easywsdl.tooling.xsd2xml.XSD2XML;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.Types;

public class XSD2XMLTest
extends TestCase {
    private String TARGET_NAMESPACE = "http://petals.ow2.org/";

    public QName cName(String name) {
        return new QName(this.TARGET_NAMESPACE, name);
    }

    public XSD2XMLTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testReaderSchema() throws URISyntaxException, SchemaException, IOException {
        URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors/sample.xsd");
        Schema desc = SchemaFactory.newInstance().newSchemaReader().read(xsdUrl);
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((int)5, (int)desc.getTypes().size());
        Assert.assertEquals((String)"PurchaseOrderType", (String)((Type)desc.getTypes().get(0)).getQName().getLocalPart());
        Assert.assertEquals((String)"USAddress", (String)((Type)desc.getTypes().get(1)).getQName().getLocalPart());
        Assert.assertEquals((String)"Items", (String)((Type)desc.getTypes().get(2)).getQName().getLocalPart());
        Assert.assertEquals((String)"SKU", (String)((Type)desc.getTypes().get(3)).getQName().getLocalPart());
        Assert.assertEquals((int)2, (int)desc.getElements().size());
        Assert.assertEquals((String)"purchaseOrder", (String)((Element)desc.getElements().get(0)).getQName().getLocalPart());
        Assert.assertEquals((String)"comment", (String)((Element)desc.getElements().get(1)).getQName().getLocalPart());
    }

    public void testImportSchema() throws URISyntaxException, SchemaException, IOException {
        URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors/reservationList.xsd");
        Schema desc = SchemaFactory.newInstance().newSchemaReader().read(xsdUrl);
        Assert.assertNotNull((Object)desc);
    }

    public void testCreateElmtSchema() throws URISyntaxException, SchemaException {
        Schema schema = SchemaFactory.newInstance().newSchema();
        schema.setTargetNamespace("http://petals.ow2.org/");
        Element elmt = (Element)schema.createElement();
        elmt.setQName(new QName("nbAssure"));
        elmt.setType((AbsItfType)SchemaFactory.getDefaultSchema().getTypeInt());
        org.jdom.Element jDomElmt = XSD2XML.newInstance().generateElement((AbsItfElement)elmt, (Object)"?");
        Assert.assertNotNull((Object)jDomElmt);
    }

    public void testCreateArraySchema() throws URISyntaxException, SchemaException, IOException {
        URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors/ManagerProcess.xsd");
        Schema desc = SchemaFactory.newInstance().newSchemaReader().read(xsdUrl);
        Element array = (Element)desc.createElement();
        array.setQName(new QName("http://irit.contractnet.org", "bidArray"));
        array.setType((AbsItfType)desc.getTypes().get(0));
    }

    public void testCreateMiseAJourSuiviCollecteElement() throws URISyntaxException, SchemaException, IOException {
        URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors/i_servicemajsuivi.xsd");
        Schema desc = SchemaFactory.newInstance().newSchemaReader().read(xsdUrl);
        Element miseAJourSuiviCollecte = (Element)desc.getElement(new QName("http://suivi.architecture.cnav.fr/", "miseAJourSuiviCollecte"));
        Assert.assertNotNull((Object)miseAJourSuiviCollecte);
        Assert.assertEquals((String)"miseAJourSuiviCollecte", (String)miseAJourSuiviCollecte.getQName().getLocalPart());
    }

    public void testRejectedBidElement() throws URISyntaxException, SchemaException, IOException {
        URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors/ContractorProcessAbstract.xsd");
        Schema desc = SchemaFactory.newInstance().newSchemaReader().read(xsdUrl);
        Element miseAJourSuiviCollecte = (Element)desc.getElement(new QName("http://irit.contractnet.org/contractor", "ReceiveBidRejectRequest"));
        Assert.assertNotNull((Object)miseAJourSuiviCollecte);
        Assert.assertEquals((String)"ReceiveBidRejectRequest", (String)miseAJourSuiviCollecte.getQName().getLocalPart());
    }

    public void testCreateGetPresenceElement() throws URISyntaxException, SchemaException, IOException {
        URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors/PresenceEnablerSEI-V1_0.xsd");
        Schema desc = SchemaFactory.newInstance().newSchemaReader().read(xsdUrl);
        Element getPresenceCollecte = (Element)desc.getElement(new QName("http://com.orange.ft.enabler.sei/PresenceEnabler/V1_0/PresenceQuerySEI", "getPresence"));
        Assert.assertNotNull((Object)getPresenceCollecte);
        Assert.assertEquals((String)"getPresence", (String)getPresenceCollecte.getQName().getLocalPart());
        System.out.println(XSD2XML.newInstance().printXml((AbsItfElement)getPresenceCollecte, (Object)"?"));
    }

    public void testCreateGetPresenceElementFromWsdl() throws URISyntaxException, SchemaException, IOException {
        Schema s;
        URL wsdlUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors/PresenceEnablerSEI-V1_0.wsdl");
        Description desc = WSDLFactory.newInstance().newWSDLReader().read(wsdlUrl);
        Element getPresenceCollecte = null;
        Iterator i$ = ((Types)desc.getTypes()).getSchemas().iterator();
        while (i$.hasNext() && (getPresenceCollecte = (Element)(s = (Schema)i$.next()).getElement(new QName("http://com.orange.ft.enabler.sei/PresenceEnabler/V1_0/PresenceQuerySEI", "getPresence"))) == null) {
        }
        Assert.assertNotNull(getPresenceCollecte);
        Assert.assertEquals((String)"getPresence", (String)getPresenceCollecte.getQName().getLocalPart());
        System.out.println(XSD2XML.newInstance().printXml(getPresenceCollecte, (Object)"?"));
    }

    public void testAddDefaultValue() throws URISyntaxException, SchemaException, IOException {
        URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors/ContractorProcessAbstract.xsd");
        Schema desc = SchemaFactory.newInstance().newSchemaReader().read(xsdUrl);
        Element miseAJourSuiviCollecte = (Element)desc.getElement(new QName("http://irit.contractnet.org/contractor", "ReceiveBidRejectRequest"));
        Assert.assertNotNull((Object)miseAJourSuiviCollecte);
        Map map = XSD2XML.createDefaultMap((Object)"?");
        map.put(DefaultSchemaImpl.getInstance().getTypeInt(), "0");
        map.put(DefaultSchemaImpl.getInstance().getTypeBoolean(), "true");
        map.put(DefaultSchemaImpl.getInstance().getTypeDateTime(), Calendar.getInstance().getTime().toString());
        System.out.println(XSD2XML.newInstance().printXml((AbsItfElement)miseAJourSuiviCollecte, map, true, true));
    }

    public void testAddDefaultValueWithEmptyMap() throws URISyntaxException, SchemaException, IOException {
        URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors/ContractorProcessAbstract.xsd");
        Schema desc = SchemaFactory.newInstance().newSchemaReader().read(xsdUrl);
        Element miseAJourSuiviCollecte = (Element)desc.getElement(new QName("http://irit.contractnet.org/contractor", "ReceiveBidRejectRequest"));
        Assert.assertNotNull((Object)miseAJourSuiviCollecte);
        System.out.println(XSD2XML.newInstance().printXml((AbsItfElement)miseAJourSuiviCollecte, null, true, true));
    }

    public void testBindResponseElementFromWsdl() throws URISyntaxException, SchemaException, IOException {
        Schema s;
        URL wsdlUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors/prosodie/authorizationService.wsdl");
        Description desc = WSDLFactory.newInstance().newWSDLReader().read(wsdlUrl);
        Element bindResponse = null;
        Iterator i$ = ((Types)desc.getTypes()).getSchemas().iterator();
        while (i$.hasNext() && (bindResponse = (Element)(s = (Schema)i$.next()).getElement(new QName("http://contract.prosodie.com/AuthorizationService/1/", "bindResponse"))) == null) {
        }
        Assert.assertNotNull(bindResponse);
        Assert.assertEquals((String)"bindResponse", (String)bindResponse.getQName().getLocalPart());
        System.out.println(XSD2XML.newInstance().printXml(bindResponse, (Object)"?"));
    }
}

