/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.test.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.xml.sax.InputSource;

public class XSLTConverter {
    private static final String CONVERTER_XSD = "/wsdl11to20.xsl";
    private static final XSLTConverter converter = new XSLTConverter();
    private Templates wsdl11to20;

    private XSLTConverter() {
    }

    public static synchronized XSLTConverter getInstance() {
        return converter;
    }

    public InputSource convert(URL wsdlURL) {
        InputSource result = null;
        InputStream inputStream = null;
        try {
            inputStream = wsdlURL.openStream();
        }
        catch (Exception e) {
            throw new RuntimeException("Can't read given WSDL URI - " + e.getClass().getSimpleName() + " - " + e.getMessage());
        }
        ByteArrayOutputStream outputStream = this.transform(new StreamSource(inputStream));
        ByteArrayInputStream byteStream = new ByteArrayInputStream(outputStream.toByteArray());
        result = new InputSource(byteStream);
        return result;
    }

    private ByteArrayOutputStream transform(Source xml) {
        try {
            Transformer transformer = this.wsdl11to20.newTransformer();
            ByteArrayOutputStream outputStream = this.transformSource(xml, transformer);
            return outputStream;
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("Can't create XSL transformer - " + e.getClass().getSimpleName() + " - " + e.getMessage());
        }
        catch (TransformerException e) {
            throw new RuntimeException("Can't transform XML content with the configured xsl sheet - " + e.getClass().getSimpleName() + " - " + e.getMessage());
        }
    }

    private ByteArrayOutputStream transformSource(Source xml, Transformer transformer) throws TransformerException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(outputStream);
        transformer.transform(xml, streamResult);
        return outputStream;
    }

    private static Templates generateTemplates() {
        InputStream xslStream = XSLTConverter.class.getResourceAsStream(CONVERTER_XSD);
        try {
            return XSLTConverter.getTemplates(xslStream);
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("Failed to build XSL templates - " + e.getClass().getSimpleName() + " - " + e.getMessage());
        }
    }

    private static Templates getTemplates(InputStream xslResourceInputStream) throws TransformerConfigurationException {
        if (xslResourceInputStream == null) {
            return null;
        }
        StreamSource source = new StreamSource(xslResourceInputStream);
        TransformerFactoryImpl transformerFactory = new TransformerFactoryImpl();
        return transformerFactory.newTemplates(source);
    }

    static {
        XSLTConverter.converter.wsdl11to20 = XSLTConverter.generateTemplates();
    }
}

