/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.test.wsdl;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.WSDLException;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.WSDLReader;
import org.ow2.easywsdl.wsdl.test.wsdl.WSDLList;

public class MultiThreadTest
extends TestCase {
    public void testMultiThread() throws org.ow2.easywsdl.wsdl.api.WSDLException, URISyntaxException, WSDLException, InterruptedException, Throwable {
        WSDLReader readerDesc = WSDLFactory.newInstance().newWSDLReader();
        javax.wsdl.xml.WSDLReader readerDef = javax.wsdl.factory.WSDLFactory.newInstance().newWSDLReader();
        readerDef.setFeature("javax.wsdl.verbose", false);
        ArrayList<ThreadWSDLReader> readers = new ArrayList<ThreadWSDLReader>();
        ArrayList<URL> wsdls = null;
        Iterator<URL> it = WSDLList.getWsdls11().iterator();
        while (it.hasNext()) {
            wsdls = new ArrayList<URL>();
            if (it.hasNext()) {
                wsdls.add(it.next());
            }
            if (it.hasNext()) {
                wsdls.add(it.next());
            }
            if (it.hasNext()) {
                wsdls.add(it.next());
            }
            readers.add(new ThreadWSDLReader(readerDesc, readerDef, wsdls));
        }
        for (ThreadWSDLReader reader : readers) {
            reader.start();
        }
        for (ThreadWSDLReader reader : readers) {
            reader.join();
        }
        for (ThreadWSDLReader reader : readers) {
            if (reader.error == null) continue;
            throw reader.error;
        }
    }

    private static class ThreadWSDLReader
    extends Thread {
        private WSDLReader reader;
        private Throwable error = null;
        private List<URL> wsdls;

        public ThreadWSDLReader(WSDLReader reader, javax.wsdl.xml.WSDLReader readerDef, List<URL> wsdls) {
            this.reader = reader;
            this.wsdls = wsdls;
        }

        @Override
        public void run() {
            Description desc = null;
            try {
                for (int i = 0; i < 10; ++i) {
                    for (URL url : this.wsdls) {
                        desc = this.reader.read(url);
                        if (desc != null) continue;
                        throw new AssertionFailedError();
                    }
                }
            }
            catch (org.ow2.easywsdl.wsdl.api.WSDLException e) {
                this.error = e;
            }
            catch (IOException e) {
                this.error = e;
            }
            catch (URISyntaxException e) {
                this.error = e;
            }
            catch (AssertionFailedError e) {
                this.error = e;
            }
        }
    }
}

