/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.test.wsdl;

import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.wsdl.BindingFault;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.http.HTTPOperation;
import javax.wsdl.extensions.http.HTTPUrlEncoded;
import javax.wsdl.extensions.http.HTTPUrlReplacement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMimeXml;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Fault;
import javax.wsdl.extensions.soap12.SOAP12Header;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.wsdl.xml.WSDLReader;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.Binding;
import org.ow2.easywsdl.wsdl.api.BindingInput;
import org.ow2.easywsdl.wsdl.api.BindingOperation;
import org.ow2.easywsdl.wsdl.api.BindingOutput;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Operation;
import org.ow2.easywsdl.wsdl.api.Part;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfBindingParam;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfParam;
import org.ow2.easywsdl.wsdl.test.wsdl.WSDLList;
import org.w3c.dom.Document;

public class WSDL4JComparisonTest
extends TestCase {
    public void testWSDL4J() throws Exception {
        org.ow2.easywsdl.wsdl.api.WSDLReader readerDesc = WSDLFactory.newInstance().newWSDLReader();
        WSDLReader readerDef = javax.wsdl.factory.WSDLFactory.newInstance().newWSDLReader();
        readerDef.setFeature("javax.wsdl.verbose", false);
        for (URL wsdlUrl : WSDLList.getWsdls11()) {
            Description desc = readerDesc.read(wsdlUrl);
            Definition def = readerDef.readWSDL(wsdlUrl.toString());
            this.assertWithWSDL4JModel(desc, def);
        }
    }

    public void testWSDL4J2() throws Exception {
        String rootString = this.readFileAsString("/descriptors/otherswsdl/separated/root/sendMail.wsdl");
        String importString = this.readFileAsString("/descriptors/otherswsdl/separated/imports/sendMailInterface.wsdl");
        Document rootDocument = XMLHelper.createDocumentFromString((String)rootString);
        rootDocument.setDocumentURI(".");
        Document importDocument = XMLHelper.createDocumentFromString((String)importString);
        importDocument.setDocumentURI(".");
        HashMap<URI, Description> imports = new HashMap<URI, Description>();
        imports.put(URI.create("sendMailInterface.wsdl"), WSDLFactory.newInstance().newWSDLReader().read(importDocument));
    }

    private String readFileAsString(String filePath) throws IOException {
        URL resourceURL = ((Object)((Object)this)).getClass().getResource(filePath);
        File wsdl = new File(URI.create(resourceURL.toString()));
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new FileReader(wsdl));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }

    private void assertWithWSDL4JModel(Description desc, Definition def) throws WSDLException {
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((String)def.getTargetNamespace(), (String)desc.getTargetNamespace());
        Assert.assertEquals((Object)def.getQName(), (Object)desc.getQName());
        Assert.assertEquals((int)def.getAllServices().size(), (int)desc.getServices().size());
        for (javax.wsdl.Service expectedService : def.getAllServices().values()) {
            Service actualService = (Service)desc.getService(expectedService.getQName());
            Assert.assertNotNull((Object)actualService);
            Assert.assertEquals((Object)expectedService.getQName(), (Object)actualService.getQName());
            Assert.assertEquals((int)expectedService.getPorts().size(), (int)actualService.getEndpoints().size());
            for (Port expectedEp : expectedService.getPorts().values()) {
                Endpoint actualEp = (Endpoint)actualService.getEndpoint(expectedEp.getName());
                Assert.assertNotNull((Object)actualEp);
                Assert.assertEquals((String)expectedEp.getName(), (String)actualEp.getName());
                List extEpEls = expectedEp.getExtensibilityElements();
                if (extEpEls.size() > 0) {
                    SOAPAddress soapAddress;
                    ExtensibilityElement extEl = (ExtensibilityElement)extEpEls.get(0);
                    if (extEl instanceof SOAPAddress) {
                        soapAddress = (SOAPAddress)extEl;
                        Assert.assertEquals((String)soapAddress.getLocationURI(), (String)actualEp.getAddress());
                    } else if (extEl instanceof SOAP12Address) {
                        soapAddress = (SOAP12Address)extEl;
                        Assert.assertEquals((String)soapAddress.getLocationURI(), (String)actualEp.getAddress());
                    } else if (extEl instanceof HTTPAddress) {
                        HTTPAddress httpAddress = (HTTPAddress)extEl;
                        Assert.assertEquals((String)httpAddress.getLocationURI(), (String)actualEp.getAddress());
                    } else {
                        Assert.fail((String)"unknown endpoint address type");
                    }
                } else {
                    Assert.fail((String)("no extensible element for this endpoint: " + expectedEp.getName()));
                }
                Assert.assertEquals((int)def.getAllBindings().size(), (int)desc.getBindings().size());
                Assert.assertEquals((Object)expectedEp.getBinding().getQName(), (Object)((Binding)actualEp.getBinding()).getQName());
                List extBdgEls = expectedEp.getBinding().getExtensibilityElements();
                if (extBdgEls.size() > 0) {
                    for (Object extEl : extBdgEls) {
                        SOAPBinding soapBinding;
                        if (!(extEl instanceof JAXBElement)) continue;
                        if (extEl instanceof SOAPBinding) {
                            soapBinding = (SOAPBinding)extEl;
                            Assert.assertEquals((String)soapBinding.getTransportURI(), (String)((Binding)actualEp.getBinding()).getTransportProtocol());
                            if (soapBinding.getStyle() != null) {
                                Assert.assertEquals((String)soapBinding.getStyle(), (String)((Binding)actualEp.getBinding()).getStyle().value());
                                continue;
                            }
                            Assert.assertNull((Object)((Binding)actualEp.getBinding()).getStyle());
                            continue;
                        }
                        if (extEl instanceof SOAP12Binding) {
                            soapBinding = (SOAP12Binding)extEl;
                            Assert.assertEquals((String)soapBinding.getTransportURI(), (String)((Binding)actualEp.getBinding()).getTransportProtocol());
                            if (soapBinding.getStyle() != null) {
                                Assert.assertEquals((String)soapBinding.getStyle(), (String)((Binding)actualEp.getBinding()).getStyle().value());
                                continue;
                            }
                            Assert.assertNull((Object)((Binding)actualEp.getBinding()).getStyle());
                            continue;
                        }
                        if (extEl instanceof HTTPBinding) {
                            HTTPBinding httpBinding = (HTTPBinding)extEl;
                            Assert.assertEquals((String)httpBinding.getVerb(), (String)((Binding)actualEp.getBinding()).getTransportProtocol());
                            Assert.assertEquals(null, (Object)((Binding)actualEp.getBinding()).getStyle());
                            continue;
                        }
                        Assert.fail((String)"unknown endpoint address type");
                    }
                } else {
                    Assert.fail((String)("no extensible element for this binding: " + expectedEp.getBinding().getQName()));
                }
                Assert.assertEquals((int)expectedEp.getBinding().getBindingOperations().size(), (int)((Binding)actualEp.getBinding()).getBindingOperations().size());
                for (javax.wsdl.BindingOperation expectedbop : expectedEp.getBinding().getBindingOperations()) {
                    BindingOperation actualbop = (BindingOperation)((Binding)actualEp.getBinding()).getBindingOperation(expectedbop.getName());
                    Assert.assertNotNull((Object)actualbop);
                    Assert.assertEquals((String)expectedbop.getName(), (String)actualbop.getQName().getLocalPart());
                    String soapActionURI = null;
                    String httpLocationURI = null;
                    List extElList = expectedbop.getExtensibilityElements();
                    if (extElList != null) {
                        for (ExtensibilityElement extEl : extElList) {
                            SOAPOperation soapOp;
                            if (extEl instanceof SOAPOperation) {
                                soapOp = (SOAPOperation)extEl;
                                soapActionURI = soapOp.getSoapActionURI();
                                continue;
                            }
                            if (extEl instanceof SOAP12Operation) {
                                soapOp = (SOAP12Operation)extEl;
                                soapActionURI = soapOp.getSoapActionURI();
                                continue;
                            }
                            if (!(extEl instanceof HTTPOperation)) continue;
                            HTTPOperation httpLoc = (HTTPOperation)extEl;
                            httpLocationURI = httpLoc.getLocationURI();
                        }
                    }
                    Assert.assertEquals(soapActionURI, (String)actualbop.getSoapAction());
                    Assert.assertEquals(httpLocationURI, (String)actualbop.getHttpLocation());
                    if (expectedbop.getBindingInput() != null) {
                        Assert.assertEquals((String)expectedbop.getBindingInput().getName(), (String)((BindingInput)actualbop.getInput()).getName());
                        this.assertOnBindingParam(expectedbop.getBindingInput().getExtensibilityElements(), (AbsItfBindingParam)actualbop.getInput());
                    } else {
                        Assert.assertNull((Object)actualbop.getInput());
                    }
                    if (expectedbop.getBindingOutput() != null) {
                        Assert.assertEquals((String)expectedbop.getBindingOutput().getName(), (String)((BindingOutput)actualbop.getOutput()).getName());
                        this.assertOnBindingParam(expectedbop.getBindingOutput().getExtensibilityElements(), (AbsItfBindingParam)actualbop.getOutput());
                    } else {
                        Assert.assertNull((Object)actualbop.getOutput());
                    }
                    if (expectedbop.getBindingFaults() != null) {
                        Assert.assertEquals((int)expectedbop.getBindingFaults().size(), (int)actualbop.getFaults().size());
                        for (BindingFault expectedfault : expectedbop.getBindingFaults().values()) {
                            org.ow2.easywsdl.wsdl.api.BindingFault actualfault = (org.ow2.easywsdl.wsdl.api.BindingFault)actualbop.getFault(expectedfault.getName());
                            Assert.assertNotNull((Object)actualfault);
                            Assert.assertEquals((String)expectedfault.getName(), (String)actualfault.getName());
                            this.assertOnBindingParam(expectedfault.getExtensibilityElements(), (AbsItfBindingParam)actualfault);
                        }
                    } else {
                        Assert.assertNotNull((Object)actualbop.getFaults());
                    }
                    Assert.assertEquals((int)def.getAllPortTypes().size(), (int)desc.getInterfaces().size());
                    for (PortType expecteditf : def.getAllPortTypes().values()) {
                        InterfaceType actualitf = (InterfaceType)desc.getInterface(expecteditf.getQName());
                        Assert.assertNotNull((Object)actualitf);
                        Assert.assertEquals((Object)expecteditf.getQName(), (Object)actualitf.getQName());
                        Assert.assertEquals((int)expecteditf.getOperations().size(), (int)actualitf.getOperations().size());
                        for (javax.wsdl.Operation expectedop : expecteditf.getOperations()) {
                            Operation actualop = (Operation)actualitf.getOperation(new QName(expecteditf.getQName().getNamespaceURI(), expectedop.getName()));
                            Assert.assertNotNull((Object)actualop);
                            Assert.assertEquals((String)expectedop.getName(), (String)actualop.getQName().getLocalPart());
                            if (expectedop.getStyle().equals(OperationType.ONE_WAY)) {
                                Assert.assertTrue((boolean)actualop.getPattern().equals((Object)AbsItfOperation.MEPPatternConstants.IN_ONLY));
                            } else if (expectedop.getStyle().equals(OperationType.REQUEST_RESPONSE)) {
                                Assert.assertTrue((boolean)actualop.getPattern().equals((Object)AbsItfOperation.MEPPatternConstants.IN_OUT));
                            } else if (expectedop.getStyle().equals(OperationType.SOLICIT_RESPONSE)) {
                                Assert.assertTrue((boolean)actualop.getPattern().equals((Object)AbsItfOperation.MEPPatternConstants.ROBUST_IN_ONLY));
                            } else {
                                Assert.fail((String)"unknown pattern operation");
                            }
                            Assert.assertEquals((Object)expectedop.getParameterOrdering(), (Object)actualop.getParameterOrdering());
                            if (expectedop.getInput() != null) {
                                this.assertOnOperationParam(expectedop.getInput().getName(), expectedop.getInput().getMessage(), (AbsItfParam)actualop.getInput());
                            }
                            if (expectedop.getOutput() != null) {
                                this.assertOnOperationParam(expectedop.getOutput().getName(), expectedop.getOutput().getMessage(), (AbsItfParam)actualop.getOutput());
                            }
                            if (expectedop.getFaults() == null) continue;
                            Assert.assertEquals((int)expectedop.getFaults().size(), (int)actualop.getFaults().size());
                            for (Fault expectedfault : expectedop.getFaults().values()) {
                                org.ow2.easywsdl.wsdl.api.Fault actualfault = (org.ow2.easywsdl.wsdl.api.Fault)actualop.getFault(expectedfault.getMessage().getQName().getLocalPart());
                                this.assertOnOperationParam(expectedfault.getName(), expectedfault.getMessage(), (AbsItfParam)actualfault);
                            }
                        }
                    }
                }
            }
        }
    }

    private void assertOnBindingParam(List extElList2, AbsItfBindingParam actualparam) {
        SOAPBody soapBody = null;
        SOAPFault soapFault = null;
        SOAP12Body soap12Body = null;
        SOAP12Fault soap12Fault = null;
        ArrayList<SOAPHeader> soapHeader = new ArrayList<SOAPHeader>();
        ArrayList<SOAP12Header> soap12Header = new ArrayList<SOAP12Header>();
        HTTPUrlEncoded httpUrlEncoded = null;
        HTTPUrlReplacement httpUrlReplacement = null;
        ArrayList<MIMEContent> mimeContents = new ArrayList<MIMEContent>();
        ArrayList<MIMEMimeXml> mimeXmls = new ArrayList<MIMEMimeXml>();
        ArrayList<MIMEMultipartRelated> mpartr = new ArrayList<MIMEMultipartRelated>();
        if (extElList2 != null) {
            for (ExtensibilityElement extEl : extElList2) {
                if (extEl instanceof SOAPBody) {
                    soapBody = (SOAPBody)extEl;
                    continue;
                }
                if (extEl instanceof SOAP12Body) {
                    soap12Body = (SOAP12Body)extEl;
                    continue;
                }
                if (extEl instanceof SOAPHeader) {
                    soapHeader.add((SOAPHeader)extEl);
                    continue;
                }
                if (extEl instanceof SOAP12Header) {
                    soap12Header.add((SOAP12Header)extEl);
                    continue;
                }
                if (extEl instanceof SOAPFault) {
                    soapFault = (SOAPFault)extEl;
                    continue;
                }
                if (extEl instanceof SOAP12Fault) {
                    soap12Fault = (SOAP12Fault)extEl;
                    continue;
                }
                if (extEl instanceof HTTPUrlEncoded) {
                    httpUrlEncoded = (HTTPUrlEncoded)extEl;
                    continue;
                }
                if (extEl instanceof HTTPUrlReplacement) {
                    httpUrlReplacement = (HTTPUrlReplacement)extEl;
                    continue;
                }
                if (extEl instanceof MIMEContent) {
                    mimeContents.add((MIMEContent)extEl);
                    continue;
                }
                if (extEl instanceof MIMEMimeXml) {
                    mimeXmls.add((MIMEMimeXml)extEl);
                    continue;
                }
                if (!(extEl instanceof MIMEMultipartRelated)) continue;
                mpartr.add((MIMEMultipartRelated)extEl);
            }
        }
        if (soapBody != null || soapHeader.size() > 0 || soapFault != null) {
            Assert.assertNotNull((Object)actualparam.getSOAP11Binding4Wsdl11());
            if (soapBody != null) {
                Assert.assertEquals((String)soapBody.getNamespaceURI(), (String)actualparam.getSOAP11Binding4Wsdl11().getBody().getNamespace());
                Assert.assertEquals((String)soapBody.getUse(), (String)actualparam.getSOAP11Binding4Wsdl11().getBody().getUse().value());
                Assert.assertEquals((Object)soapBody.getRequired(), (Object)actualparam.getSOAP11Binding4Wsdl11().getBody().getRequired());
                if (soapBody.getEncodingStyles() != null) {
                    for (String item : soapBody.getEncodingStyles()) {
                        Assert.assertTrue((boolean)actualparam.getSOAP11Binding4Wsdl11().getBody().getEncodingStyles().contains(item));
                    }
                } else {
                    Assert.assertNull((Object)actualparam.getSOAP11Binding4Wsdl11().getBody().getEncodingStyles());
                }
                if (soapBody.getParts() != null) {
                    for (String item : soapBody.getParts()) {
                        Assert.assertTrue((boolean)actualparam.getSOAP11Binding4Wsdl11().getBody().getParts().contains(item));
                    }
                } else {
                    Assert.assertNull((Object)actualparam.getSOAP11Binding4Wsdl11().getBody().getParts());
                }
            } else {
                Assert.assertNull((Object)actualparam.getSOAP11Binding4Wsdl11().getBody());
            }
            Assert.assertEquals((int)soapHeader.size(), (int)actualparam.getSOAP11Binding4Wsdl11().getHeaders().size());
            if (soapFault != null) {
                Assert.assertEquals((String)soapFault.getNamespaceURI(), (String)actualparam.getSOAP11Binding4Wsdl11().getFault().getNamespace());
                Assert.assertEquals((String)soapFault.getName(), (String)actualparam.getSOAP11Binding4Wsdl11().getFault().getName());
                Assert.assertEquals((String)soapFault.getUse(), (String)actualparam.getSOAP11Binding4Wsdl11().getFault().getUse().value());
                Assert.assertEquals((Object)soapFault.getRequired(), (Object)actualparam.getSOAP11Binding4Wsdl11().getFault().getRequired());
                if (soapFault.getEncodingStyles() != null) {
                    for (String item : soapFault.getEncodingStyles()) {
                        Assert.assertTrue((boolean)actualparam.getSOAP11Binding4Wsdl11().getFault().getEncodingStyles().contains(item));
                    }
                } else {
                    Assert.assertNull((Object)actualparam.getSOAP11Binding4Wsdl11().getFault().getEncodingStyles());
                }
            } else {
                Assert.assertNull((Object)actualparam.getSOAP11Binding4Wsdl11().getFault());
            }
        } else if (soap12Body != null || soap12Header.size() > 0 || soap12Fault != null) {
            Assert.assertNotNull((Object)actualparam.getSOAP12Binding4Wsdl11());
            if (soap12Body != null) {
                Assert.assertEquals((String)soap12Body.getNamespaceURI(), (String)actualparam.getSOAP12Binding4Wsdl11().getBody().getNamespace());
                Assert.assertEquals((String)soap12Body.getUse(), (String)actualparam.getSOAP12Binding4Wsdl11().getBody().getUse().value());
                Assert.assertEquals((Object)soap12Body.getRequired(), (Object)actualparam.getSOAP12Binding4Wsdl11().getBody().getRequired());
                Assert.assertEquals((String)soap12Body.getEncodingStyle(), (String)actualparam.getSOAP12Binding4Wsdl11().getBody().getEncodingStyle());
                if (soap12Body.getParts() != null) {
                    for (String item : soap12Body.getParts()) {
                        Assert.assertTrue((boolean)actualparam.getSOAP12Binding4Wsdl11().getBody().getParts().contains(item));
                    }
                } else {
                    Assert.assertNull((Object)actualparam.getSOAP12Binding4Wsdl11().getBody().getParts());
                }
            } else {
                Assert.assertNull((Object)actualparam.getSOAP12Binding4Wsdl11().getBody());
            }
            Assert.assertEquals((int)soap12Header.size(), (int)actualparam.getSOAP12Binding4Wsdl11().getHeaders().size());
            if (soap12Fault != null) {
                Assert.assertEquals((String)soap12Fault.getNamespaceURI(), (String)actualparam.getSOAP12Binding4Wsdl11().getFault().getNamespace());
                Assert.assertEquals((String)soap12Fault.getUse(), (String)actualparam.getSOAP12Binding4Wsdl11().getFault().getUse().value());
                Assert.assertEquals((Object)soap12Fault.getRequired(), (Object)actualparam.getSOAP12Binding4Wsdl11().getFault().getRequired());
                Assert.assertEquals((Object)soap12Fault.getEncodingStyle(), (Object)actualparam.getSOAP12Binding4Wsdl11().getFault().getRequired());
            } else {
                Assert.assertNull((Object)actualparam.getSOAP12Binding4Wsdl11().getFault());
            }
        } else if (httpUrlEncoded != null || httpUrlReplacement != null) {
            Assert.assertNotNull((Object)actualparam.getHTTPBinding4Wsdl11());
            if (httpUrlEncoded != null) {
                Assert.assertTrue((boolean)actualparam.getHTTPBinding4Wsdl11().isUrlEncoded());
            } else {
                Assert.assertFalse((boolean)actualparam.getHTTPBinding4Wsdl11().isUrlEncoded());
            }
            if (httpUrlReplacement != null) {
                Assert.assertTrue((boolean)actualparam.getHTTPBinding4Wsdl11().isUrlReplacement());
            } else {
                Assert.assertFalse((boolean)actualparam.getHTTPBinding4Wsdl11().isUrlReplacement());
            }
        } else if (mimeContents.size() > 0 || mimeXmls.size() > 0 || mpartr.size() > 0) {
            Assert.assertNotNull((Object)actualparam.getMIMEBinding4Wsdl11());
            Assert.assertEquals((int)mimeContents.size(), (int)actualparam.getMIMEBinding4Wsdl11().getContents().size());
            Assert.assertEquals((int)mimeXmls.size(), (int)actualparam.getMIMEBinding4Wsdl11().getMimeXml().size());
            Assert.assertEquals((int)mpartr.size(), (int)actualparam.getMIMEBinding4Wsdl11().getMultipartRelateds().size());
        } else {
            Assert.fail((String)"unknown binding");
        }
    }

    private void assertOnOperationParam(String expectedName, Message expectedMessage, AbsItfParam actualparam) {
        Assert.assertNotNull((Object)actualparam);
        Assert.assertEquals((String)expectedName, (String)actualparam.getName());
        Assert.assertEquals((Object)expectedMessage.getQName(), (Object)actualparam.getMessageName());
        Assert.assertEquals((int)expectedMessage.getParts().size(), (int)actualparam.getParts().size());
        for (javax.wsdl.Part expectedpart : expectedMessage.getParts().values()) {
            Part actualpart = actualparam.getPart(expectedpart.getName());
            Assert.assertNotNull((Object)actualpart);
            Assert.assertEquals((String)expectedpart.getName(), (String)actualpart.getPartQName().getLocalPart());
            if (expectedpart.getElementName() != null) {
                Assert.assertEquals((Object)expectedpart.getElementName(), (Object)actualpart.getElement().getQName());
                continue;
            }
            if (expectedpart.getTypeName() != null) {
                Assert.assertEquals((Object)expectedpart.getTypeName(), (Object)actualpart.getType().getQName());
                continue;
            }
            Assert.fail((String)"this part has an unknown type or element");
        }
    }
}

