/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.test.wsdl;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.Binding;
import org.ow2.easywsdl.wsdl.api.BindingOperation;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.Import;
import org.ow2.easywsdl.wsdl.api.Input;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Operation;
import org.ow2.easywsdl.wsdl.api.Output;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLReader;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class WSDLDescriptorTest
extends TestCase {
    WSDLReader reader = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.reader = WSDLFactory.newInstance().newWSDLReader();
    }

    public void testReaderWSDL11FromDocument() throws URISyntaxException, WSDLException, ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/WeatherForecast.wsdl");
        Document doc = db.parse(wsdlURL.toURI().toString());
        doc.setDocumentURI(wsdlURL.toURI().toString());
        Description desc = this.reader.read(doc);
        this.assertWSDLWeatherForecast(desc);
    }

    public void testReaderWSDL11_1Svc2PortSamePortType() throws URISyntaxException, WSDLException, ParserConfigurationException, SAXException, IOException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/1svc-2ports-samePortype.wsdl");
        Description desc = this.reader.read(wsdlURL);
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((int)1, (int)desc.getServices().size());
        Assert.assertEquals((String)"Service not found", (Object)QName.valueOf("{http://www.webservicex.net}WeatherForecast"), (Object)((Service)desc.getServices().get(0)).getQName());
        Assert.assertNotNull((String)"No endpoint found", (Object)((Service)desc.getServices().get(0)).getEndpoints());
        Assert.assertEquals((String)"Expected endpoint number is wrong", (int)2, (int)((Service)desc.getServices().get(0)).getEndpoints().size());
        Assert.assertNotNull((String)"Service interface not found", (Object)((Service)desc.getServices().get(0)).getInterface());
        Assert.assertEquals((String)"Expected service interface name is wrong", (Object)new QName("http://www.webservicex.net", "WeatherForecastPortType"), (Object)((InterfaceType)((Service)desc.getServices().get(0)).getInterface()).getQName());
    }

    public void testReaderWSDL11_1Svc2PortDifferentPortType() throws URISyntaxException, WSDLException, ParserConfigurationException, SAXException, IOException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/1svc-2ports-differentPortype.wsdl");
        Description desc = this.reader.read(wsdlURL);
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((int)1, (int)desc.getServices().size());
        Assert.assertEquals((String)"Service not found", (Object)QName.valueOf("{http://www.webservicex.net}WeatherForecast"), (Object)((Service)desc.getServices().get(0)).getQName());
        Assert.assertNotNull((String)"No endpoint found", (Object)((Service)desc.getServices().get(0)).getEndpoints());
        Assert.assertEquals((String)"Expected endpoint number is wrong", (int)2, (int)((Service)desc.getServices().get(0)).getEndpoints().size());
        try {
            InterfaceType itf = (InterfaceType)((Service)desc.getServices().get(0)).getInterface();
            Assert.assertTrue((String)("Interface found: " + itf.getQName().toString()), (boolean)false);
        }
        catch (WSDLException wSDLException) {
            // empty catch block
        }
    }

    private void assertWSDLWeatherForecast(Description desc) {
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((String)"http://www.webservicex.net", (String)desc.getTargetNamespace());
        Assert.assertEquals((int)1, (int)desc.getServices().size());
        Assert.assertEquals((Object)QName.valueOf("{http://www.webservicex.net}WeatherForecast"), (Object)((Service)desc.getServices().get(0)).getQName());
        Assert.assertEquals((String)"Get one week weather forecast for valid zip code or Place name in USA", (String)((Service)desc.getServices().get(0)).getDocumentation().getContent());
        Assert.assertEquals((int)3, (int)((Service)desc.getServices().get(0)).getEndpoints().size());
        Assert.assertEquals((String)"WeatherForecastSoap", (String)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(0)).getName());
        Assert.assertEquals((String)"http://www.webservicex.net/WeatherForecast.asmx", (String)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(0)).getAddress());
        Assert.assertEquals((Object)new QName("http://www.webservicex.net", "WeatherForecastSoap"), (Object)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(0)).getBinding()).getQName());
        Assert.assertEquals((String)"http://schemas.xmlsoap.org/soap/http", (String)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(0)).getBinding()).getTransportProtocol());
        Assert.assertEquals((Object)new QName("http://www.webservicex.net", "GetWeatherByZipCode"), (Object)((BindingOperation)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(0)).getBinding()).getBindingOperations().get(0)).getQName());
        Assert.assertEquals((String)"http://www.w3.org/2003/05/soap/mep/request-response", (String)((BindingOperation)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(0)).getBinding()).getBindingOperations().get(0)).getMEP().toString());
        Assert.assertEquals((Object)new QName("http://www.webservicex.net", "GetWeatherByPlaceName"), (Object)((BindingOperation)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(0)).getBinding()).getBindingOperations().get(1)).getQName());
        Assert.assertEquals((String)"http://www.w3.org/2003/05/soap/mep/request-response", (String)((BindingOperation)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(0)).getBinding()).getBindingOperations().get(1)).getMEP().toString());
        Assert.assertEquals((String)"WeatherForecastHttpGet", (String)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(1)).getName());
        Assert.assertEquals((String)"http://www.webservicex.net/WeatherForecast.asmx", (String)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(1)).getAddress());
        Assert.assertEquals((Object)new QName("http://www.webservicex.net", "WeatherForecastHttpGet"), (Object)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(1)).getBinding()).getQName());
        Assert.assertEquals((String)"GET", (String)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(1)).getBinding()).getTransportProtocol());
        Assert.assertEquals((Object)new QName("http://www.webservicex.net", "GetWeatherByZipCode"), (Object)((BindingOperation)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(1)).getBinding()).getBindingOperations().get(0)).getQName());
        Assert.assertEquals((String)"http://www.w3.org/2003/05/soap/mep/request-response", (String)((BindingOperation)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(1)).getBinding()).getBindingOperations().get(0)).getMEP().toString());
        Assert.assertEquals((Object)new QName("http://www.webservicex.net", "GetWeatherByPlaceName"), (Object)((BindingOperation)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(1)).getBinding()).getBindingOperations().get(1)).getQName());
        Assert.assertEquals((String)"http://www.w3.org/2003/05/soap/mep/request-response", (String)((BindingOperation)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(1)).getBinding()).getBindingOperations().get(1)).getMEP().toString());
        Assert.assertEquals((String)"WeatherForecastHttpPost", (String)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(2)).getName());
        Assert.assertEquals((String)"http://www.webservicex.net/WeatherForecast.asmx", (String)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(1)).getAddress());
        Assert.assertEquals((Object)new QName("http://www.webservicex.net", "WeatherForecastHttpPost"), (Object)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(2)).getBinding()).getQName());
        Assert.assertEquals((String)"POST", (String)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(2)).getBinding()).getTransportProtocol());
        Assert.assertEquals((Object)new QName("http://www.webservicex.net", "GetWeatherByZipCode"), (Object)((BindingOperation)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(2)).getBinding()).getBindingOperations().get(0)).getQName());
        Assert.assertEquals((String)"http://www.w3.org/2003/05/soap/mep/request-response", (String)((BindingOperation)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(2)).getBinding()).getBindingOperations().get(0)).getMEP().toString());
        Assert.assertEquals((Object)new QName("http://www.webservicex.net", "GetWeatherByPlaceName"), (Object)((BindingOperation)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(2)).getBinding()).getBindingOperations().get(1)).getQName());
        Assert.assertEquals((String)"http://www.w3.org/2003/05/soap/mep/request-response", (String)((BindingOperation)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(2)).getBinding()).getBindingOperations().get(1)).getMEP().toString());
        Assert.assertEquals((Object)new QName("http://www.webservicex.net", "WeatherForecastSoap"), (Object)((InterfaceType)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(0)).getBinding()).getInterface()).getQName());
        Assert.assertEquals((Object)new QName("http://www.webservicex.net", "GetWeatherByZipCode"), (Object)((Operation)((BindingOperation)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(0)).getBinding()).getBindingOperations().get(0)).getOperation()).getQName());
        Assert.assertEquals((Object)AbsItfOperation.MEPPatternConstants.IN_OUT, (Object)((Operation)((BindingOperation)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(0)).getBinding()).getBindingOperations().get(0)).getOperation()).getPattern());
        Assert.assertEquals((Object)new QName("http://www.webservicex.net", "GetWeatherByZipCodeSoapIn"), (Object)((Input)((Operation)((BindingOperation)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(0)).getBinding()).getBindingOperations().get(0)).getOperation()).getInput()).getMessageName());
        Assert.assertEquals((Object)new QName("http://www.webservicex.net", "GetWeatherByZipCodeSoapOut"), (Object)((Output)((Operation)((BindingOperation)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(0)).getBinding()).getBindingOperations().get(0)).getOperation()).getOutput()).getMessageName());
    }

    public void testReaderWSDL11MissingImport() throws URISyntaxException, WSDLException {
        try {
            URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/otherElmts/wsdl11/wsdl-missing-import.wsdl");
            Description desc = this.reader.read(wsdlURL);
            WSDLDescriptorTest.fail((String)"No exception thrown.");
        }
        catch (WSDLException e) {
        }
        catch (IOException e) {
            WSDLDescriptorTest.fail((String)"IOException thrown.");
        }
    }

    public void testReaderWSDL11AntislashImport() throws URISyntaxException, WSDLException, IOException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/otherElmts/wsdl11/wsdl-antislash-import.wsdl");
        Description desc = this.reader.read(wsdlURL);
        WSDLDescriptorTest.assertNotNull((Object)desc);
    }

    public void testReaderWSDL11FromURL() throws URISyntaxException, WSDLException, IOException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/WeatherForecast.wsdl");
        Description desc = this.reader.read(wsdlURL);
        this.assertWSDLWeatherForecast(desc);
    }

    public void testReaderWSDL20_DocumentBaseURIContainingSpaces() throws WSDLException, IOException, URISyntaxException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/with space in name.wsdl");
        Description desc = this.reader.read(wsdlURL);
        Assert.assertFalse((String)"The document base URI contains unencoded spaces", (boolean)desc.getDocumentBaseURI().toString().contains(" "));
    }

    public void testReaderWSDL20() throws URISyntaxException, WSDLException, IOException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/reservationList.wsdl");
        Description desc = this.reader.read(wsdlURL);
        Assert.assertNotNull((Object)desc);
        Assert.assertNotNull((Object)desc.getDocumentation().getContent());
        Assert.assertEquals((String)"http://greath.example.com/2004/services/reservationList", (String)desc.getTargetNamespace());
        Assert.assertEquals((int)1, (int)desc.getServices().size());
        Assert.assertEquals((Object)QName.valueOf("{http://greath.example.com/2004/services/reservationList}reservationListService"), (Object)((Service)desc.getServices().get(0)).getQName());
        Assert.assertEquals((String)"the reservationListEndpoint\nthe reservationListEndpoint", (String)((Service)desc.getServices().get(0)).getDocumentation().getContent());
        Assert.assertEquals((int)1, (int)((Service)desc.getServices().get(0)).getEndpoints().size());
        Assert.assertEquals((String)"reservationListEndpoint", (String)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(0)).getName());
        Assert.assertEquals((String)"http://greath.example.com/2004/reservationList", (String)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(0)).getAddress());
        Assert.assertEquals((String)"{http://greath.example.com/2004/services/reservationList}reservationListSOAPBinding", (String)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(0)).getBinding()).getQName().toString());
        Assert.assertEquals((String)"http://www.w3.org/2003/05/soap/bindings/HTTP/", (String)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(0)).getBinding()).getTransportProtocol());
        Assert.assertEquals((String)"{http://greath.example.com/2004/services/reservationList}retrieve", (String)((BindingOperation)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(0)).getBinding()).getBindingOperations().get(0)).getQName().toString());
        Assert.assertEquals((String)"http://www.w3.org/2003/05/soap/mep/request-response", (String)((BindingOperation)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(0)).getBinding()).getBindingOperations().get(0)).getMEP().toString());
        Assert.assertEquals((String)"{http://greath.example.com/2004/services/reservationList}reservationListInterface", (String)((InterfaceType)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(0)).getBinding()).getInterface()).getQName().toString());
        Assert.assertEquals((String)"{http://greath.example.com/2004/services/reservationList}retrieve", (String)((Operation)((BindingOperation)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(0)).getBinding()).getBindingOperations().get(0)).getOperation()).getQName().toString());
        Assert.assertEquals((Object)AbsItfOperation.MEPPatternConstants.IN_OUT, (Object)((Operation)((BindingOperation)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(0)).getBinding()).getBindingOperations().get(0)).getOperation()).getPattern());
        Assert.assertEquals((String)"{http://greath.example.com/2004/services/reservationList}In", (String)((Input)((Operation)((BindingOperation)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(0)).getBinding()).getBindingOperations().get(0)).getOperation()).getInput()).getMessageName().toString());
        Assert.assertEquals((String)"{http://greath.example.com/2004/services/reservationList}Out", (String)((Output)((Operation)((BindingOperation)((Binding)((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(0)).getBinding()).getBindingOperations().get(0)).getOperation()).getOutput()).getMessageName().toString());
    }

    public void testWriterWSDL11() throws WSDLException, URISyntaxException, WSDLException, IOException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/WeatherForecast.wsdl");
        Description desc = this.reader.read(wsdlURL);
        String res = WSDLFactory.newInstance().newWSDLWriter().writeWSDL(desc);
        Assert.assertNotNull((Object)res);
    }

    public void testWriterWSDL20() throws WSDLException, URISyntaxException, WSDLException, IOException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/reservationList.wsdl");
        Description desc = this.reader.read(wsdlURL);
        String res = WSDLFactory.newInstance().newWSDLWriter().writeWSDL(desc);
        Assert.assertNotNull((Object)res);
    }

    public void testModifierWSDL11() throws WSDLException, URISyntaxException, WSDLException, IOException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/WeatherForecast.wsdl");
        Description desc = this.reader.read(wsdlURL);
        desc.setDocumentation(desc.createDocumentation());
        desc.getDocumentation().setContent("New DocumentationImpl");
        ((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(0)).setName("modifyEndpoint");
        ((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(0)).setAddress("modifyEndpointAddress");
        Document doc = WSDLFactory.newInstance().newWSDLWriter().getDocument(desc);
        doc.setDocumentURI(wsdlURL.toURI().toString());
        Description descFromDoc = WSDLFactory.newInstance().newWSDLReader().read(doc);
        Assert.assertEquals((String)"New DocumentationImpl", (String)descFromDoc.getDocumentation().getContent());
        Assert.assertEquals((String)"modifyEndpoint", (String)((Endpoint)((Service)descFromDoc.getServices().get(0)).getEndpoints().get(0)).getName());
        Assert.assertEquals((String)"modifyEndpointAddress", (String)((Endpoint)((Service)descFromDoc.getServices().get(0)).getEndpoints().get(0)).getAddress());
    }

    public void testModifierWSDL20() throws WSDLException, URISyntaxException, WSDLException, IOException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/reservationList.wsdl");
        Description desc = this.reader.read(wsdlURL);
        desc.getDocumentation().setContent("New DocumentationImpl");
        ((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(0)).setName("modifyEndpoint");
        ((Endpoint)((Service)desc.getServices().get(0)).getEndpoints().get(0)).setAddress("modifyEndpointAddress");
        Document doc = WSDLFactory.newInstance().newWSDLWriter().getDocument(desc);
        doc.setDocumentURI(wsdlURL.toURI().toString());
        Description descFromDoc = WSDLFactory.newInstance().newWSDLReader().read(doc);
        Assert.assertEquals((String)"New DocumentationImpl", (String)descFromDoc.getDocumentation().getContent());
        Assert.assertEquals((String)"modifyEndpoint", (String)((Endpoint)((Service)descFromDoc.getServices().get(0)).getEndpoints().get(0)).getName());
        Assert.assertEquals((String)"modifyEndpointAddress", (String)((Endpoint)((Service)descFromDoc.getServices().get(0)).getEndpoints().get(0)).getAddress());
    }

    public void testImportWSDL11() throws WSDLException, URISyntaxException, WSDLException, IOException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/importwsdl/CustomerSearch.wsdl");
        Description desc = this.reader.read(wsdlURL);
        Assert.assertEquals((int)1, (int)desc.getInterfaces().size());
        Assert.assertEquals((String)"{http://searchcustomer.services.stv.orange.com}CustomerSearchService", (String)((InterfaceType)desc.getInterfaces().get(0)).getQName().toString());
    }

    public void testOtherElmtsAndAttributesInWSDL11() throws URISyntaxException, XmlException, IOException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/otherElmts/wsdl11/CustomerSearch.wsdl");
        Description desc = this.reader.read(wsdlURL);
        Assert.assertNotNull((Object)desc);
        Assert.assertNotNull((Object)desc.getOtherElements());
        Assert.assertEquals((int)1, (int)desc.getOtherElements().size());
        Assert.assertEquals((String)"importedDocuments", (String)((Element)desc.getOtherElements().get(0)).getLocalName());
        Assert.assertNotNull((Object)desc.getImports());
        Assert.assertEquals((int)1, (int)desc.getImports().size());
        Assert.assertNotNull((Object)((Import)desc.getImports().get(0)).getOtherAttributes());
        Assert.assertEquals((int)1, (int)((Import)desc.getImports().get(0)).getOtherAttributes().size());
        Assert.assertEquals((String)"verif", (String)((String)((Import)desc.getImports().get(0)).getOtherAttributes().get(new QName("http://petals.ow2.org/wsdlExtensions", "test"))));
    }

    public void testOtherElmtsAndAttributesInWSDL20() throws URISyntaxException, XmlException, IOException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/otherElmts/wsdl20/reservationList.wsdl");
        Description desc = this.reader.read(wsdlURL);
        Assert.assertNotNull((Object)desc);
        Assert.assertNotNull((Object)desc.getOtherElements());
        Assert.assertEquals((int)1, (int)desc.getOtherElements().size());
        Assert.assertEquals((String)"importedDocuments", (String)((Element)desc.getOtherElements().get(0)).getLocalName());
        Assert.assertNotNull((Object)desc.getInterfaces());
        Assert.assertEquals((int)1, (int)desc.getInterfaces().size());
        Assert.assertNotNull((Object)((InterfaceType)desc.getInterfaces().get(0)).getOtherAttributes());
        Assert.assertEquals((int)1, (int)((InterfaceType)desc.getInterfaces().get(0)).getOtherAttributes().size());
        Assert.assertEquals((String)"verif", (String)((String)((InterfaceType)desc.getInterfaces().get(0)).getOtherAttributes().get(new QName("http://petals.ow2.org/wsdlExtensions", "test"))));
    }

    public void testSchemaLocationInWSDL() throws URISyntaxException, XmlException, IOException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/otherElmts/wsdl11/CustomerSearchService.wsdl");
        Description desc = this.reader.read(wsdlURL);
        Assert.assertNotNull((Object)desc);
        WSDLDescriptorTest.assertEquals((String)"{http://petals.ow2.org/schemaTest=schemaTest.xsd}", (String)desc.getSchemaLocation().toString());
    }

    public void testReaderWSDL20FromDocument() throws URISyntaxException, WSDLException, ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/car.wsdl");
        Document doc = db.parse(wsdlURL.toURI().toString());
        doc.setDocumentURI(wsdlURL.toURI().toString());
        Description desc = this.reader.read(doc);
        WSDLDescriptorTest.assertEquals((int)1, (int)desc.getInterfaces().size());
    }

    public void testWSDLEquals() throws URISyntaxException, WSDLException, IOException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/WeatherForecast.wsdl");
        Description desc = this.reader.read(wsdlURL);
        Description desc2 = this.reader.read(wsdlURL);
        Assert.assertTrue((boolean)desc.equals(desc2));
        desc2.setQName(new QName("http://easywsdl.ow2.org/namespace", "testcase"));
        Assert.assertFalse((boolean)desc.equals(desc2));
    }
}

