/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.test.wsdl;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.woden.WSDLException;
import org.ow2.easywsdl.schema.api.ComplexType;
import org.ow2.easywsdl.schema.api.Element;
import org.ow2.easywsdl.schema.api.Import;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.Sequence;
import org.ow2.easywsdl.schema.api.Type;
import org.ow2.easywsdl.schema.api.absItf.AbsItfElement;
import org.ow2.easywsdl.schema.api.absItf.AbsItfImport;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSequence;
import org.ow2.easywsdl.schema.api.absItf.AbsItfType;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.Binding;
import org.ow2.easywsdl.wsdl.api.BindingFault;
import org.ow2.easywsdl.wsdl.api.BindingInput;
import org.ow2.easywsdl.wsdl.api.BindingOperation;
import org.ow2.easywsdl.wsdl.api.BindingOutput;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.Fault;
import org.ow2.easywsdl.wsdl.api.Input;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Operation;
import org.ow2.easywsdl.wsdl.api.Output;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.Types;
import org.ow2.easywsdl.wsdl.api.WSDLWriter;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfBinding;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfBindingFault;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfBindingInput;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfBindingOperation;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfBindingOutput;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfEndpoint;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfFault;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfInput;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfInterfaceType;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOutput;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfService;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfTypes;
import org.ow2.easywsdl.wsdl.api.binding.BindingProtocol;
import org.ow2.easywsdl.wsdl.api.binding.wsdl11.soap.SOAPBinding4Wsdl11;
import org.ow2.easywsdl.wsdl.api.binding.wsdl11.soap.soap11.SOAP11Binding4Wsdl11;
import org.ow2.easywsdl.wsdl.api.binding.wsdl11.soap.soap11.SOAP11Body;
import org.ow2.easywsdl.wsdl.api.binding.wsdl11.soap.soap11.SOAP11Fault;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WSDLGeneratorTest
extends TestCase {
    private static final String TARGET_NAMESPACE = "http://petals.ow2.org/";

    public static QName cQName(String name) {
        return new QName(TARGET_NAMESPACE, name);
    }

    public Description createWSDL(Description desc) throws URISyntaxException, SchemaException {
        desc.setTargetNamespace(TARGET_NAMESPACE);
        desc.addNamespace("tns", TARGET_NAMESPACE);
        if (AbsItfDescription.WSDLVersionConstants.WSDL11.equals((Object)desc.getVersion())) {
            desc.setQName(WSDLGeneratorTest.cQName("myDescription"));
        }
        desc.setDocumentBaseURI(new File("src/test/resources/descriptors").toURI());
        Types types = (Types)desc.createTypes();
        Schema schema = (Schema)types.createSchema();
        schema.setTargetNamespace(TARGET_NAMESPACE);
        schema.getAllNamespaces().addNamespace("tns", TARGET_NAMESPACE);
        Import typeImport = (Import)schema.createImport();
        typeImport.setLocationURI(URI.create("reservationList.xsd"));
        typeImport.setNamespaceURI("http://greath.example.com/2004/schemas/reservationList");
        schema.addImport((AbsItfImport)typeImport);
        Type absComplexType = (Type)schema.createComplexType();
        absComplexType.setQName(new QName(TARGET_NAMESPACE, "seqEltType"));
        ComplexType complexType = (ComplexType)absComplexType;
        Sequence sequence = (Sequence)complexType.createSequence();
        Element elementRef = (Element)sequence.createElement();
        elementRef.setRef(new QName("http://greath.example.com/2004/schemas/reservationList", "reservation"));
        elementRef.setMinOccurs(1);
        elementRef.setMaxOccurs("unbounded");
        sequence.addElement((AbsItfElement)elementRef);
        complexType.setSequence((AbsItfSequence)sequence);
        schema.addType((AbsItfType)complexType);
        Element inputElmt = (Element)schema.createElement();
        inputElmt.setQName(WSDLGeneratorTest.cQName("inputElmt"));
        inputElmt.setType((AbsItfType)complexType);
        schema.addElement((AbsItfElement)inputElmt);
        Element outputElmt = (Element)schema.createElement();
        outputElmt.setQName(WSDLGeneratorTest.cQName("outputElmt"));
        outputElmt.setType((AbsItfType)org.ow2.easywsdl.schema.SchemaFactory.getDefaultSchema().getTypeString());
        schema.addElement((AbsItfElement)outputElmt);
        Element faultElmt = (Element)schema.createElement();
        faultElmt.setQName(WSDLGeneratorTest.cQName("faultElmt"));
        faultElmt.setType((AbsItfType)org.ow2.easywsdl.schema.SchemaFactory.getDefaultSchema().getTypeInt());
        schema.addElement((AbsItfElement)faultElmt);
        types.addSchema((AbsItfSchema)schema);
        desc.setTypes((AbsItfTypes)types);
        Service service = (Service)desc.createService();
        service.setQName(WSDLGeneratorTest.cQName("myService"));
        Endpoint endpoint = (Endpoint)service.createEndpoint();
        endpoint.setName("myEndpoint");
        endpoint.setAddress("http://localhost:8000/myEndpoint");
        InterfaceType itf = (InterfaceType)desc.createInterface();
        itf.setQName(WSDLGeneratorTest.cQName("myInterface"));
        Operation op = (Operation)itf.createOperation();
        if (AbsItfDescription.WSDLVersionConstants.WSDL20.equals((Object)desc.getVersion())) {
            op.setPattern(AbsItfOperation.MEPPatternConstants.IN_OUT);
        }
        op.setQName(WSDLGeneratorTest.cQName("myOperation"));
        Input input = (Input)op.createInput();
        if (AbsItfDescription.WSDLVersionConstants.WSDL11.equals((Object)desc.getVersion())) {
            input.setName("myInput");
        }
        input.setMessageName(WSDLGeneratorTest.cQName("myInputMessage"));
        input.setElement(inputElmt);
        Output output = (Output)op.createOutput();
        if (AbsItfDescription.WSDLVersionConstants.WSDL11.equals((Object)desc.getVersion())) {
            output.setName("myOutput");
        }
        output.setMessageName(WSDLGeneratorTest.cQName("myOutputMessage"));
        output.setElement(outputElmt);
        Fault fault = (Fault)op.createFault();
        if (AbsItfDescription.WSDLVersionConstants.WSDL11.equals((Object)desc.getVersion())) {
            fault.setName("myFault");
        }
        fault.setMessageName(WSDLGeneratorTest.cQName("myFaultMessage"));
        fault.setElement(faultElmt);
        op.setInput((AbsItfInput)input);
        op.setOutput((AbsItfOutput)output);
        op.addFault((AbsItfFault)fault);
        itf.addOperation((AbsItfOperation)op);
        if (AbsItfDescription.WSDLVersionConstants.WSDL20.equals((Object)desc.getVersion())) {
            service.setInterface((AbsItfInterfaceType)itf);
        }
        desc.addInterface((AbsItfInterfaceType)itf);
        service.addEndpoint((AbsItfEndpoint)endpoint);
        Binding binding = (Binding)desc.createBinding();
        binding.setQName(WSDLGeneratorTest.cQName("myBinding"));
        binding.setInterface((AbsItfInterfaceType)itf);
        binding.setTransportProtocol("http://schemas.xmlsoap.org/soap/http");
        for (Operation operation : itf.getOperations()) {
            SOAP11Body body;
            SOAP11Binding4Wsdl11 soap11binding;
            BindingOperation bindingOperation = (BindingOperation)binding.createBindingOperation();
            bindingOperation.setQName(operation.getQName());
            if (AbsItfDescription.WSDLVersionConstants.WSDL20.equals((Object)desc.getVersion())) {
                if (operation.getOutput() != null) {
                    bindingOperation.setMEP(BindingProtocol.SOAPMEPConstants.REQUEST_RESPONSE);
                } else {
                    bindingOperation.setMEP(BindingProtocol.SOAPMEPConstants.ONE_WAY);
                }
            }
            bindingOperation.setSoapAction(operation.getQName().getNamespaceURI() + (operation.getQName().getNamespaceURI().endsWith("/") ? "" : "/") + operation.getQName().getLocalPart().toString());
            if (operation.getInput() != null) {
                BindingInput binput = (BindingInput)bindingOperation.createInput();
                bindingOperation.setInput((AbsItfBindingInput)binput);
                if (AbsItfDescription.WSDLVersionConstants.WSDL11.equals((Object)desc.getVersion())) {
                    soap11binding = binput.createSOAP11Binding4Wsdl11();
                    body = soap11binding.createBody();
                    body.setUse(SOAPBinding4Wsdl11.UseConstants.LITERAL);
                    soap11binding.setBody(body);
                    binput.setSOAP11Binding4Wsdl11(soap11binding);
                }
            }
            if (operation.getOutput() != null) {
                BindingOutput boutput = (BindingOutput)bindingOperation.createOutput();
                bindingOperation.setOutput((AbsItfBindingOutput)boutput);
                if (AbsItfDescription.WSDLVersionConstants.WSDL11.equals((Object)desc.getVersion())) {
                    soap11binding = boutput.createSOAP11Binding4Wsdl11();
                    body = soap11binding.createBody();
                    body.setUse(SOAPBinding4Wsdl11.UseConstants.LITERAL);
                    soap11binding.setBody(body);
                    boutput.setSOAP11Binding4Wsdl11(soap11binding);
                }
            }
            if (operation.getFaults() != null) {
                for (Fault faultop : operation.getFaults()) {
                    BindingFault bfault = (BindingFault)bindingOperation.createFault();
                    bfault.setName(faultop.getName());
                    bindingOperation.addFault((AbsItfBindingFault)bfault);
                    bfault.setRef(faultElmt.getQName());
                    if (!AbsItfDescription.WSDLVersionConstants.WSDL11.equals((Object)desc.getVersion())) continue;
                    SOAP11Binding4Wsdl11 soap11binding2 = bfault.createSOAP11Binding4Wsdl11();
                    SOAP11Fault soap11Fault = soap11binding2.createFault();
                    soap11Fault.setUse(SOAPBinding4Wsdl11.UseConstants.LITERAL);
                    soap11Fault.setName(faultop.getName());
                    soap11binding2.setFault(soap11Fault);
                    bfault.setSOAP11Binding4Wsdl11(soap11binding2);
                }
            }
            binding.addBindingOperation((AbsItfBindingOperation)bindingOperation);
        }
        desc.addBinding((AbsItfBinding)binding);
        Binding defaultBinding = (Binding)desc.createDefaultSoapBinding("myDefaultBinding", (AbsItfEndpoint)endpoint, (AbsItfInterfaceType)itf);
        desc.addBinding((AbsItfBinding)defaultBinding);
        desc.addService((AbsItfService)service);
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((String)TARGET_NAMESPACE, (String)desc.getTargetNamespace());
        return desc;
    }

    public void testGeneratorWSDL11() throws URISyntaxException, SAXException, IOException, ParserConfigurationException, SchemaException {
        Description desc = WSDLFactory.newInstance().newDescription(AbsItfDescription.WSDLVersionConstants.WSDL11);
        desc = this.createWSDL(desc);
        WSDLWriter writer = WSDLFactory.newInstance().newWSDLWriter();
        this.validateDescription(desc, SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new Source[]{new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream("schema/xml.xsd")), new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream("schema/XMLSchemaWithoutDTD.xsd")), new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream("schema/wsdl/wsdl11/wsdl11.xsd")), new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream("schema/wsdl/wsdl11/extensions/soap11.xsd")), new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream("schema/wsdl/wsdl11/extensions/soap12.xsd")), new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream("schema/wsdl/wsdl11/extensions/http.xsd")), new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream("schema/wsdl/wsdl11/extensions/mime.xsd")), new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream("descriptors/wsdl20-instance.xsd")), new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream("descriptors/reservationDetails.xsd")), new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream("descriptors/reservationList.xsd"))}));
    }

    public void testGeneratorWSDL20() throws URISyntaxException, WSDLException, SAXException, IOException, ParserConfigurationException, SchemaException {
        Description desc = WSDLFactory.newInstance().newDescription(AbsItfDescription.WSDLVersionConstants.WSDL20);
        desc = this.createWSDL(desc);
        Document generatedDoc = WSDLFactory.newInstance().newWSDLWriter().getDocument(desc);
        this.validateDescription(desc, SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new Source[]{new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream("schema/xml.xsd")), new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream("schema/XMLSchemaWithoutDTD.xsd")), new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream("schema/wsdl/wsdl20/wsdl20.xsd")), new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream("schema/wsdl/wsdl20/wsdl20-instance.xsd")), new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream("schema/wsdl/wsdl20/extensions/soap.xsd")), new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream("schema/wsdl/wsdl20/extensions/http.xsd")), new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream("schema/wsdl/wsdl20/extensions/rpc.xsd")), new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream("descriptors/reservationDetails.xsd")), new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream("descriptors/reservationList.xsd"))}));
    }

    private void validateDescription(Description desc, javax.xml.validation.Schema schema) throws org.ow2.easywsdl.wsdl.api.WSDLException, ParserConfigurationException, SAXException, IOException, URISyntaxException {
        String wsdlStr = WSDLFactory.newInstance().newWSDLWriter().writeWSDL(desc);
        InputSource wsdlInputSource = new InputSource();
        wsdlInputSource.setCharacterStream(new StringReader(wsdlStr));
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        docBuilderFactory.setValidating(false);
        docBuilderFactory.setSchema(schema);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        final StringBuffer errors = new StringBuffer();
        docBuilder.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException arg0) throws SAXException {
                errors.append("\n" + arg0.getMessage());
            }

            @Override
            public void fatalError(SAXParseException arg0) throws SAXException {
                errors.append("\n" + arg0.getMessage());
            }

            @Override
            public void warning(SAXParseException arg0) throws SAXException {
                errors.append("\n" + arg0.getMessage());
            }
        });
        Document parsedDocument = docBuilder.parse(wsdlInputSource);
        parsedDocument.setDocumentURI(new File("src/test/resources/descriptors").toURI().toString());
        Description parsedDescription = WSDLFactory.newInstance().newWSDLReader().read(parsedDocument);
        Assert.assertTrue((String)("Validation errors exist:" + errors.toString()), (errors.length() == 0 ? 1 : 0) != 0);
    }
}

