/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.test.wsdl;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.woden.WSDLException;
import org.apache.woden.WSDLReader;
import org.apache.woden.WSDLSource;
import org.apache.woden.wsdl20.Description;
import org.apache.woden.wsdl20.Endpoint;
import org.apache.woden.wsdl20.InterfaceMessageReference;
import org.apache.woden.wsdl20.InterfaceOperation;
import org.apache.woden.wsdl20.Service;
import org.apache.woden.wsdl20.enumeration.Direction;
import org.apache.woden.wsdl20.extensions.ExtensionElement;
import org.apache.woden.wsdl20.extensions.ExtensionProperty;
import org.apache.woden.wsdl20.extensions.http.HTTPHeader;
import org.apache.woden.wsdl20.extensions.soap.SOAPHeaderBlock;
import org.apache.woden.wsdl20.extensions.soap.SOAPModule;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.Binding;
import org.ow2.easywsdl.wsdl.api.BindingFault;
import org.ow2.easywsdl.wsdl.api.BindingOperation;
import org.ow2.easywsdl.wsdl.api.Fault;
import org.ow2.easywsdl.wsdl.api.Input;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Operation;
import org.ow2.easywsdl.wsdl.api.Output;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfBinding;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfBindingParam;
import org.ow2.easywsdl.wsdl.test.util.BaseWSDLSource;
import org.ow2.easywsdl.wsdl.test.util.XSLTConverter;
import org.ow2.easywsdl.wsdl.test.wsdl.WSDLList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WodenComparisonTest
extends TestCase {
    public void testWoden() throws URISyntaxException, org.ow2.easywsdl.wsdl.api.WSDLException, WSDLException, XmlException, IOException, SAXException, ParserConfigurationException, javax.wsdl.WSDLException {
        org.ow2.easywsdl.wsdl.api.WSDLReader readerDesc = WSDLFactory.newInstance().newWSDLReader();
        WSDLReader readerDef = org.apache.woden.WSDLFactory.newInstance().newWSDLReader();
        for (URL wsdlUrl : WSDLList.getWsdls11()) {
            InputSource easyWsdlInputSource = XSLTConverter.getInstance().convert(wsdlUrl);
            easyWsdlInputSource.setSystemId(wsdlUrl.toString());
            org.ow2.easywsdl.wsdl.api.Description desc = readerDesc.read(easyWsdlInputSource);
            InputSource wodenInputSource = XSLTConverter.getInstance().convert(wsdlUrl);
            Description def = readerDef.readWSDL((WSDLSource)new BaseWSDLSource(wodenInputSource, wsdlUrl.toURI()));
            this.assertWithWodenModel(desc, def);
        }
        for (URL wsdlUrl : WSDLList.getWsdls20()) {
            org.ow2.easywsdl.wsdl.api.Description desc = readerDesc.read(wsdlUrl);
            Description def = readerDef.readWSDL(wsdlUrl.toString());
            this.assertWithWodenModel(desc, def);
        }
    }

    private void assertWithWodenModel(org.ow2.easywsdl.wsdl.api.Description desc, Description def) throws org.ow2.easywsdl.wsdl.api.WSDLException, URISyntaxException {
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((String)def.toElement().getTargetNamespace().toString(), (String)desc.getTargetNamespace());
        Assert.assertTrue((boolean)def.toElement().getDocumentBaseURI().toString().contains(desc.getDocumentBaseURI().toString()));
        Assert.assertNull((Object)desc.getQName());
        Assert.assertEquals((int)def.getServices().length, (int)desc.getServices().size());
        for (Service expectedService : def.getServices()) {
            org.ow2.easywsdl.wsdl.api.Service actualService = (org.ow2.easywsdl.wsdl.api.Service)desc.getService(expectedService.getName());
            Assert.assertNotNull((Object)actualService);
            Assert.assertEquals((Object)expectedService.getName(), (Object)actualService.getQName());
            if (expectedService.getInterface() != null) {
                Assert.assertEquals((Object)expectedService.getInterface().getName(), (Object)((InterfaceType)actualService.getInterface()).getQName());
            } else {
                Assert.assertNull((Object)actualService.getInterface());
            }
            Assert.assertEquals((int)expectedService.getEndpoints().length, (int)actualService.getEndpoints().size());
            for (Endpoint expectedEp : expectedService.getEndpoints()) {
                org.ow2.easywsdl.wsdl.api.Endpoint actualEp = (org.ow2.easywsdl.wsdl.api.Endpoint)actualService.getEndpoint(expectedEp.getName().toString());
                Assert.assertNotNull((Object)actualEp);
                Assert.assertEquals((String)expectedEp.getName().toString(), (String)actualEp.getName());
                if (expectedEp.getAddress() != null) {
                    Assert.assertEquals((String)expectedEp.getAddress().toString(), (String)actualEp.getAddress());
                } else {
                    Assert.assertNull((Object)actualEp.getAddress());
                }
                Assert.assertEquals((int)def.getBindings().length, (int)desc.getBindings().size());
                Assert.assertEquals((Object)expectedEp.getBinding().getName(), (Object)((Binding)actualEp.getBinding()).getQName());
                if (expectedEp.getBinding().getType() != null) {
                    Assert.assertEquals((String)expectedEp.getBinding().getType().toString(), (String)((Binding)actualEp.getBinding()).getTypeOfBinding().value().toString());
                } else {
                    Assert.assertNull((Object)((Binding)actualEp.getBinding()).getTypeOfBinding());
                }
                for (ExtensionProperty extensionProperty : expectedEp.getBinding().getExtensionProperties()) {
                    if (!extensionProperty.getNamespace().toString().equals(AbsItfBinding.BindingConstants.SOAP_BINDING4WSDL20.value().toString()) && !extensionProperty.getNamespace().toString().equals(AbsItfBinding.BindingConstants.HTTP_BINDING4WSDL20.value().toString()) && !extensionProperty.getNamespace().toString().equals(AbsItfBinding.BindingConstants.RPC_BINDING4WSDL20.value().toString()) || !(extensionProperty.getContent() instanceof URI)) continue;
                    Assert.assertEquals((String)extensionProperty.getContent().toString(), (String)((Binding)actualEp.getBinding()).getTransportProtocol());
                }
                Assert.assertEquals((int)expectedEp.getBinding().getBindingOperations().length, (int)((Binding)actualEp.getBinding()).getBindingOperations().size());
                for (ExtensionProperty extensionProperty : expectedEp.getBinding().getBindingOperations()) {
                    BindingOperation actualbop = (BindingOperation)((Binding)actualEp.getBinding()).getBindingOperation(extensionProperty.toElement().getRef().getLocalPart());
                    Assert.assertNotNull((Object)actualbop);
                    Assert.assertEquals((Object)extensionProperty.toElement().getRef(), (Object)actualbop.getQName());
                    for (ExtensionProperty extensionProperty2 : extensionProperty.getExtensionProperties()) {
                        if (!extensionProperty2.getNamespace().toString().equals(AbsItfBinding.BindingConstants.SOAP_BINDING4WSDL20.value().toString()) && !extensionProperty2.getNamespace().toString().equals(AbsItfBinding.BindingConstants.HTTP_BINDING4WSDL20.value().toString()) && !extensionProperty2.getNamespace().toString().equals(AbsItfBinding.BindingConstants.RPC_BINDING4WSDL20.value().toString()) || !(extensionProperty2.getContent() instanceof URI)) continue;
                        Assert.assertEquals((String)extensionProperty2.getContent().toString(), (String)actualbop.getMEP().value().toString());
                    }
                    for (ExtensionProperty extensionProperty3 : extensionProperty.getBindingMessageReferences()) {
                        if (extensionProperty3.toElement().getDirection().equals(Direction.IN)) {
                            this.assertonBindingParam(extensionProperty3.toElement().getExtensionElements(), (AbsItfBindingParam)actualbop.getInput());
                        }
                        if (!extensionProperty3.toElement().getDirection().equals(Direction.OUT)) continue;
                        this.assertonBindingParam(extensionProperty3.toElement().getExtensionElements(), (AbsItfBindingParam)actualbop.getOutput());
                    }
                    for (ExtensionProperty extensionProperty4 : extensionProperty.getBindingFaultReferences()) {
                        BindingFault actualfault = (BindingFault)actualbop.getFault(extensionProperty4.toElement().getMessageLabel().toString());
                        Assert.assertNotNull((Object)actualfault);
                        Assert.assertEquals((String)extensionProperty4.toElement().getMessageLabel().toString(), (String)actualfault.getName());
                        this.assertonBindingParam(extensionProperty4.toElement().getExtensionElements(), (AbsItfBindingParam)actualfault);
                    }
                    Assert.assertEquals((int)def.getInterfaces().length, (int)desc.getInterfaces().size());
                    for (ExtensionProperty extensionProperty5 : def.getInterfaces()) {
                        InterfaceType actualitf = (InterfaceType)desc.getInterface(extensionProperty5.getName());
                        Assert.assertNotNull((Object)actualitf);
                        Assert.assertEquals((Object)extensionProperty5.getName(), (Object)actualitf.getQName());
                        Assert.assertEquals((int)extensionProperty5.getAllInterfaceOperations().length, (int)actualitf.getOperations().size());
                        for (InterfaceOperation expectedop : extensionProperty5.getAllInterfaceOperations()) {
                            Operation actualop = (Operation)actualitf.getOperation(expectedop.getName());
                            Assert.assertNotNull((Object)actualop);
                            Assert.assertEquals((Object)expectedop.getName(), (Object)actualop.getQName());
                            Assert.assertEquals((String)expectedop.getMessageExchangePattern().toString(), (String)actualop.getPattern().value().toString());
                            for (InterfaceMessageReference interfaceMessageReference : expectedop.getInterfaceMessageReferences()) {
                                if (interfaceMessageReference.getDirection().equals(Direction.IN)) {
                                    Assert.assertNotNull((Object)actualop.getInput());
                                    if (interfaceMessageReference.getMessageLabel() != null) {
                                        Assert.assertEquals((String)interfaceMessageReference.getMessageLabel().toString(), (String)((Input)actualop.getInput()).getMessageName().getLocalPart());
                                    } else {
                                        Assert.assertNull((Object)((Input)actualop.getInput()).getMessageName());
                                    }
                                    Assert.assertEquals(null, (Object)((Input)actualop.getInput()).getParts());
                                    if (interfaceMessageReference.toElement().getElement() != null && interfaceMessageReference.toElement().getElement().getQName() != null) {
                                        Assert.assertEquals((Object)interfaceMessageReference.toElement().getElement().getQName(), (Object)((Input)actualop.getInput()).getElement().getQName());
                                    } else {
                                        Assert.assertNull((Object)((Input)actualop.getInput()).getElement());
                                    }
                                }
                                if (!interfaceMessageReference.getDirection().equals(Direction.OUT)) continue;
                                Assert.assertNotNull((Object)actualop.getOutput());
                                Assert.assertEquals((String)interfaceMessageReference.getMessageLabel().toString(), (String)((Output)actualop.getOutput()).getMessageName().getLocalPart());
                                Assert.assertEquals(null, (Object)((Output)actualop.getOutput()).getParts());
                                if (interfaceMessageReference.toElement().getElement() != null && interfaceMessageReference.toElement().getElement().getQName() != null) {
                                    Assert.assertEquals((Object)interfaceMessageReference.toElement().getElement().getQName(), (Object)((Output)actualop.getOutput()).getElement().getQName());
                                    continue;
                                }
                                Assert.assertNull((Object)((Output)actualop.getOutput()).getElement());
                            }
                            Assert.assertEquals((int)expectedop.getInterfaceFaultReferences().length, (int)actualop.getFaults().size());
                            for (InterfaceMessageReference interfaceMessageReference : expectedop.getInterfaceFaultReferences()) {
                                Fault actualFault = (Fault)actualop.getFaultByElementName(interfaceMessageReference.getInterfaceFault().getName());
                                Assert.assertNotNull((Object)actualFault);
                                Assert.assertEquals((String)interfaceMessageReference.getMessageLabel().toString(), (String)actualFault.getMessageName().getLocalPart());
                                Assert.assertEquals(null, (Object)actualFault.getParts());
                                if (interfaceMessageReference.getInterfaceFault() != null) {
                                    Assert.assertEquals((Object)interfaceMessageReference.getInterfaceFault().getName(), (Object)actualFault.getElement().getQName());
                                    continue;
                                }
                                Assert.assertNull((Object)actualFault.getElement());
                            }
                        }
                    }
                }
            }
        }
    }

    private void assertonBindingParam(ExtensionElement[] items, AbsItfBindingParam actualparam) {
        ArrayList<HTTPHeader> httpHeaders = new ArrayList<HTTPHeader>();
        ArrayList<SOAPHeaderBlock> soapHeaders = new ArrayList<SOAPHeaderBlock>();
        ArrayList<SOAPModule> soapModules = new ArrayList<SOAPModule>();
        for (ExtensionElement item : items) {
            if (item instanceof SOAPModule) {
                soapModules.add((SOAPModule)item);
                continue;
            }
            if (item instanceof SOAPHeaderBlock) {
                soapHeaders.add((SOAPHeaderBlock)item);
                continue;
            }
            if (!(item instanceof HTTPHeader)) continue;
            httpHeaders.add((HTTPHeader)item);
        }
        if (soapModules.size() > 0 || soapHeaders.size() > 0) {
            Assert.assertNotNull((Object)actualparam.getSOAP12Binding4Wsdl20());
            Assert.assertEquals((int)soapModules.size(), (int)actualparam.getSOAP12Binding4Wsdl20().getModules().size());
            Assert.assertEquals((int)soapHeaders.size(), (int)actualparam.getSOAP12Binding4Wsdl20().getHeaders().size());
        } else {
            Assert.assertNull((Object)actualparam.getSOAP12Binding4Wsdl20());
        }
        if (httpHeaders.size() > 0) {
            Assert.assertNotNull((Object)actualparam.getHTTPBinding4Wsdl20());
            Assert.assertEquals((int)httpHeaders.size(), (int)actualparam.getHTTPBinding4Wsdl20().getHeaders().size());
        } else {
            Assert.assertNull((Object)actualparam.getHTTPBinding4Wsdl20());
        }
    }
}

