/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.seacloud.server;

import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.cxf.CXFHelper;
import com.ebmwebsourcing.easycommons.research.util.cxf.Server;
import com.ebmwebsourcing.easycommons.research.util.easybox.DefaultFramework;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Port;
import com.ebmwebsourcing.easywsdl11.api.element.Service;
import com.ebmwebsourcing.seacloud.server.SeaCloudManagementImpl;
import com.ebmwebsourcing.soapbinding11.api.SoapBindingHelper;
import com.ebmwebsourcing.soapbinding11.api.element.Address;
import java.util.List;
import javax.xml.namespace.QName;
import seacloud.petalslink.com.data._1.ResourcesDescriptor;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagementException;

public class SeaCloud
implements Server {
    private Server ep = null;
    private Object implementation = null;
    private Definitions def = null;
    private Port endpoint = null;
    private Service service = null;
    private boolean isStopped = false;
    private ResourcesDescriptor descriptor = null;

    public SeaCloud(String address, ResourcesDescriptor descriptor, CEP_MODE mode, boolean useCepMock, boolean useEventCloudMock) throws CloudManagementException {
        this.implementation = new SeaCloudManagementImpl(descriptor, address, mode, useCepMock, useEventCloudMock);
        this.ep = CXFHelper.getService((String)address, this.implementation.getClass(), (Object)this.implementation);
        try {
            if (this.ep.getWsdlLocation() == null) {
                throw new CloudManagementException("Impossible to find wsdl location on " + this.implementation.getClass());
            }
            this.def = (Definitions)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)DefaultFramework.getInstance()).get()).readDocument(Thread.currentThread().getContextClassLoader().getResource(this.ep.getWsdlLocation()), Definitions.class);
            this.service = this.def.getServiceByName(this.ep.getServiceQName().getLocalPart());
            this.endpoint = this.service.getPorts()[0];
            Address addr = SoapBindingHelper.getAddress((Port)this.endpoint);
            addr.setLocation(address);
            SoapBindingHelper.setAddress((Port)this.endpoint, (Address)addr);
        }
        catch (XmlObjectReadException e) {
            throw new CloudManagementException(e.getMessage(), (Throwable)e);
        }
    }

    public List<ResourcesDescriptor> getDescriptors() {
        return ((SeaCloudManagementImpl)this.implementation).getDescriptors();
    }

    public void setDescriptor(ResourcesDescriptor descriptor) throws CloudManagementException {
        ((SeaCloudManagementImpl)this.implementation).setDescriptor(descriptor);
    }

    public String getAddress() {
        return this.ep.getAddress();
    }

    public void start() {
        this.ep.start();
        System.out.println("Start Server and expose service at this address: " + this.getAddress() + "?wsdl");
        this.isStopped = false;
    }

    public void stop() {
        ((SeaCloudManagementImpl)this.implementation).stop();
        this.ep.stop();
        this.isStopped = true;
    }

    public QName getServiceQName() {
        return this.service.inferQName();
    }

    public String getWsdlLocation() {
        return this.def.getXmlObjectBaseURI().toString();
    }

    public boolean isStopped() {
        return false;
    }

    public static enum CEP_MODE {
        ESPER,
        ETALIS;

    }
}

