package com.ebmwebsourcing.seacloud.server;
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * TopologyView.java
 *
 * Created on 17 mars 2011, 22:32:08
 */


import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

import org.petalslink.easiestdemo.client.gui.PropertiesTableModel;
import org.petalslink.easiestdemo.client.model.api.gov.ProvidedService;
import org.petalslink.easiestdemo.client.topology.EndpointG;
import org.petalslink.easiestdemo.client.topology.EsbG;
import org.petalslink.easiestdemo.client.topology.ExternalClientEndpointG;
import org.petalslink.easiestdemo.client.topology.ExternalProviderEndpointG;
import org.petalslink.easiestdemo.client.topology.GovG;
import org.petalslink.easiestdemo.client.topology.InternalProviderProxyEndpointG;
import org.petalslink.easiestdemo.client.topology.LineEsbOrGovToEndpointG;
import org.petalslink.easiestdemo.client.topology.ProvidedServiceG;
import org.petalslink.easiestdemo.client.topology.TopologyView;

import com.ebmwebsourcing.seacloud.server.model.CepNode;
import com.ebmwebsourcing.seacloud.server.model.EventCloudNode;

/**
 *
 * @author Nico
 */
public class SeaCloudTopologyView extends TopologyView {


	private SeaCloudG seaCloudG;
	private List<CepG> cepG = new ArrayList<CepG>();
	private List<EventCloudG> eventCloudG = new ArrayList<EventCloudG>();

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;



	/** Creates new form TopologyView */
	public SeaCloudTopologyView(Dimension dim, SeaCloudUI client) {
		super(dim, client);
	}

	@Override
	public void refresh() {
		super.refresh();

		if(((SeaCloudRegistry)this.registry).getSeaCloudNode() != null) {
			this.seaCloudG = new SeaCloudG(this, ((SeaCloudRegistry)this.registry).getSeaCloudNode(), 20, 200);
			int init_client_x = (int) (this.getSize().width - (SeaCloudG.DEFAULT_WIDTH + SeaCloudG.DEFAULT_WIDTH/2)) ;
			int spacey_client = this.getSize().height / (((SeaCloudRegistry)this.registry).getSeaCloudNode().getProvidedServices().size()+1);
			int init_client_y = spacey_client;
			for(ProvidedService providedService: ((SeaCloudRegistry)this.registry).getSeaCloudNode().getProvidedServices()) {
				if(findExternalClientEndpointGCorrespondingToThisEndpoint(providedService) == null) {
					this.externalClientEndpoints.add(new ExternalClientEndpointG(this, providedService, init_client_x, init_client_y));
					init_client_y = init_client_y + spacey_client;
				}
			}
		}
		int posX = (int)this.getSize().getWidth() / 2 - CepG.DEFAULT_WIDTH/2;
		if(this.cepG == null) {
			this.cepG = new ArrayList<CepG>();
		} else {
			this.cepG.clear();
		}
		if(((SeaCloudRegistry)this.registry).getCepNodes() != null) {
			for(CepNode cep: ((SeaCloudRegistry)this.registry).getCepNodes()) {
				this.cepG.add(new CepG(this, cep, posX, 50));
			}
		}
		posX = (int)this.getSize().getWidth() / 2 - EventCloudG.DEFAULT_WIDTH/2;
		if(this.eventCloudG == null) {
			this.eventCloudG = new ArrayList<EventCloudG>();
		} else {
			eventCloudG.clear();
		}
		if(((SeaCloudRegistry)this.registry).getEventCloudNodes() != null) {
			for(EventCloudNode ev: ((SeaCloudRegistry)this.registry).getEventCloudNodes()) {
				this.eventCloudG.add(new EventCloudG(this, ev, posX, 120));
			}
		}
		
		// delete SeaCloud external endpoint
		for(EsbG esb: this.esbs) {
			List<InternalProviderProxyEndpointG> ipps = new ArrayList<InternalProviderProxyEndpointG>();
			for(InternalProviderProxyEndpointG ipp: esb.getProxyProviders()) {
				if(ipp.getQName().getLocalPart().toLowerCase().contains("seacloud")) {
					ipps.add(ipp);
				}
			}
			for(InternalProviderProxyEndpointG ipp: ipps) {
				esb.getProxyProviders().remove(ipp);
			}
		}
		List<ExternalProviderEndpointG> epps = new ArrayList<ExternalProviderEndpointG>();
		for(ExternalProviderEndpointG epp: this.externalProviderEndpoints) {
			if(epp.getQName().getLocalPart().toLowerCase().contains("seacloud")) {
				epps.add(epp);
			}
		}
		for(ExternalProviderEndpointG epp: epps) {
			this.externalProviderEndpoints.remove(epp);
		}
		
		this.repaint();
	}



	@Override
	public Object getObjectContainedIn(MouseEvent evt) {
		Object res = super.getObjectContainedIn(evt);
		// find in seaCloud
		if(res == null) {
			if(this.seaCloudG != null) {
				for(ProvidedServiceG providedService: this.seaCloudG.getProvidedServices()) {
					if (res == null && providedService.contains(evt.getX(), evt.getY())) {
						res = providedService;
						break;
					} 
				}
			}
		}
		return res;
	}

	@Override
	public void paint(Graphics g) {
		Graphics2D g2 = (Graphics2D) g;
		g2.setPaint(Color.white);
		g2.drawRect(0, 0, (int) this.getWidth(), (int) this.getHeight());
		g2.fillRect(0, 0, (int) this.getWidth(), (int) this.getHeight());
		if(seaCloudG != null) {
			new LineSeaCloudToGovG(seaCloudG, this.govg).update(g);

			if(this.client.getCustomView().showClientEndpoint()) {
				// lines between clientProxyEndpoint and providedService of seacloud
				for(ProvidedServiceG icpe: this.seaCloudG.getProvidedServices()) {
					for(ExternalClientEndpointG ece: this.externalClientEndpoints) {
						if(icpe.getQName().equals(ece.getQName())) {
							new LineEsbOrGovToEndpointG(icpe, ece).update(g);
						}
					}
				}
			}

			for(EsbG nodeG: this.esbs) {
				if(!nodeG.getModel().isMonitoringNode()) {
					new LineSeaCloudToEsbG(seaCloudG,nodeG).update(g);
				}
			}

			if(this.cepG != null) {
				for(CepG cep: this.cepG) {
					new LineSeaCloudToCepG(seaCloudG,cep).update(g);
				}
			}
			if(this.eventCloudG != null) {
				for(EventCloudG eventCloud: this.eventCloudG) {
					new LineSeaCloudToEventCloudG(seaCloudG,eventCloud).update(g);
				}
			}
		}
		this.draw(g);

		if(seaCloudG != null) {
			seaCloudG.update(g);
		}
		if(this.cepG != null) {
			for(CepG cep: this.cepG) {
				cep.update(g);
			}
		}
		if(this.eventCloudG != null) {
			for(EventCloudG eventCloud: this.eventCloudG) {
				eventCloud.update(g);
			}
		}
		if(this.internalEndpointToPrint != null) {
			g.setColor(this.internalEndpointToPrint.getColor());
			g.drawString(this.internalEndpointToPrint.getText(), (int)this.internalEndpointToPrint.getX(), (int)this.internalEndpointToPrint.getY());
		}
		g.dispose();
	}


	protected void formMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_formMouseDragged
		super.formMouseDragged(evt);
		if(draggedItem != null) {
			if(draggedItem instanceof SeaCloudG) {
				((SeaCloudG)draggedItem).setLocation(evt.getX(), evt.getY());
			} else if(draggedItem instanceof CepG) {
				((CepG)draggedItem).setLocation(evt.getX(), evt.getY());
			} else if(draggedItem instanceof EventCloudG) {
				((EventCloudG)draggedItem).setLocation(evt.getX(), evt.getY());
			} 
			this.repaint();
		}		
	}//GEN-LAST:event_formMouseDragged

	protected void formMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_formMousePressed
		super.formMousePressed(evt);
		if(draggedItem == null){
			if(this.seaCloudG != null) {
				if (this.seaCloudG.contains(evt.getX(), evt.getY())) {
					draggedItem = this.seaCloudG;
					this.seaCloudG.setMove(true);
				} 
			}
		}
		if(draggedItem == null) {
			for(CepG pe: this.cepG) {
				if (pe.contains(evt.getX(), evt.getY())) {
					draggedItem = pe;
					pe.setMove(true);
					break;
				} 
			}
		}
		if(draggedItem == null) {
			for(EventCloudG pe: this.eventCloudG) {
				if (pe.contains(evt.getX(), evt.getY())) {
					draggedItem = pe;
					pe.setMove(true);
					break;
				} 
			}
		}
	}//GEN-LAST:event_formMousePressed

	protected void formMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_formMouseReleased
		super.formMouseReleased(evt);
		if(draggedItem instanceof GovG) {
			((SeaCloudG)draggedItem).setMove(false);
		}
		if(draggedItem instanceof CepG) {
			((CepG)draggedItem).setMove(false);
		}
		if(draggedItem instanceof EventCloudG) {
			((EventCloudG)draggedItem).setMove(false);
		}
		draggedItem = null;
	}//GEN-LAST:event_formMouseReleased

	protected void formMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_formMouseMoved
		super.formMouseMoved(evt);
		Object selectedItem = this.getObjectContainedIn(evt);
		if(selectedItem instanceof SeaCloudG) {
			this.client.getjTableProperties().setModel(new PropertiesTableModel(((SeaCloudG)selectedItem).getProperties()));
		} else if(selectedItem instanceof CepG) {
			this.client.getjTableProperties().setModel(new PropertiesTableModel(((CepG)selectedItem).getProperties()));
		} else if(selectedItem instanceof EventCloudG) {
			this.client.getjTableProperties().setModel(new PropertiesTableModel(((EventCloudG)selectedItem).getProperties()));
		} 

		this.repaint();
	}//GEN-LAST:event_formMouseMoved

	protected void formMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_formMouseEntered
	}//GEN-LAST:event_formMouseEntered
}
