package com.ebmwebsourcing.cep.server;


import javax.xml.namespace.QName;

import seacloud.petalslink.com.data._1.ResourcesDescriptor;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagementException;

import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easycommons.research.util.cxf.CXFHelper;
import com.ebmwebsourcing.easycommons.research.util.cxf.Server;
import com.ebmwebsourcing.easycommons.research.util.easybox.DefaultFramework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Port;
import com.ebmwebsourcing.easywsdl11.api.element.Service;
import com.ebmwebsourcing.soapbinding11.api.SoapBindingHelper;
import com.ebmwebsourcing.soapbinding11.api.element.Address;

/**
 * This class was generated by Apache CXF 2.2.9
 * Tue Feb 01 10:31:55 CET 2011
 * Generated source version: 2.2.9
 * 
 */

public class Cep implements Server {
	
	public enum CEP_MODE {ESPER, ETALIS};

    private com.ebmwebsourcing.easycommons.research.util.cxf.Server ep = null;

    private Object implementation = null;

    private Definitions def = null;
    
    private Port endpoint = null;
    
    private Service service = null;
    
    private boolean isStopped = false;

    public Cep(String address) throws CloudManagementException {
        this.implementation = new CepManagementImpl(address);
        ep = CXFHelper.getService(address, this.implementation.getClass(), this.implementation);
        System.out.println("***************** CEP Started on : " + address);
        try {
        	System.out.println("ep.getWsdlLocation() = " + ep.getWsdlLocation());
            if(ep.getWsdlLocation() != null) {
                def = SOAUtil.getInstance().getReader(DefaultFramework.getInstance()).get().readDocument(Thread.currentThread().getContextClassLoader().getResource(ep.getWsdlLocation()), Definitions.class);
                System.out.println("********************* def = ");
                service = def.getServiceByName(ep.getServiceQName().getLocalPart());
                System.out.println("********************* service = " + service);
                endpoint = service.getPorts()[0];
                System.out.println("********************* endpoint = " + endpoint);
                Address addr = SoapBindingHelper.getAddress(endpoint);
                System.out.println("********************* addr = " + addr);
                addr.setLocation(address);
                System.out.println("********************* addr2 = " + addr);
                SoapBindingHelper.setAddress(endpoint, addr);
                System.out.println("********************* endpoint = " + endpoint);
            } else {
                throw new CloudManagementException("Impossible to find wsdl location on " + this.implementation.getClass());
            }
        } catch (XmlObjectReadException e) {
        	e.printStackTrace();
            throw new CloudManagementException(e.getMessage(), e);
        }
    }


    @Override
    public String getAddress() {
        return ep.getAddress();
    }

    @Override
    public void start() {
        ep.start();
        System.out.println("Start Server and expose service at this address: " + this.getAddress() + "?wsdl");
        isStopped = false;
    }

    @Override
    public void stop() {
        ep.stop();
        isStopped = true;
    }


	@Override
	public QName getServiceQName() {
		return this.service.inferQName();
	}


	@Override
	public String getWsdlLocation() {
		return def.getXmlObjectBaseURI().toString();
	}


	@Override
	public boolean isStopped() {
		// TODO Auto-generated method stub
		return false;
	}


}

