package com.ebmwebsourcing.cep.server;

import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.logging.Logger;

import org.jaxen.JaxenException;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.SimpleVariableContext;
import org.jaxen.XPath;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Element;
import org.jdom.Namespace;



public class ExpressionEvaluator {

	private static final Logger LOG = Logger
			.getLogger(ExpressionEvaluator.class.getName());

	public Object evaluateAsNode(Map<String, Element> varContext, String expression, List<Namespace> nss) throws JaxenException {
		LOG.finest("XPATH = " + expression);
		XPath xpath = createXPath(varContext, expression, nss);
		Object result = xpath.selectSingleNode(null);
		LOG.finest("XPATH RESULT = " + result);
		return result;

	}

	@SuppressWarnings("unchecked")
	private final XPath createXPath(Map<String, Element> varContext, String expression, List<Namespace> nss) throws JaxenException {

		//		XPathFunctionContext functionContext = new XPathFunctionContext();
		//		functionContext.registerFunction(Constants.BPEL_20_EXECUTABLE_NAMESPACE, 
		//				"doXslTransform", new DoXslTransformFunction(bpelProcess.getDocumentBaseURI()));
		//		functionContext.registerFunction(Constants.BPEL_20_EXECUTABLE_NAMESPACE, 
		//				"getVariableProperty", new GetVariablePropertyFunction(execution));

		SimpleVariableContext variableContext = new SimpleVariableContext();
		XPath xpath = new JDOMXPath(expression);


		SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext();
		for (Namespace ns : nss) {
			namespaceContext.addNamespace(ns.getPrefix(), ns.getURI());
		}


		for (Entry<String, Element> entry : varContext.entrySet()) {
			String variableName = entry.getKey();
			assert variableName != null;
			Element variableValue = entry.getValue();

			declareVariableInVariableContext(variableName, variableValue, variableContext, variableValue.getNamespace().getURI());
		}

		xpath.setNamespaceContext(namespaceContext);
		xpath.setVariableContext(variableContext);
		//	xpath.setFunctionContext(functionContext);
		return xpath;

	}


	private void declareVariableInVariableContext(String variableName, Object variableValue,
			SimpleVariableContext variableContext, String namespace) {
		variableContext.setVariableValue(variableName, variableValue);
		variableContext.setVariableValue(namespace, variableName, variableValue);
	}
}
