package com.ebmwebsourcing.eval;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;

import javax.net.ServerSocketFactory;

public class EvalLoggerServer {

	private int port = 5000;
	private ServerSocket serverSocket;

	public EvalLoggerServer(int port) throws IOException {
		this.port = port;
		serverSocket = createServerSocket ();
	}
	
	public void start() throws IOException {
		listenAndPrintLogMessages ();
	}

	private void listenAndPrintLogMessages () throws IOException {
		FileWriter fw = new FileWriter("aggregate-events.log", true);
		BufferedWriter output = new BufferedWriter(fw);
		while (true) {
			Socket socket = null;
			try {
				System.out.println (" >> Server waiting for log messages...");
				socket = serverSocket.accept ();

						InputStream is = socket.getInputStream ();
						BufferedReader br = new BufferedReader (new InputStreamReader (is, "US-ASCII"));
						String line = null;
						while ((line = br.readLine ()) != null) {
							System.out.println (line);
							output.write(line + "\n");
							output.flush();
						}
			} catch (Exception e) {
				e.printStackTrace ();
			} finally {
				if (socket != null) {
					try {
						socket.close ();
					} catch (IOException ignored) {
					}
				}
				if(output != null) {
					output.close();
				}
			}
		}
	}

	private ServerSocket createServerSocket () {
		ServerSocketFactory serverSocketFactory = ServerSocketFactory.getDefault ();
		try {
			serverSocket = serverSocketFactory.createServerSocket (port);
		} catch (IOException ioEx) {
			System.err.println ("Unable to create server");
			ioEx.printStackTrace();
			System.exit ( -1);
		}
		return serverSocket;
	}

}
