/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.eval;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.eval.LogFormatter;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SocketHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EvalLogger {
    private static Logger logger = Logger.getLogger(EvalLogger.class.getSimpleName());
    private Handler socketHandler;
    private Handler fileHandler;
    private static EvalLogger INSTANCE;

    private EvalLogger() {
        this.createSocketHandler();
        this.createFileHandler();
    }

    private void createFileHandler() {
        try {
            this.fileHandler = new FileHandler("eval-log-%u.log");
            this.fileHandler.setLevel(Level.FINEST);
            this.fileHandler.setFormatter(new LogFormatter());
            logger.addHandler(this.socketHandler);
        }
        catch (Exception e) {
            System.err.println("Warning!!! Impossible to connect FileHandler: " + e.getMessage());
        }
    }

    private void createSocketHandler() {
        try {
            this.socketHandler = new SocketHandler("localhost", 5000);
            this.socketHandler.setLevel(Level.FINEST);
            this.socketHandler.setFormatter(new LogFormatter());
            logger.setLevel(Level.FINEST);
        }
        catch (IOException e) {
            System.err.println("Warning!!! Impossible to connect SocketHandler: " + e.getMessage());
        }
    }

    public static EvalLogger getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EvalLogger();
        }
        return INSTANCE;
    }

    public synchronized void log(Level level, String msg) {
        System.out.println("socketHandler: " + this.socketHandler);
        if (this.socketHandler != null) {
            logger.addHandler(this.socketHandler);
        }
        if (this.fileHandler != null) {
            logger.addHandler(this.fileHandler);
        }
        logger.log(level, msg);
        if (this.socketHandler != null) {
            logger.removeHandler(this.socketHandler);
        }
        if (this.fileHandler != null) {
            logger.removeHandler(this.fileHandler);
        }
    }

    public void logNotif(Class clazz, String component, Direction direction, EJaxbNotify notify) {
        this.logNotif(clazz, component, direction, notify, null);
    }

    public void logNotif(Class clazz, String component, Direction direction, EJaxbNotify notify, List<String> correlatedIds) {
        try {
            String eventID = EvalLogger.getEventIdInNotify(notify);
            if (eventID == null) {
                eventID = this.setEventIdInNotify(notify);
            }
            String msg = clazz.getName() + " " + component + " " + (Object)((Object)direction) + " " + eventID + " ";
            if (correlatedIds != null) {
                for (String correlatedId : correlatedIds) {
                    msg = msg + correlatedId + " ";
                }
            }
            this.log(Level.INFO, msg);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private String setEventIdInNotify(EJaxbNotify notify) {
        String eventId = "http://events.event-processing.org/ids/" + UUID.randomUUID().toString();
        Document emissionDate = this.createEventID(eventId);
        notify.getAny().add(emissionDate.getDocumentElement());
        return eventId;
    }

    public static String getEventIdInNotify(EJaxbNotify notify) {
        String eventId = null;
        for (Object obj : notify.getAny()) {
            Element elmt;
            if (!(obj instanceof Element) || !(elmt = (Element)obj).getNamespaceURI().equals("http://wwww.soceda.org/ids") || !elmt.getLocalName().equals("eventID")) continue;
            eventId = elmt.getAttribute("id");
            break;
        }
        return eventId;
    }

    private Document createEventID(String eventID) {
        Document doc = null;
        try {
            doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
            Element id = doc.createElementNS("http://wwww.soceda.org/ids", "eventID");
            id.setPrefix("id");
            id.setAttribute("id", eventID);
            doc.appendChild(id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    public static enum Direction {
        Entry,
        Exit;

    }
}

