package com.ebmwebsourcing.eventcloud.mocked.filter;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

import javax.naming.NamingException;
import javax.swing.JOptionPane;

import org.eclipse.jetty.util.log.Log;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.proactive.core.component.Fractive;
import org.soceda.socialfilter.relationshipstrengthengine.RelationshipStrength;
import org.soceda.socialfilter.relationshipstrengthengine.RelationshipStrengthEngineManager;
import org.soceda.socialfilter.relationshipstrengthengine.RelationshipStrengthEngineManagerFactory;

import com.ebmwebsourcing.eventcloud.mocked.server.AbstractFilter;


public class SocialFilter extends AbstractFilter {

    private static final Logger LOG = Logger.getLogger(SocialFilter.class.getName());

    private RelationshipStrengthEngineManager rsengman = null;

    double threshold = 0.5;

    @Override
    public void init(String socialFilterUri) {
        if (socialFilterUri != null) {
            try {
                Component comp = Fractive.lookup(socialFilterUri);
                this.rsengman = ((RelationshipStrengthEngineManager) comp
                        .getFcInterface(RelationshipStrengthEngineManagerFactory.RELATION_STRENGTH_ENGINE_MANAGER_ITF));
            } catch (IOException e) {
                e.printStackTrace();
            } catch (NamingException e) {
                e.printStackTrace();
            } catch (NoSuchInterfaceException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean filter(final String clientAddress, final String producerAddress, boolean ui) {
        boolean res = false;

        BigDecimal bd = null;
        if (rsengman == null) {
            LOG.warning("You must deploy relation graph before using social filter!!!!");
            return true;
        }
        System.out.println("mmmmmmmmmmmmmmmmmm FILTERING BETWEEN " + clientAddress + " AND " +
            producerAddress);
        LOG.info("mmmmmmmmmmmmmmmmmm FILTERING BETWEEN " + clientAddress + " AND " + producerAddress);
        bd = null;
        try {

            /* init the input of the test case */
            String source_node_id = clientAddress;
            Set<String> target_node_ids = new HashSet<String>();
            target_node_ids.add(producerAddress);

            //        rsengman = RelationshipStrengthEngineManagerFactory
            //                .newRelationshipStrengthEngineManager(rseng);
            ArrayList<RelationshipStrength> rslist = rsengman.rank_target_nodes_wrt_relationship_strength(
                    source_node_id, target_node_ids);

            System.out.println("mmmmmmmmmmmmmmmmmm FILTERING LIST " + rslist);
            LOG.info("mmmmmmmmmmmmmmmmmm FILTERING LIST " + rslist);

            if (rslist != null && rslist.size() > 0) {
                String target_node = rslist.get(0).getTargetNodeId();
                bd = new BigDecimal(rslist.get(0).getStrength());
                bd = bd.setScale(2, BigDecimal.ROUND_HALF_UP);

                System.out.println("target_node: " + target_node + " - strenght: " + bd.toString());

                if(bd.doubleValue() == 0.0) {
                	LOG.info("source or target are unknown in social filter"); 
                	res = true;
                } else if (bd.doubleValue() >= this.threshold) {
                    res = true;
                }

                if (producerAddress.toLowerCase().contains("motorist") && res == false) {
                    System.err.println("mmmmmmmmmmmmmmmmmm FILTERING ERROR: motorist must returned true");
                    res = true;
                }
                if (producerAddress.toLowerCase().contains("vehicle") && res == false) {
                    System.err.println("mmmmmmmmmmmmmmmmmm FILTERING ERROR: vehicle must returned true");
                    res = true;
                }

            } else {
                res = true;
            }
        } catch (Throwable e) {
            //			System.out.println("mmmmmmmmmmmmmmmmm FILETRING PB");
            e.printStackTrace();
            LOG.info("mmmmmmmmmmmmmmmmmm FILTERING PB : " + e.getMessage());
            res = true;

            if (producerAddress.toLowerCase().contains("car")) {
                System.err.println("mmmmmmmmmmmmmmmmmm FILTERING ERROR: motorist must returned true");
                res = false;
            }
            if (producerAddress.toLowerCase().contains("bus")) {
                System.err.println("mmmmmmmmmmmmmmmmmm FILTERING ERROR: vehicle must returned true");
                res = false;
            }
        }
        System.out.println("mmmmmmmmmmmmmmmmmm FILTERING RESULT " + res);
        LOG.info("mmmmmmmmmmmmmmmmmm FILTERING RESULT BETWEEN " + clientAddress + " AND " + producerAddress + " : " + res + " -  value: " + bd);
        if (ui && res == false) {
            Thread t = new GUI(producerAddress, clientAddress, bd);
            t.start();
        }
        return res;
    }

    public class GUI extends Thread {

        private BigDecimal bd;
        private String producerAddress;
        private String clientAddress;

        public GUI(String producerAddress, String clientAddress, BigDecimal bd) {
            this.bd = bd;
            this.producerAddress = producerAddress;
            this.clientAddress = clientAddress;
        }

        @Override
        public void run() {
            JOptionPane.showMessageDialog(null, "notification produced by " + producerAddress +
                " and at destination to " + clientAddress +
                " has been rejected by social filter (strenght: " + bd + ")", "Social Filter",
                    JOptionPane.WARNING_MESSAGE);
        }
    }
}
