/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.eventcloud.mocked.filter;

import com.ebmwebsourcing.eventcloud.mocked.server.AbstractFilter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.swing.JOptionPane;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.proactive.core.component.Fractive;
import org.objectweb.proactive.core.component.representative.PAComponentRepresentative;
import org.soceda.socialfilter.relationshipstrengthengine.RelationshipStrength;
import org.soceda.socialfilter.relationshipstrengthengine.RelationshipStrengthEngineManager;

public class SocialFilter
extends AbstractFilter {
    private static final Logger LOG = Logger.getLogger(SocialFilter.class.getName());
    private RelationshipStrengthEngineManager rsengman = null;
    double threshold = 0.5;

    @Override
    public void init(String socialFilterUri) {
        if (socialFilterUri != null) {
            try {
                PAComponentRepresentative comp = Fractive.lookup((String)socialFilterUri);
                this.rsengman = (RelationshipStrengthEngineManager)comp.getFcInterface("social-filter-services");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            catch (NoSuchInterfaceException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean filter(String clientAddress, String producerAddress, boolean ui) {
        BigDecimal bd;
        boolean res;
        block12: {
            res = false;
            bd = null;
            if (this.rsengman == null) {
                LOG.warning("You must deploy relation graph before using social filter!!!!");
                return true;
            }
            System.out.println("mmmmmmmmmmmmmmmmmm FILTERING BETWEEN " + clientAddress + " AND " + producerAddress);
            LOG.info("mmmmmmmmmmmmmmmmmm FILTERING BETWEEN " + clientAddress + " AND " + producerAddress);
            bd = null;
            try {
                String source_node_id = clientAddress;
                HashSet<String> target_node_ids = new HashSet<String>();
                target_node_ids.add(producerAddress);
                ArrayList rslist = this.rsengman.rank_target_nodes_wrt_relationship_strength(source_node_id, target_node_ids);
                System.out.println("mmmmmmmmmmmmmmmmmm FILTERING LIST " + rslist);
                LOG.info("mmmmmmmmmmmmmmmmmm FILTERING LIST " + rslist);
                if (rslist != null && rslist.size() > 0) {
                    String target_node = ((RelationshipStrength)rslist.get(0)).getTargetNodeId();
                    bd = new BigDecimal(((RelationshipStrength)rslist.get(0)).getStrength());
                    bd = bd.setScale(2, 4);
                    System.out.println("target_node: " + target_node + " - strenght: " + bd.toString());
                    if (bd.doubleValue() == 0.0) {
                        LOG.info("source or target are unknown in social filter");
                        res = true;
                    } else if (bd.doubleValue() >= this.threshold) {
                        res = true;
                    }
                    if (producerAddress.toLowerCase().contains("motorist") && !res) {
                        System.err.println("mmmmmmmmmmmmmmmmmm FILTERING ERROR: motorist must returned true");
                        res = true;
                    }
                    if (producerAddress.toLowerCase().contains("vehicle") && !res) {
                        System.err.println("mmmmmmmmmmmmmmmmmm FILTERING ERROR: vehicle must returned true");
                        res = true;
                    }
                } else {
                    res = true;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                LOG.info("mmmmmmmmmmmmmmmmmm FILTERING PB : " + e.getMessage());
                res = true;
                if (producerAddress.toLowerCase().contains("car")) {
                    System.err.println("mmmmmmmmmmmmmmmmmm FILTERING ERROR: motorist must returned true");
                    res = false;
                }
                if (!producerAddress.toLowerCase().contains("bus")) break block12;
                System.err.println("mmmmmmmmmmmmmmmmmm FILTERING ERROR: vehicle must returned true");
                res = false;
            }
        }
        System.out.println("mmmmmmmmmmmmmmmmmm FILTERING RESULT " + res);
        LOG.info("mmmmmmmmmmmmmmmmmm FILTERING RESULT BETWEEN " + clientAddress + " AND " + producerAddress + " : " + res + " -  value: " + bd);
        if (ui && !res) {
            GUI t = new GUI(producerAddress, clientAddress, bd);
            t.start();
        }
        return res;
    }

    public class GUI
    extends Thread {
        private BigDecimal bd;
        private String producerAddress;
        private String clientAddress;

        public GUI(String producerAddress, String clientAddress, BigDecimal bd) {
            this.bd = bd;
            this.producerAddress = producerAddress;
            this.clientAddress = clientAddress;
        }

        @Override
        public void run() {
            JOptionPane.showMessageDialog(null, "notification produced by " + this.producerAddress + " and at destination to " + this.clientAddress + " has been rejected by social filter (strenght: " + this.bd + ")", "Social Filter", 2);
        }
    }
}

