package com.ebmwebsourcing.seacloud.server;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;

import org.petalslink.easiestdemo.client.topology.EndpointG;
import org.petalslink.easiestdemo.client.topology.EsbG;
import org.petalslink.easiestdemo.client.topology.ExternalClientEndpointG;
import org.petalslink.easiestdemo.client.topology.GovG;

/**
 * The Ball class creates 5 balls.  Each ball increasingly blends
 * the color white with the specified color.
 */
public class LineSeaCloudToEsbG {

	private Line2D line = null;

	protected int size;
	protected Color color;
 
	private EsbG esb;
	private SeaCloudG seaCloud;


	
	public LineSeaCloudToEsbG(SeaCloudG sea, EsbG esb) {
		this.esb = esb;
		this.seaCloud = sea;
		this.color = new Color(255, 174, 185);
		this.line = new Line2D.Double(this.esb.getCenterX(), this.esb.getCenterY(), this.seaCloud.getCenterX(), this.seaCloud.getCenterY());
	}

	public void update(Graphics g) {
		Graphics2D g2 = (Graphics2D) g;
		g2.setStroke(new BasicStroke(10.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND)); // Select the line style to use
		g2.setColor(this.color);
		g2.draw(this.line);
		g2.fill(this.line);
	}

	public boolean contains(int x, int y) {
		return this.line.contains(x, y);
	}

	public void setLocation(int x1, int y1, int x2, int y2) {
		this.line.setLine(x1, y1, x2, y2);
	}
}  

