package com.ebmwebsourcing.seacloud.server;

import java.io.InputStream;
import java.net.URL;

import org.petalslink.abslayer.service.impl.wsdl11.DescriptionImpl;
import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.util.SpecificClasspathURIResolver;
import org.w3c.dom.Document;

import seacloud.petalslink.com.data._1.ResourcesDescriptor;

import com.ebmwebsourcing.easiestdemo.contant.EasiestDEMOFramework;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.xml.resolver.ClasspathURIResolver;
import com.ebmwebsourcing.easycommons.xml.resolver.DefaultURIResolver;
import com.ebmwebsourcing.easycommons.xml.resolver.URIMultipleResolvers;
import com.ebmwebsourcing.seacloud.server.SeaCloud.CEP_MODE;

public class SeaCloudUI extends WSOUIClient {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private SeaCloud server = null;

	private DeployerResult result = null;
	
	private boolean useCepMock = false;
	
	private boolean useEventCloudMock = false;
	
	private boolean create = false;
	
	private CEP_MODE mode;
	
	private String seaCloudAdminAddress;

	static {
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(seacloud.petalslink.com.data._1.ObjectFactory.class, easybox.org.oasis_open.docs.wsn.b_2.ObjectFactory.class);
		} catch (SOAException e) {
			// do nothing
			e.printStackTrace();
		}
	}

	static {
		SOAUtil.getInstance().getXmlContext(EasiestDEMOFramework.getInstance()).setURIResolver(new URIMultipleResolvers(new DefaultURIResolver(), new ClasspathURIResolver(), new SpecificClasspathURIResolver()));
		DescriptionImpl.setXmlContext(SOAUtil.getInstance().getXmlContext(EasiestDEMOFramework.getInstance()));
	}

	public SeaCloudUI() throws WSOUIClientException {
		this(null, null, null, false, true, true);
	}

	public SeaCloudUI(String seaCloudAdminAddress, CEP_MODE mode,
			ResourcesDescriptor descriptor, boolean create, boolean useCepMock, boolean useEventCloudMock) throws WSOUIClientException {
		super();
		try {
			this.getJPanelView().removeAll();
			this.registry = new SeaCloudRegistry();
			this.topology = new SeaCloudTopologyView(this.getJPanelView().getSize(), this);
			this.useCepMock = useCepMock;
			this.useEventCloudMock = useEventCloudMock;
			this.create = create;
			this.seaCloudAdminAddress = seaCloudAdminAddress;
			this.mode = mode;
			this.getJPanelView().add(this.topology);
			if(seaCloudAdminAddress != null) {
//				result = SeaCloudManagementImpl.createRuntimeFrameworkFromDescriptor(seaCloudAdminAddress, mode, descriptor, create, useCepMock, useEventCloudMock, true);
				this.server = result.getSeaCloud();
				try {
					((SeaCloudRegistry)this.registry).setDeployerResult(result);
				} catch (Exception e) {
					// do nothing
				}
			}
		} catch (Exception e) {
			throw new WSOUIClientException(e);
		}

	}



	@Override
	public void refreshAll() throws WSOUIClientException {
		if(this.server != null && this.server.getDescriptors() != null && this.server.getDescriptors().size() > 0) {
			try {
	//			result = SeaCloudManagementImpl.createDeployerResultFromDescriptor(this.server.getDescriptors().get(0), this.create, this.useCepMock, this.useEventCloudMock, true);
				result.setSeaCloud(this.server);
				((SeaCloudRegistry)this.registry).setDeployerResult(result);
			} catch (Exception e) {
				// do nothing
				e.printStackTrace();
			}
		}
		super.refreshAll();
	}

	public SeaCloud getServer() {
		return server;
	}

	public void setServer(SeaCloud server) {
		this.server = server;
	}

	public static ResourcesDescriptor readDescriptor(URL resource) throws Exception {
		ResourcesDescriptor rsc = null;
		InputStream is = resource.openStream();
		Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(is);
		rsc = SOAJAXBContext.getInstance().marshallAnyType(doc, ResourcesDescriptor.class);
		is.close();
		return rsc;
	}



	public static void main(String args[]) {
		java.awt.EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					String seaCloudServerAddress = "http://localhost:8234/SeaCloudAdmin";
					ResourcesDescriptor descriptor = null;//readDescriptor(new File("./src/test/resources/descriptor.xml").toURI().toURL());

					SeaCloudUI c = new SeaCloudUI(seaCloudServerAddress, SeaCloud.CEP_MODE.ESPER, descriptor, false, false, false);					
					c.setVisible(true);
					c.refreshAll();
				} catch (WSOUIClientException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		});
	}

}
