package com.ebmwebsourcing.seacloud.CEPDeployer;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagementException;

import com.ebmwebsourcing.easyevent.impl.client.soap.EventManagerClientImplSOAP;
import com.ebmwebsourcing.seacloud.client.SeaCloudClientSOAP;
import com.ebmwebsourcing.seacloud.model.AbstractModule;
import com.ebmwebsourcing.seacloud.model.CEPModule;
import com.petalslink.events_api._1_0.FindTopicsByElementFault;

import engine.cep.admin.api.Action;
import engine.cep.admin.api.AddStatementResponseWithActions;
import engine.cep.admin.api.AddStatementWithActions;
import engine.cep.admin.api.ListAllStatements;
import engine.cep.admin.api.ListAllStatementsResponse;
import engine.cep.admin.api.Namespace;
import engine.cep.admin.api.SubscriptionsRequired;
import engine.cep.admin.api.SubscriptionsRequired.Entry;

public class CEPEsperDeployerModule extends AbstractModule implements CEPModule {


	private String seaCloudAddress;
	private URL easierGov;
	private EventManagerClientImplSOAP easierGovClient; 

	public CEPEsperDeployerModule(List<URL> adminAdresses, String seaCloudAddress, URL easierGov) throws CloudManagementException {
		super(adminAdresses);
		this.seaCloudAddress = seaCloudAddress;
		this.easierGov = easierGov;
		if(easierGov != null) {
			this.easierGovClient = new EventManagerClientImplSOAP(this.easierGov.toString());
		}
	}

	@Override
	public ListAllStatementsResponse listAllStatements(
			ListAllStatements parameters) throws CloudManagementException {
		URL urlCEP = this.externalComponentAdresses.get(0);
		SeaCloudClientSOAP client = new SeaCloudClientSOAP(urlCEP.toString());
		return client.listAllStatements(parameters);
	}

	@Override
	public String addStatement(String statementId, String statement)
			throws CloudManagementException {
		// TODO Auto-generated method stub
		URL urlCEP = this.externalComponentAdresses.get(0);
		SeaCloudClientSOAP client = new SeaCloudClientSOAP(urlCEP.toString());
		return client.addStatement(statementId, statement);
	}

	@Override
	public String deleteStatement(String statementId)
			throws CloudManagementException {
		// TODO Auto-generated method stub
		// 1.recuperer les id du cloud
		// 2.deploy
		URL urlCEP = this.externalComponentAdresses.get(0);
		SeaCloudClientSOAP client = new SeaCloudClientSOAP(urlCEP.toString());
		return client.deleteStatement(statementId);
	}

	@Override
	public String getStatementById(String statementId)
			throws CloudManagementException {
		URL urlCEP = this.externalComponentAdresses.get(0);
		SeaCloudClientSOAP client = new SeaCloudClientSOAP(urlCEP.toString());
		return client.getStatementById(statementId);
	}

	@Override
	public String updateStatement(String statementId, String statement)
			throws CloudManagementException {
		URL urlCEP = this.externalComponentAdresses.get(0);
		SeaCloudClientSOAP client = new SeaCloudClientSOAP(urlCEP.toString());
		return client.updateStatement(statementId, statement);
	}

	@Override
	public AddStatementResponseWithActions addStatementWithActions(
			AddStatementWithActions parameters) throws CloudManagementException {
		AddStatementResponseWithActions res = null;
		try {
			// 1- find primitifs events used in rules
			System.out.println("1 ************************** findPrimitiveEventsInRule");
			List<QName> primitivesEvent = findPrimitiveEventsInRule(parameters.getStatement(), parameters.getNamespaceOfEventTypes());

			// 2- find corresponding topics from primitifs events
			System.out.println("2 ************************** findCorrespondingTopicsFromPrimitivesEvents");
			Map<QName, QName> topics = findCorrespondingTopicsFromPrimitivesEvents(primitivesEvent);

			// 3- create SubscriptionsRequired
			System.out.println("3 ************************** createSubscriptionsRequired");
			SubscriptionsRequired subscriptionsRequired = createSubscriptionsRequired(topics);
			parameters.setSubscriptionsRequired(subscriptionsRequired);

			// 4- complete actions by adding publishLocation on each complex events to produce
			System.out.println("4 ************************** completeActionsByAddingPublishLocation");
			completeActionsByAddingPublishLocation(parameters.getAction());

			// 5- send request to DiCEPe
			System.out.println("5 ************************** SeaCloudClientSOAP");
			URL urlCEP = this.externalComponentAdresses.get(0);
			SeaCloudClientSOAP client = new SeaCloudClientSOAP(urlCEP.toString());
			res = client.addStatementWithActions(parameters);
		} catch(Exception e) {
			e.printStackTrace();
			throw new CloudManagementException(e.getMessage(), e);
		}
		return res;
	}

	private void completeActionsByAddingPublishLocation(List<Action> actions) throws CloudManagementException {
		for(Action a: actions) {
			if(a.getType().equals("event")) {
				QName topic = findCorrespondingTopicFromElement(a.getName());
				String eventIdCloud = getEventCloudIdURLFromTopic(topic);
				a.getPublishDestination().add(eventIdCloud);
			}
		}
	}

	private String getEventCloudIdURLFromTopic(QName topic) {
		// connect to event cloud manager and get event cloud id
		return this.seaCloudAddress;
	}


	private SubscriptionsRequired createSubscriptionsRequired(Map<QName, QName> topics) {
		SubscriptionsRequired subscriptionsRequired = new SubscriptionsRequired();
		for(java.util.Map.Entry<QName, QName> topic: topics.entrySet()) {
			Entry entry = new Entry();
			entry.setCorrespondingEvent(topic.getKey());
			entry.setTopic(topic.getValue());
			entry.setEndpointAddressToSubscribe(this.seaCloudAddress);
			subscriptionsRequired.getEntry().add(entry);
		}
		return subscriptionsRequired;
	}

	public Map<QName, QName> findCorrespondingTopicsFromPrimitivesEvents(
			List<QName> primitivesEvent) throws CloudManagementException {
		Map<QName, QName> topics = new HashMap<QName, QName>();
		for(QName event: primitivesEvent) {
			QName topic = this.findCorrespondingTopicFromElement(event);
			if(topic != null) {
				topics.put(event, topic);
			}
		}

		return topics;
	}

	public List<QName> findPrimitiveEventsInRule(String rule, List<Namespace> namespaceOfEventTypes) throws CloudManagementException {
		List<QName> primitiveEvents = new ArrayList<QName>();


		if(rule.toLowerCase().contains("from") && rule.toLowerCase().contains("where")) {
			String shortRule = rule.substring(rule.toLowerCase().indexOf("from") + "from".length(), rule.toLowerCase().indexOf("where"));
			String[] events = shortRule.trim().split(",");
			for(String longEvent: events) {
				String event = null;
				if(longEvent.trim().indexOf(".") > 0) {
					event = longEvent.trim().substring(0, longEvent.trim().indexOf("."));
				} else if(longEvent.trim().indexOf(" ") > 0) {
					event = longEvent.trim().substring(0, longEvent.trim().indexOf(""));
				}
				QName eventQName = findEventInNamespace(event, namespaceOfEventTypes);

				if(eventQName == null) {
					throw new CloudManagementException("Impossible to find namespace corresponding to event: " + event);
				}

				if(!primitiveEvents.contains(eventQName)) {
					primitiveEvents.add(eventQName);
				}
			}
		} else if(rule.toLowerCase().contains("from") && rule.toLowerCase().contains("group")) {
			String shortRule = rule.substring(rule.toLowerCase().indexOf("from") + "from".length(), rule.toLowerCase().indexOf("group"));
			System.out.println("shortRule avant = " + shortRule);
			shortRule = shortRule.substring(0, shortRule.indexOf("(")) + shortRule.substring(shortRule.indexOf(")") + 1, shortRule.length());
			System.out.println("shortRule = " + shortRule);
			String[] events = shortRule.trim().split(",");
			for(String longEvent: events) {
				String event = null;
				if(longEvent.trim().indexOf(".") > 0) {
					event = longEvent.trim().substring(0, longEvent.trim().indexOf("."));
				} else if(longEvent.trim().indexOf(" ") > 0) {
					event = longEvent.trim().substring(0, longEvent.trim().indexOf(""));
				}
				QName eventQName = findEventInNamespace(event, namespaceOfEventTypes);

				if(eventQName == null) {
					throw new CloudManagementException("Impossible to find namespace corresponding to event: " + event);
				}

				if(!primitiveEvents.contains(eventQName)) {
					primitiveEvents.add(eventQName);
				}
			}
		}
		return primitiveEvents;
	}

	private QName findEventInNamespace(String event,
			List<Namespace> namespaceOfEventTypes) {
		for(Namespace ns: namespaceOfEventTypes) {
			if(ns.getEventTypeName().equals(event)) {
				return new QName(ns.getNamespace(), ns.getEventTypeName(), ns.getPrefix());
			}
		}
		return null;
	}

	private QName findCorrespondingTopicFromElement(QName name) throws CloudManagementException {
		QName topic = null;
		try {
			List<QName> topics = this.easierGovClient.findTopicsByElement(name);
			if(topics.size() >= 2) {
				throw new CloudManagementException("Too many topics found for element: " + name);
			}
			if(topics.size() > 0) {
				topic = topics.get(0);
			}
		} catch (FindTopicsByElementFault e) {
			throw new CloudManagementException(e.getMessage(), e);
		}
		return topic;
	}


}
