/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.seacloud.client;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.xml.namespace.QName;

import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;

import seacloud.petalslink.com.data._1.AddResourcesDescriptor;
import seacloud.petalslink.com.data._1.AddResourcesDescriptorResponse;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagement;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagementException;

import com.ebmwebsourcing.easycommons.research.util.cxf.CXFHelper;

import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployResponse;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployementReport;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDescriptorType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribeResponse;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbGetResourcePropertyResponse;
import engine.cep.admin.api.AddStatementResponseWithActions;
import engine.cep.admin.api.AddStatementWithActions;
import engine.cep.admin.api.ListAllStatements;
import engine.cep.admin.api.ListAllStatementsResponse;
import esstar.petalslink.com.data.management.user._1.Bind;
import esstar.petalslink.com.data.management.user._1.BindResponse;
import esstar.petalslink.com.data.management.user._1.Proxify;
import esstar.petalslink.com.data.management.user._1.ProxifyResponse;

public class SeaCloudClient implements CloudManagement {

	protected String address = null;


	private CloudManagement clientProxy;


	public SeaCloudClient(String address) {
		this.address = address;
	}


	/**
	 * @return the clientProxy
	 */
	private synchronized CloudManagement getClientProxy() {
		if (clientProxy != null) {
			return clientProxy;
		}
		this.clientProxy = CXFHelper.getClient(address, CloudManagement.class);
		return clientProxy;
	}


	@Override
	public EJaxbSubscribeResponse subscribe(EJaxbSubscribe subscribeRequest)
			throws NotifyMessageNotSupportedFault, InvalidFilterFault,
			InvalidTopicExpressionFault, TopicExpressionDialectUnknownFault,
			UnsupportedPolicyRequestFault, SubscribeCreationFailedFault,
			UnacceptableInitialTerminationTimeFault,
			UnrecognizedPolicyRequestFault, TopicNotSupportedFault,
			InvalidProducerPropertiesExpressionFault, ResourceUnknownFault,
			InvalidMessageContentExpressionFault {
		return this.getClientProxy().subscribe(subscribeRequest);
	}


	@Override
	public EJaxbUnsubscribeResponse unsubscribe(EJaxbUnsubscribe unsubscribeRequest)
			throws UnableToDestroySubscriptionFault, ResourceUnknownFault {
		return this.getClientProxy().unsubscribe(unsubscribeRequest);
	}


	@Override
	public EJaxbGetResourcePropertyResponse getResourceProperty(
			QName getResourcePropertyRequest) throws ResourceUnavailableFault,
			InvalidResourcePropertyQNameFault, ResourceUnknownFault {
		return this.getClientProxy().getResourceProperty(getResourcePropertyRequest);
	}


	@Override
	public EJaxbDeployResponse deploy(
			EJaxbDeploy parameters)
					throws CloudManagementException {
		return this.getClientProxy().deploy(parameters);
	}


	/*
	 * (non-Javadoc)
	 * 
	 * @see org.petalslink.dsb.ws.bpel.client.BPELDeployer#deploy(java.io.File,
	 * java.io.File[])
	 */
	public EJaxbDeployementReport deploy(File descriptorFile, File[] resources) throws CloudManagementException {

		if (descriptorFile == null) {
			throw new CloudManagementException("Descriptor file can not be null");
		}

		System.out.println("descriptorFile = " + descriptorFile);
		System.out.println("descriptorFile.exists() = " + descriptorFile.exists());
		System.out.println("descriptorFile.isFile() = " + descriptorFile.isFile());

		if (!descriptorFile.exists() || !descriptorFile.isFile()) {
			throw new CloudManagementException("Descriptor file " +  descriptorFile.getName() + " does not exists or is not a file");
		}

		EJaxbDescriptorType descriptor = new EJaxbDescriptorType();
		descriptor.setFileURI(descriptorFile.toURI().toString());
		descriptor.setAttachment(new DataHandler(new FileDataSource(descriptorFile)));

		List<EJaxbDescriptorType> list = new ArrayList<EJaxbDescriptorType>();
		if (resources != null) {
			for (File file : resources) {
				if (file != null && file.exists() && file.isFile()) {
					EJaxbDescriptorType resource = new EJaxbDescriptorType();
					resource.setFileURI(file.toURI().toString());
					resource.setAttachment(new DataHandler(new FileDataSource(file)));
					list.add(resource);
				} else {
					// warning
				}
			}
		}
		EJaxbDeploy request = new EJaxbDeploy();
		request.setMainResource(descriptor);
		request.getResources().addAll(list);
		EJaxbDeployResponse response = deploy(request);
		return response.getDeployementReport();
	}


	@Override
	public void notify(EJaxbNotify notify) {
		this.getClientProxy().notify(notify);
	}


	@Override
	public BindResponse bind(Bind parameters) throws CloudManagementException {
		return this.getClientProxy().bind(parameters);
	}


	@Override
	public String expose(QName serviceName, String endpointName)
			throws CloudManagementException {
		return this.getClientProxy().expose(serviceName, endpointName);
	}


	@Override
	public ProxifyResponse proxify(Proxify parameters)
			throws CloudManagementException {
		return this.getClientProxy().proxify(parameters);
	}


	@Override
	public AddResourcesDescriptorResponse addResourcesDescriptor(
			AddResourcesDescriptor parameters) throws CloudManagementException {
		return this.getClientProxy().addResourcesDescriptor(parameters);
	}


	@Override
	public String updateStatement(String statementId, String statement)
			throws CloudManagementException {
		return this.getClientProxy().updateStatement(statementId, statement);
	}


	@Override
	public String getStatementById(String statementId)
			throws CloudManagementException {
		return this.getClientProxy().getStatementById(statementId);
	}


	@Override
	public String deleteStatement(String statementId)
			throws CloudManagementException {
		return this.getClientProxy().deleteStatement(statementId);
	}


	@Override
	public String addStatement(String statementId, String statement)
			throws CloudManagementException {
		return this.getClientProxy().addStatement(statementId, statement);
	}


	@Override
	public ListAllStatementsResponse listAllStatements(
			ListAllStatements parameters) throws CloudManagementException {
		return this.getClientProxy().listAllStatements(parameters);
	}


	@Override
	public AddStatementResponseWithActions addStatementWithActions(
			AddStatementWithActions parameters) throws CloudManagementException {
		return this.getClientProxy().addStatementWithActions(parameters);
	}


	@Override
	public void addResourcesDescriptorFromURL(String descriptorURL,
			boolean eraseOlders) throws CloudManagementException {
		this.getClientProxy().addResourcesDescriptorFromURL(descriptorURL, eraseOlders);
	}


	@Override
	public String ping() {
		return this.getClientProxy().ping();
	}


	public String getAddress() {
		return address;
	}




}
