/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.seacloud.client;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;

import org.jdom.JDOMException;
import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import seacloud.petalslink.com.data._1.AddResourcesDescriptor;
import seacloud.petalslink.com.data._1.AddResourcesDescriptorFromURL;
import seacloud.petalslink.com.data._1.AddResourcesDescriptorFromURLResponse;
import seacloud.petalslink.com.data._1.AddResourcesDescriptorResponse;
import seacloud.petalslink.com.data._1.Ping;
import seacloud.petalslink.com.data._1.PingResponse;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagement;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagementException;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;

import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployResponse;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployementReport;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDescriptorType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribeResponse;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbGetResourcePropertyResponse;
import engine.cep.admin.api.AddStatement;
import engine.cep.admin.api.AddStatementResponse;
import engine.cep.admin.api.AddStatementResponseWithActions;
import engine.cep.admin.api.AddStatementWithActions;
import engine.cep.admin.api.DeleteStatement;
import engine.cep.admin.api.DeleteStatementResponse;
import engine.cep.admin.api.GetStatementById;
import engine.cep.admin.api.GetStatementByIdResponse;
import engine.cep.admin.api.ListAllStatements;
import engine.cep.admin.api.ListAllStatementsResponse;
import engine.cep.admin.api.UpdateStatement;
import engine.cep.admin.api.UpdateStatementResponse;
import esstar.petalslink.com.data.management.user._1.Bind;
import esstar.petalslink.com.data.management.user._1.BindResponse;
import esstar.petalslink.com.data.management.user._1.Expose;
import esstar.petalslink.com.data.management.user._1.ExposeResponse;
import esstar.petalslink.com.data.management.user._1.Proxify;
import esstar.petalslink.com.data.management.user._1.ProxifyResponse;

public class SeaCloudClientSOAP implements CloudManagement {

	protected String address = null;

	private SOAPSender soapSender;


	static{
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(seacloud.petalslink.com.data._1.ObjectFactory.class,
					easybox.org.oasis_open.docs.wsn.b_2.ObjectFactory.class,
					easybox.org.oasis_open.docs.wsrf.rp_2.ObjectFactory.class,
					engine.cep.admin.api.ObjectFactory.class);
		} catch (SOAException e) {
			// do nothing
			e.printStackTrace();
		}
	}

	private static easybox.esstar.petalslink.com.management.model.datatype._1.ObjectFactory objectFactory = new easybox.esstar.petalslink.com.management.model.datatype._1.ObjectFactory();
	private static easybox.org.oasis_open.docs.wsn.b_2.ObjectFactory wsstarFactory = new easybox.org.oasis_open.docs.wsn.b_2.ObjectFactory();
	private static easybox.org.oasis_open.docs.wsrf.rp_2.ObjectFactory rscFactory = new easybox.org.oasis_open.docs.wsrf.rp_2.ObjectFactory();


	public SeaCloudClientSOAP(String address) {
		this.address = address;
		soapSender = new SOAPSender();
	}



	@Override
	public EJaxbSubscribeResponse subscribe(EJaxbSubscribe subscribeRequest)
			throws NotifyMessageNotSupportedFault, InvalidFilterFault,
			InvalidTopicExpressionFault, TopicExpressionDialectUnknownFault,
			UnsupportedPolicyRequestFault, SubscribeCreationFailedFault,
			UnacceptableInitialTerminationTimeFault,
			UnrecognizedPolicyRequestFault, TopicNotSupportedFault,
			InvalidProducerPropertiesExpressionFault, ResourceUnknownFault,
			InvalidMessageContentExpressionFault {
		EJaxbSubscribeResponse res = new EJaxbSubscribeResponse();
		try{
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(subscribeRequest));

			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/subscribe");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					TopicNotSupportedFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, TopicNotSupportedFault.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new TopicNotSupportedFault("Business Fault", fault);
				} else {
					throw new TopicNotSupportedFault("Technical Fault: \n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbSubscribeResponse.class);
		} catch (Exception e) {
			throw new TopicNotSupportedFault("Technical Fault", e);
		} 

		return res;
	}
	
	public EJaxbSubscribeResponse subscribe(Document subscribeRequest)
			throws NotifyMessageNotSupportedFault, InvalidFilterFault,
			InvalidTopicExpressionFault, TopicExpressionDialectUnknownFault,
			UnsupportedPolicyRequestFault, SubscribeCreationFailedFault,
			UnacceptableInitialTerminationTimeFault,
			UnrecognizedPolicyRequestFault, TopicNotSupportedFault,
			InvalidProducerPropertiesExpressionFault, ResourceUnknownFault,
			InvalidMessageContentExpressionFault {
		EJaxbSubscribeResponse res = new EJaxbSubscribeResponse();
		try{
			Document soapRequest = SOAPSender.createSOAPMessageRequest(subscribeRequest);

			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/subscribe");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					TopicNotSupportedFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, TopicNotSupportedFault.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new TopicNotSupportedFault("Business Fault", fault);
				} else {
					throw new TopicNotSupportedFault("Technical Fault: \n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbSubscribeResponse.class);
		} catch (Exception e) {
			throw new TopicNotSupportedFault("Technical Fault", e);
		} 

		return res;
	}


	@Override
	public EJaxbUnsubscribeResponse unsubscribe(EJaxbUnsubscribe unsubscribeRequest)
			throws UnableToDestroySubscriptionFault, ResourceUnknownFault {
		EJaxbUnsubscribeResponse res = new EJaxbUnsubscribeResponse();
		try{


			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(unsubscribeRequest));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/unSubscribe");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					ResourceUnknownFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, ResourceUnknownFault.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new ResourceUnknownFault("Business Fault", fault);
				} else {
					throw new TopicNotSupportedFault("Technical Fault: \n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbUnsubscribeResponse.class);
		} catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);
		} 

		return res;
	}


	@Override
	public EJaxbGetResourcePropertyResponse getResourceProperty(
			QName getResourcePropertyRequest) throws ResourceUnavailableFault,
			InvalidResourcePropertyQNameFault, ResourceUnknownFault {
		EJaxbGetResourcePropertyResponse res = new EJaxbGetResourcePropertyResponse();
		try{
			Document payload = SOAJAXBContext.getInstance().unmarshallAnyElement(rscFactory.createGetResourceProperty(getResourcePropertyRequest));

			Node root = payload.createElementNS(getResourcePropertyRequest.getNamespaceURI(), getResourcePropertyRequest.getLocalPart());
			payload.adoptNode(root);

			Document soapRequest = SOAPSender.createSOAPMessageRequest(payload);
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/getResourceProperty");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					ResourceUnknownFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, ResourceUnknownFault.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new ResourceUnknownFault("Business Fault", fault);
				} else {
					throw new TopicNotSupportedFault("Technical Fault: \n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			// get GetResourcePropertyResponse
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbGetResourcePropertyResponse.class);
		} catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);
		} 

		return res;
	}


	@Override
	public EJaxbDeployResponse deploy(
			EJaxbDeploy parameters)
					throws CloudManagementException {
		EJaxbDeployResponse res = new EJaxbDeployResponse();
		try{


			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/deploy");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					CloudManagementException fault = SOAJAXBContext.getInstance().marshallAnyType(doc, CloudManagementException.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new CloudManagementException("Business Fault", fault);
				} else {
					throw new CloudManagementException("Technical Fault: \n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbDeployResponse.class);
		} catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);
		} 

		return res;
	}


	/*
	 * (non-Javadoc)
	 * 
	 * @see org.petalslink.dsb.ws.bpel.client.BPELDeployer#deploy(java.io.File,
	 * java.io.File[])
	 */
	public EJaxbDeployementReport deploy(File descriptorFile, File[] resources) throws CloudManagementException {

		if (descriptorFile == null) {
			throw new CloudManagementException("Descriptor file can not be null");
		}

		System.out.println("descriptorFile = " + descriptorFile);
		System.out.println("descriptorFile.exists() = " + descriptorFile.exists());
		System.out.println("descriptorFile.isFile() = " + descriptorFile.isFile());

		if (!descriptorFile.exists() || !descriptorFile.isFile()) {
			throw new CloudManagementException("Descriptor file " +  descriptorFile.getName() + " does not exists or is not a file");
		}

		EJaxbDescriptorType descriptor = new EJaxbDescriptorType();
		descriptor.setFileURI(descriptorFile.toURI().toString());
		descriptor.setAttachment(new DataHandler(new FileDataSource(descriptorFile)));

		List<EJaxbDescriptorType> list = new ArrayList<EJaxbDescriptorType>();
		if (resources != null) {
			for (File file : resources) {
				if (file != null && file.exists() && file.isFile()) {
					EJaxbDescriptorType resource = new EJaxbDescriptorType();
					resource.setFileURI(file.toURI().toString());
					resource.setAttachment(new DataHandler(new FileDataSource(file)));
					list.add(resource);
				} else {
					// warning
				}
			}
		}
		EJaxbDeploy request = new EJaxbDeploy();
		request.setMainResource(descriptor);
		request.getResources().addAll(list);
		EJaxbDeployResponse response = deploy(request);
		return response.getDeployementReport();
	}


	@Override
	public void notify(EJaxbNotify notify) {
		try {
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(notify));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/notify");
			if(soapResponse != null && SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					SOAPException fault = SOAJAXBContext.getInstance().marshallAnyType(doc, SOAPException.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
				} 
			}

		} catch (JDOMException e) {
			e.printStackTrace();
		} catch (SOAException e) {
			e.printStackTrace();
		} catch (SOAPException e) {
			e.printStackTrace();
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		}
	}

	
	public void notify(Document notify) {
		try {
			Document soapRequest = SOAPSender.createSOAPMessageRequest(notify);
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/notify");
			if(soapResponse != null && SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					SOAPException fault = SOAJAXBContext.getInstance().marshallAnyType(doc, SOAPException.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
				} 
			}

		} catch (JDOMException e) {
			e.printStackTrace();
		} catch (SOAException e) {
			e.printStackTrace();
		} catch (SOAPException e) {
			e.printStackTrace();
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		}
	}


	@Override
	public BindResponse bind(Bind parameters) throws CloudManagementException {
		BindResponse res = new BindResponse();

		try{

			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.esstar/service/admin/1.0/bind");

			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					CloudManagementException fault = SOAJAXBContext.getInstance().marshallAnyType(doc, CloudManagementException.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new CloudManagementException("Business Fault", fault);
				} else {
					throw new CloudManagementException("Technical Fault:\n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, BindResponse.class);



		}catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);
		}
		return res;
	}


	@Override
	public String expose(QName serviceName, String endpointName)
			throws CloudManagementException {
		String res = "";

		try{
			Expose request = new Expose();
			request.setServiceName(serviceName);
			request.setEndpointName(endpointName);


			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(request));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.esstar/service/admin/1.0/expose");

			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				CloudManagementException fault = SOAJAXBContext.getInstance().marshallAnyType(doc, CloudManagementException.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStackTrace());
				throw new CloudManagementException("Business Fault", fault);

			}

			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			ExposeResponse exposeResponse = SOAJAXBContext.getInstance().marshallAnyType(doc, ExposeResponse.class);
			res = exposeResponse.getExternalAddress();


		}catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);
		}
		return res;
	}


	@Override
	public ProxifyResponse proxify(Proxify parameters)
			throws CloudManagementException {
		ProxifyResponse res = new ProxifyResponse();

		try{

			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.esstar/service/admin/1.0/proxify");

			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				CloudManagementException fault = SOAJAXBContext.getInstance().marshallAnyType(doc, CloudManagementException.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStackTrace());
				throw new CloudManagementException("Business Fault", fault);

			}

			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, ProxifyResponse.class);


		}catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);

		}
		return res;
	}


	@Override
	public AddResourcesDescriptorResponse addResourcesDescriptor(
			AddResourcesDescriptor parameters) throws CloudManagementException {
		AddResourcesDescriptorResponse res = new AddResourcesDescriptorResponse();

		try{

			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.seacloud/service/management/cloud/1.0/AddResourcesDescriptor");

			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				CloudManagementException fault = SOAJAXBContext.getInstance().marshallAnyType(doc, CloudManagementException.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStackTrace());
				throw new CloudManagementException("Business Fault", fault);

			}

			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, AddResourcesDescriptorResponse.class);


		}catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);

		}
		return res;
	}



	@Override
	public String updateStatement(String statementId, String statement)
			throws CloudManagementException {
		UpdateStatementResponse res = new UpdateStatementResponse();

		try{
			UpdateStatement parameters = new UpdateStatement();
			parameters.setStatementId(statementId);
			parameters.setStatement(statement);
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.seacloud/service/management/cloud/1.0/updateStatement");

			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				CloudManagementException fault = SOAJAXBContext.getInstance().marshallAnyType(doc, CloudManagementException.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStackTrace());
				throw new CloudManagementException("Business Fault", fault);

			}

			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, UpdateStatementResponse.class);


		}catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);

		}
		return res.getResponse();
	}



	@Override
	public String getStatementById(String statementId)
			throws CloudManagementException {
		GetStatementByIdResponse res = new GetStatementByIdResponse();

		try{
			GetStatementById parameters = new GetStatementById();
			parameters.setStatementId(statementId);
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.seacloud/service/management/cloud/1.0/getStatementById");

			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				CloudManagementException fault = SOAJAXBContext.getInstance().marshallAnyType(doc, CloudManagementException.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStackTrace());
				throw new CloudManagementException("Business Fault", fault);

			}

			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, GetStatementByIdResponse.class);


		}catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);

		}
		return res.getOut();
	}



	@Override
	public String deleteStatement(String statementId)
			throws CloudManagementException {
		DeleteStatementResponse res = new DeleteStatementResponse();

		try{
			DeleteStatement parameters = new DeleteStatement();
			parameters.setStatementId(statementId);
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.seacloud/service/management/cloud/1.0/deleteStatement");

			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				CloudManagementException fault = SOAJAXBContext.getInstance().marshallAnyType(doc, CloudManagementException.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStackTrace());
				throw new CloudManagementException("Business Fault", fault);

			}

			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, DeleteStatementResponse.class);


		}catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);

		}
		return res.getResponse();
	}



	@Override
	public String addStatement(String statementId, String statement)
			throws CloudManagementException {
		AddStatementResponse res = new AddStatementResponse();

		try{
			AddStatement parameters = new AddStatement();
			parameters.setStatementId(statementId);
			parameters.setStatement(statement);
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.seacloud/service/management/cloud/1.0/addStatement");

			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				CloudManagementException fault = SOAJAXBContext.getInstance().marshallAnyType(doc, CloudManagementException.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStackTrace());
				throw new CloudManagementException("Business Fault", fault);

			}

			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, AddStatementResponse.class);


		}catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);

		}
		return res.getResponse();
	}



	@Override
	public ListAllStatementsResponse listAllStatements(
			ListAllStatements parameters) throws CloudManagementException {
		ListAllStatementsResponse res = new ListAllStatementsResponse();

		try{
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.seacloud/service/management/cloud/1.0/listAllStatements");

			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				CloudManagementException fault = SOAJAXBContext.getInstance().marshallAnyType(doc, CloudManagementException.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStackTrace());
				throw new CloudManagementException("Business Fault", fault);

			}

			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, ListAllStatementsResponse.class);


		}catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);

		}
		return res;
	}



	@Override
	public AddStatementResponseWithActions addStatementWithActions(
			AddStatementWithActions parameters) throws CloudManagementException {
		AddStatementResponseWithActions res = new AddStatementResponseWithActions();

		try {
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));

			System.out.println("Send SOAP request to: " + address);
			System.out.println("SOAP request sent:\n" + XMLPrettyPrinter.prettyPrint(soapRequest));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.seacloud/service/management/cloud/1.0/addStatementWithActions");

			if(SOAPHandler.isSoapFault(soapResponse)) {
				System.out.println("SOAP Fault sent:\n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				if(SOAPHandler.getFaultDetails(soapResponse) != null && SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					CloudManagementException fault = SOAJAXBContext.getInstance().marshallAnyType(doc, CloudManagementException.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new CloudManagementException("Business Fault", fault);
				} else {
					throw new CloudManagementException("Technical Fault: " + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, AddStatementResponseWithActions.class);
		} catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);

		}
		return res;
	}



	@Override
	public void addResourcesDescriptorFromURL(String descriptorURL,
			boolean eraseOlders) throws CloudManagementException {
		try {
			AddResourcesDescriptorFromURL payload = new AddResourcesDescriptorFromURL();
			payload.setDescriptorURL(descriptorURL);
			payload.setEraseOlders(eraseOlders);
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));

			System.out.println("Send SOAP request to: " + address);
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.seacloud/service/management/cloud/1.0/AddResourcesDescriptorFromURL");

			if(SOAPHandler.isSoapFault(soapResponse)) {
				System.out.println("SOAP Fault sent:\n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				if(SOAPHandler.getFaultDetails(soapResponse) != null && SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					CloudManagementException fault = SOAJAXBContext.getInstance().marshallAnyType(doc, CloudManagementException.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new CloudManagementException("Business Fault", fault);
				} else {
					throw new CloudManagementException("Technical Fault: " + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

		} catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);

		}
	}



	@Override
	public String ping() {
		PingResponse res = new PingResponse();

		try {
			
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(new Ping()));

			System.out.println("Send SOAP request to: " + address);
			System.out.println("SOAP request sent:\n" + XMLPrettyPrinter.prettyPrint(soapRequest));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.seacloud/service/management/cloud/1.0/ping");

			if(SOAPHandler.isSoapFault(soapResponse)) {
				System.out.println("SOAP Fault sent:\n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				if(SOAPHandler.getFaultDetails(soapResponse) != null && SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					CloudManagementException fault = SOAJAXBContext.getInstance().marshallAnyType(doc, CloudManagementException.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new CloudManagementException("Business Fault", fault);
				} else {
					throw new CloudManagementException("Technical Fault: " + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, PingResponse.class);
		} catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);

		}
		return res.getOut();
	}


	public String getAddress() {
		return address;
	}




}
