// SOCEDA integration
// ---------
// -- DSB --
// ---------

importPackage(java.lang);
importPackage(java.util);
importPackage(java.io);

var elaComponentKey = "ela";
var elaConfigFilename = "ela.config.properties";

function runELA() {
	// Perform several checks and run the installation if required

	println("Checking ELA ALERT Service installation ... ");

	// Check if already installed
	var elaDir = new File(instDir, elaComponentKey);
	if (!elaDir.exists() || elaDir.listFiles().length == 0) {
		println("ELA Alert Service not found, trying to install ...");
		elaDir.mkdir();

		// Check if the installer is in origin
		var elaInstallerFile = new File(originDir, findInstallerNameOfComponent(elaComponentKey));
		if (!elaInstallerFile.exists()) {
			
			// Try do download it from the web
			var componentUrl = findDownloadComponentURL(elaComponentKey);
			println("Trying to download the ELA Alert Service installer from " + componentUrl);
			println("Please wait ...");
			try {
				downloadFromHttp(componentUrl, elaInstallerFile);
			} catch (e) {
				println("Unable to download the ELA Alert Service installer due to " + e.javaException);
			}
			if (!elaInstallerFile.exists()) {
				throw "Unable to find " + elaInstallerFile + " please download "
				+ elaInstallerFile.getName() + " and put it in "
				+ originDir.getAbsolutePath();	
			}						
		}

		// Extract WS binaries from the installer package
		try {
			extractFolder(elaInstallerFile, elaDir);
		} catch (e) {
			println("Unable to extract ELA Alert Service binaries " + e.javaStackTrace);
		}
		
		if (elaDir.listFiles().length == 0) {
			throw "Unable to extract ELA Alert Service please extract " + sccliInstallerFile + " manually into " + elaDir;
		}
		
		println("Installation successfull ...");
	}

	var binDir = new File(elaDir, "bin");
	
	// Copy config file
	var srcFile = new File(configDir, elaConfigFilename);
	var dstFile = new File(binDir, "config.properties");
	try {
		println("Copying " + srcFile + " into " + dstFile.getParent());		
		copyFile(srcFile, dstFile);
	} catch (e) {
		println("!! Unable to copy " + srcFile + " config file due to " + e);
		if (e.javaStackTrace != undefined) {
			println("!! javaStackTrace: " +  e.javaStackTrace);
		}
	}
	
	
	var logSrcFile = new File(configDir, "logger.properties");
	var logDstFile = new File(binDir, "logger.properties");
	try {
		println("Copying " + logSrcFile + " into " + logDstFile.getParent());		
		copyFile(logSrcFile, logDstFile);
	} catch (e) {
		println("!! Unable to copy " + logSrcFile + " logger file due to " + e);
		if (e.javaStackTrace != undefined) {
			println("!! javaStackTrace: " +  e.javaStackTrace);
		}
	}
	
	deleteLockedFile(binDir);
	
	// Running ela from bin dir
	// java %JAVA_OPTS% %DEBUG_OPTS% -jar xxxx.jar start
	var cmd = [ javaExe ];
	var javaOpts = System.getenv("JAVA_OPTS");
	if (javaOpts != null) {
		cmd.push(javaOpts);
	}
	var debugOpts = System.getenv("DEBUG_OPTS");
	if (debugOpts != null) {
		cmd.push(debugOpts);
	}
	cmd.push('-jar', 'server.jar', 'start');
	return execCmdNewTermAsync("ELA Alert Service", cmd, binDir);
}