// SOCEDA integration
// ------------
// -- DiCEPE --
// ------------

// TODO: ADD DOWNLOAD OF INSTALLER
// TODO: ADD CONSOLE MODE INSTALL
// TODO: ADD REMOTE INSTALL
importPackage(java.lang);
importPackage(java.util);
importPackage(java.io);

var dicepeInstallerName = "cep-light-server-1.0-SNAPSHOT.zip";

function runDiCEPE() {
	println("Checking DiCEPE installation ... ");

	// Check if already installed
	var dicepeDir = new File(instDir, "dicepe");
	if (!dicepeDir.exists() || dicepeDir.listFiles().length == 0) {
		println("DiCEPE not found, trying to install ...");
		dicepeDir.mkdir();

		// Check if the installer is in origin
		var dicepeInstallerFile = new File(originDir, dicepeInstallerName);
		if (!dicepeInstallerFile.exists()) {
//			
//			// Try do download it from the web
//			println("Trying to download the WS installer from " + wsInstallerUrl);
//			println("Please wait ...");
//			try {
//				downloadFromHttp(wsInstallerUrl, wsInstallerFile);
//			} catch (e) {
//				println("Unable to download the WS installer " + e.javaStackTrace);
//			}
//			
			if (!dicepeInstallerFile.exists()) {
				throw "Unable to find " + dicepeInstallerFile + " please download "
				+ dicepeInstallerFile.getName() + " and put it in "
				+ originDir.getAbsolutePath();
			}
		}

		// Extract DiCEPE binaries from the installer package
		try {
			extractFolder(dicepeInstallerFile, dicepeDir);
		} catch (e) {
			println("Unable to extract DiCEPE binaries " + e.javaStackTrace);
		}
		
		if (dicepeDir.listFiles().length == 0) {
			throw "Unable to extract DiCEPE please extract " + dicepeInstallerFile + " manually into " + dicepeDir;
		}
		
		println("Installation successfull ...");
	}
	
	var binDir = new File(dicepeDir, "bin");
	var lockedFile = new File(binDir, "locked");
	
	// Check for locked file in bin dir
	if  (lockedFile.exists()) {
		lockedFile['delete']();
	}

	// Running sc from bin dir
	// java %JAVA_OPTS% %DEBUG_OPTS% -jar xxxx.jar start
	var cmd = [ javaExe ];
	var javaOpts = System.getenv("JAVA_OPTS");
	if (javaOpts != null) {
		cmd.push(javaOpts);
	}
	var debugOpts = System.getenv("DEBUG_OPTS");
	if (debugOpts != null) {
		cmd.push(debugOpts);
	}
	cmd.push('-jar', 'server-soceda.jar', 'start');
	return execCmdNewTermAsync("DiCEPE", cmd, binDir, dicepeMachine);
}