// SOCEDA integration
// ---------
// -- DSB --
// ---------

importPackage(java.lang);
importPackage(java.util);
importPackage(java.io);

var evalComponentKey = "eval";
var evalConfigFilename = "eval.config.properties";

function runEval() {
	// Perform several checks and run the installation if required

	println("Checking Eval installation ... ");

	// Check if already installed
	var evalDir = new File(instDir, evalComponentKey);
	if (!evalDir.exists() || evalDir.listFiles().length == 0) {
		println("Eval not found, trying to install ...");
		evalDir.mkdir();

		// Check if the installer is in origin
		var evalInstallerFile = new File(originDir, findInstallerNameOfComponent(evalComponentKey));
		if (!evalInstallerFile.exists()) {
			
			// Try do download it from the web
			var componentUrl = findDownloadComponentURL(evalComponentKey);
			println("Trying to download the Eval  installer Evalm " + componentUrl);
			println("Please wait ...");
			try {
				downloadFromHttp(componentUrl, evalInstallerFile);
			} catch (e) {
				println("Unable to download the Eval installer due to " + e.javaException);
			}
			if (!evalInstallerFile.exists()) {
				throw "Unable to find " + evalInstallerFile + " please download "
				+ evalInstallerFile.getName() + " and put it in "
				+ originDir.getAbsolutePath();	
			}						
		}

		// Extract WS binaries from the installer package
		try {
			extractFolder(evalInstallerFile, evalDir);
		} catch (e) {
			println("Unable to extract Eval  binaries " + e.javaStackTrace);
		}
		
		if (evalDir.listFiles().length == 0) {
			throw "Unable to extract Eval  please extract " + sccliInstallerFile + " manually into " + evalDir;
		}
		
		println("Installation successfull ...");
	}

	var binDir = new File(evalDir, "bin");
	
	// Copy config file
	var srcFile = new File(configDir, evalConfigFilename);
	var dstFile = new File(binDir, "config.properties");
	try {
		println("Copying " + srcFile + " into " + dstFile.getParent());		
		copyFile(srcFile, dstFile);
	} catch (e) {
		println("!! Unable to copy " + srcFile + " config file due to " + e);
		if (e.javaStackTrace != undefined) {
			println("!! javaStackTrace: " +  e.javaStackTrace);
		}
	}
	
	
	var logSrcFile = new File(configDir, "logger.properties");
	var logDstFile = new File(binDir, "logger.properties");
	try {
		println("Copying " + logSrcFile + " into " + logDstFile.getParent());		
		copyFile(logSrcFile, logDstFile);
	} catch (e) {
		println("!! Unable to copy " + logSrcFile + " logger file due to " + e);
		if (e.javaStackTrace != undefined) {
			println("!! javaStackTrace: " +  e.javaStackTrace);
		}
	}
	
	deleteLockedFile(binDir);
	
	// Running eval from bin dir
	// java %JAVA_OPTS% %DEBUG_OPTS% -jar xxxx.jar start
	var cmd = [ javaExe ];
	var javaOpts = System.getenv("JAVA_OPTS");
	if (javaOpts != null) {
		cmd.push(javaOpts);
	}
	var debugOpts = System.getenv("DEBUG_OPTS");
	if (debugOpts != null) {
		cmd.push(debugOpts);
	}
	cmd.push('-jar', 'server.jar', 'start');
	return execCmdNewTermAsync("Eval", cmd, binDir);
}