// SOCEDA integration
// --------------
// -- SeaCloud --
// --------------

// TODO: ADD DOWNLOAD OF INSTALLER
// TODO: ADD CONSOLE MODE INSTALL
// TODO: ADD REMOTE INSTALL
importPackage(java.lang);
importPackage(java.util);
importPackage(java.io);

var scInstallerName = "admin-ui-1.0-SNAPSHOT.zip";

function runSC() {
	println("Checking SeaCloud installation ... ");

	// Check if already installed
	var scDir = new File(instDir, "sc");
	if (!scDir.exists() || scDir.listFiles().length == 0) {
		println("SeaCloud not found, trying to install ...");
		scDir.mkdir();

		// Check if the installer is in origin
		var scInstallerFile = new File(originDir, scInstallerName);
		if (!scInstallerFile.exists()) {
//			
//			// Try do download it from the web
//			println("Trying to download the WS installer from " + wsInstallerUrl);
//			println("Please wait ...");
//			try {
//				downloadFromHttp(wsInstallerUrl, wsInstallerFile);
//			} catch (e) {
//				println("Unable to download the WS installer " + e.javaStackTrace);
//			}
//			
			if (!scInstallerFile.exists()) {
				throw "Unable to find " + scInstallerFile + " please download "
				+ scInstallerFile.getName() + " and put it in "
				+ originDir.getAbsolutePath();
			}
		}

		// Extract WS binaries from the installer package
		try {
			extractFolder(scInstallerFile, scDir);
		} catch (e) {
			println("Unable to extract SeaCloud binaries " + e.javaStackTrace);
		}
		
		if (scDir.listFiles().length == 0) {
			throw "Unable to extract SeaCloud please extract " + scInstallerFile + " manually into " + scDir;
		}
		
		println("Installation successfull ...");
	}
	
	var binDir = new File(scDir, "bin");
	var lockedFile = new File(binDir, "locked");
	
	// Check for locked file in bin dir
	if  (lockedFile.exists()) {
		lockedFile['delete']();
	}

	// Running sc from bin dir
	// java %JAVA_OPTS% %DEBUG_OPTS% -jar xxxx.jar start
	var cmd = [ javaExe ];
	var javaOpts = System.getenv("JAVA_OPTS");
	if (javaOpts != null) {
		cmd.push(javaOpts);
	}
	var debugOpts = System.getenv("DEBUG_OPTS");
	if (debugOpts != null) {
		cmd.push(debugOpts);
	}
	cmd.push('-jar', 'server-soceda.jar', 'start', '; sleep', '86400');
	return execCmdNewTermAsync("SeaCloud", cmd, binDir, scMachine);
}