// SOCEDA integration
// ---------------
// -- EasierGOV --
// ---------------

// TODO: ADD DOWNLOAD OF INSTALLER
importPackage(java.lang);
importPackage(java.util);
importPackage(java.io);

var ceped = "ceped";
var tomcat = "tomcat";

function runCEPEditor() {
	println("Checking CEP Editor installation ... ");

	// Check if already installed
	var cepedDir = new File(instDir, ceped);
	var tomcatDir = new File(instDir, tomcat);
	if (!cepedDir.exists() || cepedDir.listFiles().length == 0) {
		println("CEP Editor not found, trying to install ...");
		cepedDir.mkdir();

		// Check if the installer is in origin
		var cepedInstallerFile = new File(originDir, findInstallerNameOfComponent(ceped));
		if (!cepedInstallerFile.exists()) {
			
			// Try do download it from the web
			var componentUrl = findDownloadComponentURL(ceped);
			println("Trying to download the CEP Editor installer from " + componentUrl);
			println("Please wait ...");
			try {
				downloadFromHttp(componentUrl, cepedInstallerFile);
			} catch (e) {
				println("Unable to download the CEP Editor installer due to " + e.javaException);
			}
			
			if (!cepedInstallerFile.exists()) {
				throw "Unable to find " + cepedInstallerFile + " please download "
				+ tomcatInstallerFile.getName() + " and put it in "
				+ originDir.getAbsolutePath();
			}
		}

		// move war to tomcat
		try {
			println("copy file " + cepedInstallerFile + " to " + tomcatDir + "/webapps/" + findInstallerNameOfComponent(ceped));
			copyFile(cepedInstallerFile, new File(tomcatDir, "/webapps/" + findInstallerNameOfComponent(ceped)));
		} catch (e) {
			println("Unable to extract Tomcat binaries " + e.javaStackTrace);
		}
		
		if (tomcatDir.listFiles().length == 0) {
			throw "Unable to extract Tomcat please extract " + tomcatInstallerFile + " manually into " + tomcatDir;
		}
		
		println("CEP Editor Installation successfull ...");
	}
	
//	var apacheTomcatDir = new File(tomcatDir);
//	if (!apacheTomcatDir.exists()) {
//		throw "Unable to find " + apacheTomcatDir + " please be sure to have the correct Tomcat archive in " + tomcatDir;
//	}
//	var binDir = new File(apacheTomcatDir, "bin");	
//	var startupFile = new File(binDir, "startup"+ (isWindows ? ".bat" : ".sh"));	
//	var cmd = [ startupFile.getAbsolutePath() ];	
//	var tomcatProcess = execCmdNewTermAsync("Apache Tomcat", cmd, binDir);
		
//	var port = 8080;	
//	while (isPortAvailable(port)) {
//		println("Waiting for apache tomcat before opening the Tomcat web page ...");
//		java.lang.Thread.sleep(1000);
//	}
//		
//	// Start a new 
//	execCmdNewTermAsync("CEP Editor web page", ["http://localhost:"+port+"/SCPortal.html"], binDir);
//	
//	// TODO: Find a way to kill tomcat
//	return tomcatProcess;
}