// SOCEDA integration
// ---------
// -- DSB --
// ---------

// TODO: EasyESB (Later replace with DSB)
// TODO: ADD DOWNLOAD OF INSTALLER
// TODO: ADD REMOTE INSTALL
importPackage(java.lang);
importPackage(java.util);
importPackage(java.io);

var dsbInstallerName = "EasyESB-installer-linux-v2012-04-18.jar";
var dsbInstallerUrl = "http://research-distributions.petalslink.org/experimental/easyesb/"+dsbInstallerName;

function runDSB() {
	// TODO: !! ONLY ESB - NEXT STEP IS REPLACE WITH DSB !!
	// Perform several checks and run the installation if required

	println("Checking DSB installation ... ");

	// Check if already installed
	var dsbDir = new File(instDir, "dsb");
	if (!dsbDir.exists() || dsbDir.listFiles().length == 0) {
		println("DSB not found, trying to install ...");
		dsbDir.mkdir();

		// Check if the installer is in origin
		var dsbInstallerFile = new File(originDir, dsbInstallerName);
		if (!dsbInstallerFile.exists()) {
			
			// Try do download it from the web
			println("Trying to download the DSB installer from " + dsbInstallerUrl);
			println("Please wait ...");
			try {
				downloadFromHttp(dsbInstallerUrl, dsbInstallerFile);
			} catch (e) {
				println("Unable to download the DSB installer due to " + e.javaException);
			}
			if (!dsbInstallerFile.exists()) {
				throw "Unable to find " + dsbInstallerFile + " please download "
				+ dsbInstallerFile.getName() + " and put it in "
				+ originDir.getAbsolutePath();	
			}						
		}

		// Create config file for installation
		var cfg = new File(originDir, "dsb-install.cfg");
		var out = new PrintWriter(new FileWriter(cfg));
		out.println("INSTALL_PATH=" + dsbDir.getName());
		out.close();
		cfg.deleteOnExit();

		// Install dsb package in console mode
		// java -jar origin\installer-vXXXX-XX-XX.jar -console -options .cfg
		var cmd = [ javaExe, "-jar", dsbInstallerFile.getAbsolutePath(),
				"-console", "-options", cfg.getAbsolutePath() ];
		execCmd(cmd, instDir, dsbMachine);

		println("Installation successfull ...");
	}

	var binDir = new File(dsbDir, "bin");
	var lockedFile = new File(binDir, "locked");
	
	// Check for locked file in bin dir
	if  (lockedFile.exists()) {
		lockedFile['delete']();
	}
	
	// Running dsb from bin dir
	// java %JAVA_OPTS% %DEBUG_OPTS% -jar xxxx.jar start
	var cmd = [ javaExe ];
	var javaOpts = System.getenv("JAVA_OPTS");
	if (javaOpts != null) {
		cmd.push(javaOpts);
	}
	var debugOpts = System.getenv("DEBUG_OPTS");
	if (debugOpts != null) {
		cmd.push(debugOpts);
	}
	cmd.push('-jar', 'server.jar', 'start');
	return execCmdNewTermAsync("DSB", cmd, binDir, dsbMachine);
}