// SOCEDA integration
// ---------
// -- DSB --
// ---------

importPackage(java.lang);
importPackage(java.util);
importPackage(java.io);

var bsmComponentKey = "bsm";
var bsmConfigFilename = "bsm.config.properties";

function runBSM() {
	// Perform several checks and run the installation if required

	println("Checking EasierBSM installation ... ");

	// Check if already installed
	var bsmDir = new File(instDir, bsmComponentKey);
	if (!bsmDir.exists() || bsmDir.listFiles().length == 0) {
		println("EasierBSM not found, trying to install ...");
		bsmDir.mkdir();

		// Check if the installer is in origin
		var bsmInstallerFile = new File(originDir, findInstallerNameOfComponent(bsmComponentKey));
		if (!bsmInstallerFile.exists()) {
			
			// Try do download it from the web
			var componentUrl = findDownloadComponentURL(bsmComponentKey);
			println("Trying to download the EasierBSM installer from " + componentUrl);
			println("Please wait ...");
			try {
				downloadFromHttp(componentUrl, bsmInstallerFile);
			} catch (e) {
				println("Unable to download the EasierBSM installer due to " + e.javaException);
			}
			if (!bsmInstallerFile.exists()) {
				throw "Unable to find " + bsmInstallerFile + " please download "
				+ bsmInstallerFile.getName() + " and put it in "
				+ originDir.getAbsolutePath();	
			}						
		}

		// Extract WS binaries from the installer package
		try {
			extractFolder(bsmInstallerFile, bsmDir);
		} catch (e) {
			println("Unable to extract EasierBSM binaries " + e.javaStackTrace);
		}
		
		if (bsmDir.listFiles().length == 0) {
			throw "Unable to extract EasierBSM please extract " + sccliInstallerFile + " manually into " + bsmDir;
		}
		
		println("Installation successfull ...");
	}

	var binDir = new File(bsmDir, "bin");
	
	// Copy config file
	var srcFile = new File(configDir, bsmConfigFilename);
	var dstFile = new File(binDir, "config.properties");
	try {
		println("Copying " + srcFile + " into " + dstFile.getParent());		
		copyFile(srcFile, dstFile);
	} catch (e) {
		println("!! Unable to copy " + srcFile + " config file due to " + e);
		if (e.javaStackTrace != undefined) {
			println("!! javaStackTrace: " +  e.javaStackTrace);
		}
	}
	
	deleteLockedFile(binDir);
	
	// Running bsm from bin dir
	// java %JAVA_OPTS% %DEBUG_OPTS% -jar xxxx.jar start
	var cmd = [ javaExe ];
	var javaOpts = System.getenv("JAVA_OPTS");
	if (javaOpts != null) {
		cmd.push(javaOpts);
	}
	var debugOpts = System.getenv("DEBUG_OPTS");
	if (debugOpts != null) {
		cmd.push(debugOpts);
	}
	cmd.push('-jar', 'server.jar', 'start');
	return execCmdNewTermAsync("EasierBSM", cmd, binDir);
}