// SOCEDA integration
// ---------------
// -- EasierGOV --
// ---------------

// TODO: ADD DOWNLOAD OF INSTALLER
importPackage(java.lang);
importPackage(java.util);
importPackage(java.io);

var apacheTomcatName = "apache-tomcat-6.0.33";
var cepedComponentKey = "ceped";

function runCEPED() {
	println("Checking CEPEditor installation ... ");

	// Check if already installed
	var cepedDir = new File(instDir, cepedComponentKey);
	if (!cepedDir.exists() || cepedDir.listFiles().length == 0) {
		println("CEPEditor not found, trying to install ...");
		cepedDir.mkdir();

		// Check if the installer is in origin
		var cepedInstallerFile = new File(originDir, findInstallerNameOfComponent(cepedComponentKey));
		if (!cepedInstallerFile.exists()) {
			
			// Try do download it from the web
			var componentUrl = findDownloadComponentURL(cepedComponentKey);
			println("Trying to download the CEPEditor CLI installer from " + componentUrl);
			println("Please wait ...");
			try {
				downloadFromHttp(componentUrl, cepedInstallerFile);
			} catch (e) {
				println("Unable to download the CEPEditor installer due to " + e.javaException);
			}
			
			if (!cepedInstallerFile.exists()) {
				throw "Unable to find " + cepedInstallerFile + " please download "
				+ cepedInstallerFile.getName() + " and put it in "
				+ originDir.getAbsolutePath();
			}
		}

		// Extract CEPEditor binaries from the installer package
		try {
			extractFolder(cepedInstallerFile, cepedDir);
		} catch (e) {
			println("Unable to extract CEPEditor binaries " + e.javaStackTrace);
		}
		
		if (cepedDir.listFiles().length == 0) {
			throw "Unable to extract CEPEditor please extract " + cepedInstallerFile + " manually into " + cepedDir;
		}
		
		println("Installation successfull ...");
	}
	
	var apacheTomcatDir = new File(cepedDir, apacheTomcatName);
	if (!apacheTomcatDir.exists()) {
		throw "Unable to find " + apacheTomcatDir + " please be sure to have the correct CEPEditor archive in " + cepedDir;
	}
	var binDir = new File(apacheTomcatDir, "bin");	
	var startupFile = new File(binDir, "startup"+ (isWindows ? ".bat" : ".sh"));	
	var cmd = [ startupFile.getAbsolutePath() ];	
	var cepedProcess = execCmdNewTermAsync("Apache Tomcat", cmd, binDir);
		
	var port = 8088;	
	while (isPortAvailable(port)) {
		println("Waiting for apache tomcat before opening the CEPEditor web page ...");
		java.lang.Thread.sleep(1000);
	}
		
	// Start a new 
	execCmdNewTermAsync("CEPEditor web page", ["http://localhost:"+port+"/Portail"], binDir);
	
	// TODO: Find a way to kill tomcat
	return cepedProcess;
}