// SOCEDA integration
// ---------
// -- DSB --
// ---------

importPackage(java.lang);
importPackage(java.util);
importPackage(java.io);

var dsbComponentKey = "dsb";
var dsbConfigFilename = "dsb.config.properties";

function runDSB() {
	// Perform several checks and run the installation if required

	println("Checking EasyESB installation ... ");

	// Check if already installed
	var dsbDir = new File(instDir, dsbComponentKey);
	if (!dsbDir.exists() || dsbDir.listFiles().length == 0) {
		println("EasyESB not found, trying to install ...");
		dsbDir.mkdir();

		// Check if the installer is in origin
		var dsbInstallerFile = new File(originDir, findInstallerNameOfComponent(dsbComponentKey));
		if (!dsbInstallerFile.exists()) {
			
			// Try do download it from the web
			var componentUrl = findDownloadComponentURL(dsbComponentKey);
			println("Trying to download the EasyESB installer from " + componentUrl);
			println("Please wait ...");
			try {
				downloadFromHttp(componentUrl, dsbInstallerFile);
			} catch (e) {
				println("Unable to download the EasyESB installer due to " + e.javaException);
			}
			if (!dsbInstallerFile.exists()) {
				throw "Unable to find " + dsbInstallerFile + " please download "
				+ dsbInstallerFile.getName() + " and put it in "
				+ originDir.getAbsolutePath();	
			}						
		}

		// Extract WS binaries from the installer package
		try {
			extractFolder(dsbInstallerFile, dsbDir);
		} catch (e) {
			println("Unable to extract EasyESB binaries " + e.javaStackTrace);
		}
		
		if (dsbDir.listFiles().length == 0) {
			throw "Unable to extract EasyESB please extract " + sccliInstallerFile + " manually into " + dsbDir;
		}
		
		println("Installation successfull ...");
	}

	var binDir = new File(dsbDir, "bin");
	
	// Copy config file
	var srcFile = new File(configDir, dsbConfigFilename);
	var dstFile = new File(binDir, "config.properties");
	try {
		println("Copying " + srcFile + " into " + dstFile.getParent());		
		copyFile(srcFile, dstFile);
	} catch (e) {
		println("!! Unable to copy " + srcFile + " config file due to " + e);
		if (e.javaStackTrace != undefined) {
			println("!! javaStackTrace: " +  e.javaStackTrace);
		}
	}
	
	deleteLockedFile(binDir);
	
	// Running dsb from bin dir
	// java %JAVA_OPTS% %DEBUG_OPTS% -jar xxxx.jar start
	var cmd = [ javaExe ];
	var javaOpts = System.getenv("JAVA_OPTS");
	if (javaOpts != null) {
		cmd.push(javaOpts);
	}
	var debugOpts = System.getenv("DEBUG_OPTS");
	if (debugOpts != null) {
		cmd.push(debugOpts);
	}
	cmd.push('-jar', 'server.jar', 'start');
	return execCmdNewTermAsync("EasyESB", cmd, binDir);
}