// SOCEDA integration
// ---------------
// -- EasierGOV --
// ---------------

// TODO: ADD DOWNLOAD OF INSTALLER
// TODO: ADD REMOTE INSTALL
importPackage(java.lang);
importPackage(java.util);
importPackage(java.io);

var apacheTomcatName = "apache-tomcat-6.0.33";
var cepedInstallerName = "CEPEditor.zip";
var cepedInstallerUrl = "http://161.105.138.99:8080/CEPEditor/"+cepedInstallerName;

function runCEPED() {
	println("Checking CEPEditor installation ... ");

	// Check if already installed
	var cepedDir = new File(instDir, "ceped");
	if (!cepedDir.exists() || cepedDir.listFiles().length == 0) {
		println("CEPEditor not found, trying to install ...");
		cepedDir.mkdir();

		// Check if the installer is in origin
		var cepedInstallerFile = new File(originDir, cepedInstallerName);
		if (!cepedInstallerFile.exists()) {
			
			// Try to download it from the web
			println("Trying to download the CEPEditor installer from " + cepedInstallerUrl);
			println("Please wait ...");
			try {
				downloadFromHttp(cepedInstallerUrl, cepedInstallerFile);
			} catch (e) {
				println("Unable to download the CEPEditor installer due to " + e.javaException);
			}
			
			if (!cepedInstallerFile.exists()) {
				throw "Unable to find " + cepedInstallerFile + " please download "
				+ cepedInstallerFile.getName() + " and put it in "
				+ originDir.getAbsolutePath();
			}
		}

		// Extract CEPEditor binaries from the installer package
		try {
			extractFolder(cepedInstallerFile, cepedDir);
		} catch (e) {
			println("Unable to extract CEPEditor binaries " + e.javaStackTrace);
		}
		
		if (cepedDir.listFiles().length == 0) {
			throw "Unable to extract CEPEditor please extract " + cepedInstallerFile + " manually into " + cepedDir;
		}
		
		println("Installation successfull ...");
	}
	
	var apacheTomcatDir = new File(cepedDir, apacheTomcatName);
	if (!apacheTomcatDir.exists()) {
		throw "Unable to find " + apacheTomcatDir + " please be sure to have the correct CEPEditor archive in " + cepedDir;
	}
	var binDir = new File(apacheTomcatDir, "bin");	
	var startupFile = new File(binDir, "startup"+ (isWindows ? ".bat" : ".sh"));	
	var cmd = [ startupFile.getAbsolutePath(), "; sleep 86400" ];	
	var cepedProcess = execCmdNewTermAsync("Apache Tomcat", cmd, binDir, cepedMachine);
		
	var port = 8088;
	while (!tomcatAccessible(port)) {
		println("Waiting for apache tomcat before opening the CEPEditor web page ...");
		java.lang.Thread.sleep(1000);
	}
		
	// Start a new 
	// FIXME: whooohooo!!! What is the meaning of this command???
	execCmdNewTermAsync("CEPEditor web page", ["http://localhost:"+port+"/Portail"], binDir, cepedMachine);
	
	// TODO: Find a way to kill tomcat
	return cepedProcess;
}

function shutdownTomcat() {
	println("Shutdown Tomcat ... ");

	// Check if already installed
	var cepedDir = new File(instDir, "ceped");
	var apacheTomcatDir = new File(cepedDir, apacheTomcatName);
	if (!apacheTomcatDir.exists()) {
		throw "Unable to find " + apacheTomcatDir + " please be sure to have the correct CEPEditor archive in " + cepedDir;
	}
	var binDir = new File(apacheTomcatDir, "bin");	
	var startupFile = new File(binDir, "shutdown"+ (isWindows ? ".bat" : ".sh"));	
	var cmd = [ startupFile.getAbsolutePath() ];	
	execCmd(cmd, binDir, cepedMachine);
}