// SOCEDA integration
// --------
// -- WS --
// --------

// will run start-providers.sh.bat

importPackage(java.lang);
importPackage(java.util);
importPackage(java.io);

var wsComponentKey = "ws";

function runWS() {
	println("Checking WS installation ... ");

	// Check if already installed
	var wsDir = new File(instDir, wsComponentKey);
	if (!wsDir.exists() || wsDir.listFiles().length == 0) {
		println("WS not found, trying to install ...");
		wsDir.mkdir();

		// Check if the installer is in origin
		var wsInstallerFile = new File(originDir, findInstallerNameOfComponent(wsComponentKey));
		if (!wsInstallerFile.exists()) {
			
			// Try do download it from the web
			var componentUrl = findDownloadComponentURL(wsComponentKey);
			println("Trying to download the WS installer from " + componentUrl);
			println("Please wait ...");
			try {
				downloadFromHttp(componentUrl, wsInstallerFile);
			} catch (e) {
				println("Unable to download the WS installer " + e.javaStackTrace);
			}
			
			if (!wsInstallerFile.exists()) {
				throw "Unable to find " + wsInstallerFile + " please download "
				+ wsInstallerFile.getName() + " and put it in "
				+ originDir.getAbsolutePath();
			}
		}

		// Extract WS binaries from the installer package
		try {
			extractFolder(wsInstallerFile, wsDir);
		} catch (e) {
			println("Unable to extract WS binaries " + e.javaStackTrace);
		}
		
		if (wsDir.listFiles().length == 0) {
			throw "Unable to extract WS please extract " + wsInstallerFile + " manually into " + wsDir;
		}
		
		println("Installation successfull ...");
	}

	var binDir = new File(wsDir, "bin");
	
	// Running ws from bin dir
	var cmd = [ javaExe ];
	var javaOpts = System.getenv("JAVA_OPTS");
	if (javaOpts != null) {
		cmd.push(javaOpts);
	}
	
	// Starting following components	 	
	var providerNames = [];
	// java %JAVA_OPTS% -cp "crisis-management-resources-v0.1.jar" fr.mines_albi.nuclearcrisisevent.provider.MotoristProvider_Main false
	providerNames.push("fr.mines_albi.nuclearcrisisevent.provider.MotoristProvider_Main");
	
	//java %JAVA_OPTS% -cp "crisis-management-resources-v0.1.jar" fr.mines_albi.nuclearcrisisevent.provider.DriverProvider_Main false 
	providerNames.push("fr.mines_albi.nuclearcrisisevent.provider.DriverProvider_Main");
	
	//java %JAVA_OPTS% -cp "crisis-management-resources-v0.1.jar" fr.mines_albi.nuclearcrisisevent.provider.BusProvider_Main false 
	providerNames.push("fr.mines_albi.nuclearcrisisevent.provider.BusProvider_Main");
	
	//java %JAVA_OPTS% -cp "crisis-management-resources-v0.1.jar" fr.mines_albi.nuclearcrisisevent.provider.CarProvider_Main false 
	providerNames.push("fr.mines_albi.nuclearcrisisevent.provider.CarProvider_Main");
	
	//java %JAVA_OPTS% -cp "crisis-management-resources-v0.1.jar" fr.mines_albi.nuclearcrisisevent.provider.VehicleProvider_Main false 
	providerNames.push("fr.mines_albi.nuclearcrisisevent.provider.VehicleProvider_Main");
	
	//java %JAVA_OPTS% -cp "crisis-management-resources-v0.1.jar" org.petalslink.officeofinfrastructure.OfficeOfInfrastructure_Main false 
	providerNames.push("org.petalslink.officeofinfrastructure.OfficeOfInfrastructure_Main");
	
	var procs = [];
	for (x in providerNames) {		
		var name = providerNames[x];
		var proc = execCmdNewTermAsync(name, cmd.concat("-cp", "crisis-management-resources-" + findPropertyInInstaller("installer.version") + ".jar", name, "false"), binDir);
		procs.push(proc);
	}
	
	return procs;
}