package fr.mines_albi.nuclearcrisisevent.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.LogManager;

import javax.xml.ws.Endpoint;

import org.petalslink.abslayer.service.api.Description;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.provided.AbstractImplementationManager;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration.PositionType;

import com.ebmwebsourcing.easiergov.Main;

public class MotoristProvider_WSOUIServer {
	private static String endpointHost = System.getProperty("endpointHost", "localhost");

	private final static String LOGGER_FILE = "/logger.properties";

	static {
		try {
			InputStream inputStream = null;
			File logger = new File("." + LOGGER_FILE);
			if (logger.exists()) {
				inputStream = new FileInputStream(logger);
			} else {
				// ty to get from classpath
				inputStream = Main.class.getClass()
						.getResourceAsStream(LOGGER_FILE);
			}
			if (inputStream != null) {
				LogManager.getLogManager().readConfiguration(inputStream);
				inputStream.close();
			}
		} catch (final Exception e) {
			throw new RuntimeException("couldn't initialize logging properly",
					e);
		}
	}

	
	private Endpoint endpointFor_MotoristProvider = null;
	private ProviderConfiguration confEndpointFor_MotoristProvider = null;
	private AbstractImplementationManager<?> im = null;
	
	public MotoristProvider_WSOUIServer() {
	}


	public ProviderConfiguration createDefaultProviderConfigurationFor_MotoristProvider() {
		ProviderConfiguration conf = new ProviderConfiguration();
		conf.setEndpointAddress("http://" + endpointHost + ":9107/motoristProviderPort");
		conf.setPosition(PositionType.NORTH_EAST);
		conf.setActiveGui(false);
		return conf;
	}


	public ProviderConfiguration getProviderConfigurationFor_MotoristProvider() {
		if(this.confEndpointFor_MotoristProvider == null) {
			this.confEndpointFor_MotoristProvider = createDefaultProviderConfigurationFor_MotoristProvider();
		}
		return this.confEndpointFor_MotoristProvider;
	}


	public void start() throws WSOUIException {
		confEndpointFor_MotoristProvider = getProviderConfigurationFor_MotoristProvider();
		im = new MotoristProviderImplementationManager(new MotoristProviderTestImplementation(new MotoristProvider_ExchangeProcessor()), MotoristProvider_WSOUIService.getWSDL_LOCATION(), confEndpointFor_MotoristProvider);
		endpointFor_MotoristProvider = Endpoint.publish(confEndpointFor_MotoristProvider.getEndpointAddress(), im);
		System.out.println("Service deploy at: " + confEndpointFor_MotoristProvider.getEndpointAddress() + "?wsdl");
		System.out.println("Service Configuration: " + confEndpointFor_MotoristProvider);
	}


	public void stop() {
		if(endpointFor_MotoristProvider != null) {
			endpointFor_MotoristProvider.stop();
		}
	}


	public Description getDescription() {
		return im.getDescription();
	}


	public static void main(String args[]) throws Exception {
		MotoristProvider_WSOUIServer provider = new MotoristProvider_WSOUIServer();
		provider.start();
		boolean gui = false;
		if(args.length > 0) {
			System.out.print("Commands args: " + args);
			for(int i=0; i < args.length; i++) {
				System.out.print(args[i]);
			}
			System.out.println();
			gui = Boolean.parseBoolean(args[0]);
			System.out.println("gui = " + gui);
		}
		provider.getProviderConfigurationFor_MotoristProvider().setActiveGui(gui);
		System.out.println("Server ready...");
	}

}
