package fr.mines_albi.nuclearcrisisevent.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.LogManager;

import javax.xml.ws.Endpoint;

import org.petalslink.abslayer.service.api.Description;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.provided.AbstractImplementationManager;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration.PositionType;

import com.ebmwebsourcing.easiergov.Main;

public class VehicleProvider_WSOUIServer {
	private static String endpointHost = System.getProperty("endpointHost", "localhost");

	private final static String LOGGER_FILE = "/logger.properties";

	static {
		try {
			InputStream inputStream = null;
			File logger = new File("." + LOGGER_FILE);
			if (logger.exists()) {
				inputStream = new FileInputStream(logger);
			} else {
				// ty to get from classpath
				inputStream = Main.class.getClass()
						.getResourceAsStream(LOGGER_FILE);
			}
			if (inputStream != null) {
				LogManager.getLogManager().readConfiguration(inputStream);
				inputStream.close();
			}
		} catch (final Exception e) {
			throw new RuntimeException("couldn't initialize logging properly",
					e);
		}
	}

	
	private Endpoint endpointFor_VehicleProvider = null;
	private ProviderConfiguration confEndpointFor_VehicleProvider = null;
	private AbstractImplementationManager<?> im = null;
	
	public VehicleProvider_WSOUIServer() {
	}


	public ProviderConfiguration createDefaultProviderConfigurationFor_VehicleProvider() {
		ProviderConfiguration conf = new ProviderConfiguration();
		conf.setEndpointAddress("http://" + endpointHost + ":9109/vehicleProviderPort");
		conf.setPosition(PositionType.NORTH_EAST);
		conf.setActiveGui(false);
		return conf;
	}


	public ProviderConfiguration getProviderConfigurationFor_VehicleProvider() {
		if(this.confEndpointFor_VehicleProvider == null) {
			this.confEndpointFor_VehicleProvider = createDefaultProviderConfigurationFor_VehicleProvider();
		}
		return this.confEndpointFor_VehicleProvider;
	}


	public void start() throws WSOUIException {
		confEndpointFor_VehicleProvider = getProviderConfigurationFor_VehicleProvider();
		im = new VehicleProviderImplementationManager(new VehicleProviderTestImplementation(new VehicleProvider_ExchangeProcessor()), VehicleProvider_WSOUIService.getWSDL_LOCATION(), confEndpointFor_VehicleProvider);
		endpointFor_VehicleProvider = Endpoint.publish(confEndpointFor_VehicleProvider.getEndpointAddress(), im);
		System.out.println("Service deploy at: " + confEndpointFor_VehicleProvider.getEndpointAddress() + "?wsdl");
		System.out.println("Service Configuration: " + confEndpointFor_VehicleProvider);
	}


	public void stop() {
		if(endpointFor_VehicleProvider != null) {
			endpointFor_VehicleProvider.stop();
		}
	}


	public Description getDescription() {
		return im.getDescription();
	}


	public static void main(String args[]) throws Exception {
		VehicleProvider_WSOUIServer provider = new VehicleProvider_WSOUIServer();
		provider.start();
		boolean gui = false;
		if(args.length > 0) {
			System.out.print("Commands args: " + args);
			for(int i=0; i < args.length; i++) {
				System.out.print(args[i]);
			}
			System.out.println();
			gui = Boolean.parseBoolean(args[0]);
			System.out.println("gui = " + gui);
		}
		provider.getProviderConfigurationFor_VehicleProvider().setActiveGui(gui);
		System.out.println("Server ready...");
	}

}
