package org.petalslink;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Scanner;
import java.util.logging.LogManager;

import javax.xml.namespace.QName;

import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.officeofinfrastructure.OfficeOfInfrastructureEventProducer_WSOUIServer;
import org.petalslink.officeofinfrastructure.OfficeOfInfrastructure_WSOUIServer;
import org.petalslink.seacloud.SeaCloud_WSOUIServer;

import com.ebmwebsourcing.easiestdemo.helper.BusManagement;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;

import fr.mines_albi.nuclearcrisisevent.provider.BusProviderEvent_WSOUIServer;
import fr.mines_albi.nuclearcrisisevent.provider.BusProvider_WSOUIServer;
import fr.mines_albi.nuclearcrisisevent.provider.CarProviderEvent_WSOUIServer;
import fr.mines_albi.nuclearcrisisevent.provider.CarProvider_WSOUIServer;
import fr.mines_albi.nuclearcrisisevent.provider.DriverProviderEvent_WSOUIServer;
import fr.mines_albi.nuclearcrisisevent.provider.DriverProvider_WSOUIServer;
import fr.mines_albi.nuclearcrisisevent.provider.MotoristProviderEvent_WSOUIServer;
import fr.mines_albi.nuclearcrisisevent.provider.MotoristProvider_WSOUIServer;
import fr.mines_albi.nuclearcrisisevent.provider.VehicleProviderEvent_WSOUIServer;
import fr.mines_albi.nuclearcrisisevent.provider.VehicleProvider_WSOUIServer;

public class OperationImplementCirculationPlanProcess_Main {

	public final static URL BPEL_LOCATION;
	static {
	    BPEL_LOCATION = Thread.currentThread().getContextClassLoader().getResource("crisis/management/generated/OperationImplementCirculationPlanProcess.bpel");
	}

	static {
		try {
			InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("logger/easiestdemo-logging.properties");
			System.out.println("configFile = " + configFile);
			LogManager.getLogManager().readConfiguration(configFile);
			configFile.close();
		} catch (Exception ex){
			try {
				InputStream configFile = new File("./src/main/resources/logger/easiestdemo-logging.properties").toURI().toURL().openStream();
				System.out.println("configFile = " + configFile);
				LogManager.getLogManager().readConfiguration(configFile);
				configFile.close();
			} catch (Exception ex1){
				System.out.println("WARNING: Could not open configuration file");
				System.out.println("WARNING: Logging not configured (console output only)");
			}
		}
	}
	
	private MotoristProviderEvent_WSOUIServer motoristProviderEvent_WSOUIServer = null;
	private MotoristProvider_WSOUIServer motoristProvider_WSOUIServer = null;
	private DriverProviderEvent_WSOUIServer driverProviderEvent_WSOUIServer = null;
	private DriverProvider_WSOUIServer driverProvider_WSOUIServer = null;
	private BusProviderEvent_WSOUIServer busProviderEvent_WSOUIServer = null;
	private BusProvider_WSOUIServer busProvider_WSOUIServer = null;
	private CarProviderEvent_WSOUIServer carProviderEvent_WSOUIServer = null;
	private CarProvider_WSOUIServer carProvider_WSOUIServer = null;
	private VehicleProviderEvent_WSOUIServer vehicleProviderEvent_WSOUIServer = null;
	private VehicleProvider_WSOUIServer vehicleProvider_WSOUIServer = null;
	private SeaCloud_WSOUIServer seaCloud_WSOUIServer = null;
	private OfficeOfInfrastructureEventProducer_WSOUIServer officeOfInfrastructureEventProducer_WSOUIServer = null;
	private OfficeOfInfrastructure_WSOUIServer officeOfInfrastructure_WSOUIServer = null;

	private Node node = null;
	private QName nodeName = new QName("http://www.petalslink.org/", "OperationImplementCirculationPlanProcess_EasyESBNode");
	private String nodeHost = "localhost";
	private int nodeInternalPort = 8000;
	private int nodeSoapPort = 8085;
	private String adminUrl = "http://" + nodeHost + ":" + nodeSoapPort + "/services/adminExternalEndpoint";

	private static boolean standalone = false;


	public static void main(String args[]) throws Exception {
		OperationImplementCirculationPlanProcess_Main main = new OperationImplementCirculationPlanProcess_Main();
		PrintStream err = System.err;
		try {
		
			boolean activeGUI = true;
			analyzeCommand(args);
		
			// Create and Start all WebServices
			main.startAllWebServices();
		
			// Set GUI on all WebServices
			main.setGUIOnAllWebServices(false);
		
			// Exit
			Scanner sc = new Scanner(System.in);
			System.out.println("Hit Enter to exit :");
			sc.nextLine();
			
			// Create EasyESB node
			main.createNode();
		
			// Deploy and Expose BPEL
			List<URL> bpelUrls = main.deployAndExposeBPEL(OperationImplementCirculationPlanProcess_Main.BPEL_LOCATION);
		
			// Create and Start client
			if(activeGUI) {
				main.createClient();
			}
		
		
		} catch(Exception e) {
		
			e.printStackTrace(err);
		
			// Stop all WebServices
			main.stopAllWebServices();
		
			// Stop node
			main.stopNode();
		
		}
	}


	public static void analyzeCommand(String args[]) {
		if(args != null && args.length == 1 && args[0].equals("standalone")) {
			standalone = true;
		}
	}


	public boolean isStandalone() {
		return standalone;
	}

	
	public void createNode() throws ESBException {
		this.node = BusManagement.getInstance().createNode(nodeName, nodeHost, nodeInternalPort, nodeSoapPort);
	}


	public List<URL> deployAndExposeBPEL(URL bpel) throws Exception {
		List<URL> urls = BusManagement.getInstance().deployAndExposeBPEL(bpel, new URL(adminUrl));

		System.out.println("BPEL " + bpel + " are exposed at url:");
		for(URL url: urls) {
			System.out.println("	" + url);
		}
		return urls;
	}


	public void stopNode() throws TransportException {
		this.node.stop();
	}


	public void startAllWebServices() throws WSOUIException {
		if(!isStandalone()) {
			motoristProviderEvent_WSOUIServer = new MotoristProviderEvent_WSOUIServer();
			motoristProviderEvent_WSOUIServer.start();
			motoristProvider_WSOUIServer = new MotoristProvider_WSOUIServer();
			motoristProvider_WSOUIServer.start();
			driverProviderEvent_WSOUIServer = new DriverProviderEvent_WSOUIServer();
			driverProviderEvent_WSOUIServer.start();
			driverProvider_WSOUIServer = new DriverProvider_WSOUIServer();
			driverProvider_WSOUIServer.start();
			busProviderEvent_WSOUIServer = new BusProviderEvent_WSOUIServer();
			busProviderEvent_WSOUIServer.start();
			busProvider_WSOUIServer = new BusProvider_WSOUIServer();
			busProvider_WSOUIServer.start();
			carProviderEvent_WSOUIServer = new CarProviderEvent_WSOUIServer();
			carProviderEvent_WSOUIServer.start();
			carProvider_WSOUIServer = new CarProvider_WSOUIServer();
			carProvider_WSOUIServer.start();
			vehicleProviderEvent_WSOUIServer = new VehicleProviderEvent_WSOUIServer();
			vehicleProviderEvent_WSOUIServer.start();
			vehicleProvider_WSOUIServer = new VehicleProvider_WSOUIServer();
			vehicleProvider_WSOUIServer.start();
			seaCloud_WSOUIServer = new SeaCloud_WSOUIServer();
			seaCloud_WSOUIServer.start();
			officeOfInfrastructureEventProducer_WSOUIServer = new OfficeOfInfrastructureEventProducer_WSOUIServer();
			officeOfInfrastructureEventProducer_WSOUIServer.start();
			officeOfInfrastructure_WSOUIServer = new OfficeOfInfrastructure_WSOUIServer();
			officeOfInfrastructure_WSOUIServer.start();
		}
	}


	public void createClient() throws WSOUIException {
		try {
			WSOUIClient client = new WSOUIClient();
			org.petalslink.easiestdemo.client.model.api.esb.Node n = client.addNewAdminWsdlofESBNode(new URL(adminUrl + "?wsdl"));
			n.setModel(node);
			client.setVisible(true);
		} catch (MalformedURLException e) {
			throw new WSOUIException(e);
		} catch (WSOUIClientException e) {
			throw new WSOUIException(e);
		}
	}


	public void setGUIOnAllWebServices(boolean activeGUI) throws WSOUIException {
		if(!isStandalone()) {
		if(motoristProviderEvent_WSOUIServer != null) {
			motoristProviderEvent_WSOUIServer.getProviderConfigurationFor_MotoristProviderEvent().setActiveGui(activeGUI);
		}
		if(motoristProvider_WSOUIServer != null) {
			motoristProvider_WSOUIServer.getProviderConfigurationFor_MotoristProvider().setActiveGui(activeGUI);
		}
		if(driverProviderEvent_WSOUIServer != null) {
			driverProviderEvent_WSOUIServer.getProviderConfigurationFor_DriverProviderEvent().setActiveGui(activeGUI);
		}
		if(driverProvider_WSOUIServer != null) {
			driverProvider_WSOUIServer.getProviderConfigurationFor_DriverProvider().setActiveGui(activeGUI);
		}
		if(busProviderEvent_WSOUIServer != null) {
			busProviderEvent_WSOUIServer.getProviderConfigurationFor_BusProviderEvent().setActiveGui(activeGUI);
		}
		if(busProvider_WSOUIServer != null) {
			busProvider_WSOUIServer.getProviderConfigurationFor_BusProvider().setActiveGui(activeGUI);
		}
		if(carProviderEvent_WSOUIServer != null) {
			carProviderEvent_WSOUIServer.getProviderConfigurationFor_CarProviderEvent().setActiveGui(activeGUI);
		}
		if(carProvider_WSOUIServer != null) {
			carProvider_WSOUIServer.getProviderConfigurationFor_CarProvider().setActiveGui(activeGUI);
		}
		if(vehicleProviderEvent_WSOUIServer != null) {
			vehicleProviderEvent_WSOUIServer.getProviderConfigurationFor_VehicleProviderEvent().setActiveGui(activeGUI);
		}
		if(vehicleProvider_WSOUIServer != null) {
			vehicleProvider_WSOUIServer.getProviderConfigurationFor_VehicleProvider().setActiveGui(activeGUI);
		}
		if(seaCloud_WSOUIServer != null) {
			seaCloud_WSOUIServer.getProviderConfigurationFor_SeaCloud().setActiveGui(activeGUI);
		}
		if(officeOfInfrastructureEventProducer_WSOUIServer != null) {
			officeOfInfrastructureEventProducer_WSOUIServer.getProviderConfigurationFor_OfficeOfInfrastructureEventProducer().setActiveGui(activeGUI);
		}
		if(officeOfInfrastructure_WSOUIServer != null) {
			officeOfInfrastructure_WSOUIServer.getProviderConfigurationFor_OfficeOfInfrastructure().setActiveGui(activeGUI);
		}
		}
	}


	public void stopAllWebServices() {
		if(!isStandalone()) {
		if(motoristProviderEvent_WSOUIServer != null) {
			motoristProviderEvent_WSOUIServer.stop();
		}
		if(motoristProvider_WSOUIServer != null) {
			motoristProvider_WSOUIServer.stop();
		}
		if(driverProviderEvent_WSOUIServer != null) {
			driverProviderEvent_WSOUIServer.stop();
		}
		if(driverProvider_WSOUIServer != null) {
			driverProvider_WSOUIServer.stop();
		}
		if(busProviderEvent_WSOUIServer != null) {
			busProviderEvent_WSOUIServer.stop();
		}
		if(busProvider_WSOUIServer != null) {
			busProvider_WSOUIServer.stop();
		}
		if(carProviderEvent_WSOUIServer != null) {
			carProviderEvent_WSOUIServer.stop();
		}
		if(carProvider_WSOUIServer != null) {
			carProvider_WSOUIServer.stop();
		}
		if(vehicleProviderEvent_WSOUIServer != null) {
			vehicleProviderEvent_WSOUIServer.stop();
		}
		if(vehicleProvider_WSOUIServer != null) {
			vehicleProvider_WSOUIServer.stop();
		}
		if(seaCloud_WSOUIServer != null) {
			seaCloud_WSOUIServer.stop();
		}
		if(officeOfInfrastructureEventProducer_WSOUIServer != null) {
			officeOfInfrastructureEventProducer_WSOUIServer.stop();
		}
		if(officeOfInfrastructure_WSOUIServer != null) {
			officeOfInfrastructure_WSOUIServer.stop();
		}
		}
	}



}
