package org.petalslink.seacloud;

import javax.xml.ws.Endpoint;

import org.petalslink.abslayer.service.api.Description;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.provided.AbstractImplementationManager;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration.PositionType;

public class SeaCloud_WSOUIServer {
	private static String endpointHost = System.getProperty("endpointHost", "localhost");

	private Endpoint endpointFor_SeaCloud = null;
	private ProviderConfiguration confEndpointFor_SeaCloud = null;
	private AbstractImplementationManager<?> im = null;
	
	public SeaCloud_WSOUIServer() {
	}


	public ProviderConfiguration createDefaultProviderConfigurationFor_SeaCloud() {
		ProviderConfiguration conf = new ProviderConfiguration();
		conf.setEndpointAddress("http://" + endpointHost + ":9000/SeaCloudSOAPEndpoint");
		conf.setPosition(PositionType.NORTH_EAST);
		conf.setActiveGui(false);
		return conf;
	}


	public ProviderConfiguration getProviderConfigurationFor_SeaCloud() {
		if(this.confEndpointFor_SeaCloud == null) {
			this.confEndpointFor_SeaCloud = createDefaultProviderConfigurationFor_SeaCloud();
		}
		return this.confEndpointFor_SeaCloud;
	}


	public void start() throws WSOUIException {
		confEndpointFor_SeaCloud = getProviderConfigurationFor_SeaCloud();
		im = new SeaCloudImplementationManager(new SeaCloudTestImplementation(new SeaCloud_ExchangeProcessor()), SeaCloud_WSOUIService.getWSDL_LOCATION(), confEndpointFor_SeaCloud);
		endpointFor_SeaCloud = Endpoint.publish(confEndpointFor_SeaCloud.getEndpointAddress(), im);
		System.out.println("Service deploy at: " + confEndpointFor_SeaCloud.getEndpointAddress() + "?wsdl");
		System.out.println("Service Configuration: " + confEndpointFor_SeaCloud);
	}


	public void stop() {
		if(endpointFor_SeaCloud != null) {
			endpointFor_SeaCloud.stop();
		}
	}


	public Description getDescription() {
		return im.getDescription();
	}


	public static void main(String args[]) throws Exception {
		SeaCloud_WSOUIServer provider = new SeaCloud_WSOUIServer();
		provider.start();
		boolean gui = false;
		if(args.length > 0) {
			System.out.print("Commands args: " + args);
			for(int i=0; i < args.length; i++) {
				System.out.print(args[i]);
			}
			System.out.println();
			gui = Boolean.parseBoolean(args[0]);
			System.out.println("gui = " + gui);
		}
		provider.getProviderConfigurationFor_SeaCloud().setActiveGui(gui);
		System.out.println("Server ready...");
	}

}
