// SOCEDA integration
// ---------
// -- DSB --
// ---------

importPackage(java.lang);
importPackage(java.util);
importPackage(java.io);

var smsComponentKey = "sms";
var smsConfigFilename = "sms.config.properties";

function runSMS() {
	// Perform several checks and run the installation if required

	println("Checking SendSMS WS installation ... ");

	// Check if already installed
	var smsDir = new File(instDir, smsComponentKey);
	if (!smsDir.exists() || smsDir.listFiles().length == 0) {
		println("SendSMS WS not found, trying to install ...");
		smsDir.mkdir();

		// Check if the installer is in origin
		var smsInstallerFile = new File(originDir, findInstallerNameOfComponent(smsComponentKey));
		if (!smsInstallerFile.exists()) {
			
			// Try do download it from the web
			var componentUrl = findDownloadComponentURL(smsComponentKey);
			println("Trying to download the SendSMS WS installer from " + componentUrl);
			println("Please wait ...");
			try {
				downloadFromHttp(componentUrl, smsInstallerFile);
			} catch (e) {
				println("Unable to download the SendSMS WS installer due to " + e.javaException);
			}
			if (!smsInstallerFile.exists()) {
				throw "Unable to find " + smsInstallerFile + " please download "
				+ smsInstallerFile.getName() + " and put it in "
				+ originDir.getAbsolutePath();	
			}						
		}

		// Extract WS binaries from the installer package
		try {
			extractFolder(smsInstallerFile, smsDir);
		} catch (e) {
			println("Unable to extract SendSMS WS binaries " + e.javaStackTrace);
		}
		
		if (smsDir.listFiles().length == 0) {
			throw "Unable to extract SendSMS WS please extract " + sccliInstallerFile + " manually into " + smsDir;
		}
		
		println("Installation successfull ...");
	}

	var binDir = new File(smsDir, "bin");
	
	// Copy config file
	var srcFile = new File(configDir, smsConfigFilename);
	var dstFile = new File(binDir, "config.properties");
	try {
		println("Copying " + srcFile + " into " + dstFile.getParent());		
		copyFile(srcFile, dstFile);
	} catch (e) {
		println("!! Unable to copy " + srcFile + " config file due to " + e);
		if (e.javaStackTrace != undefined) {
			println("!! javaStackTrace: " +  e.javaStackTrace);
		}
	}
	
	deleteLockedFile(binDir);
	
	// Running sms from bin dir
	// java %JAVA_OPTS% %DEBUG_OPTS% -jar xxxx.jar start
	var cmd = [ javaExe ];
	var javaOpts = System.getenv("JAVA_OPTS");
	if (javaOpts != null) {
		cmd.push(javaOpts);
	}
	var debugOpts = System.getenv("DEBUG_OPTS");
	if (debugOpts != null) {
		cmd.push(debugOpts);
	}
	cmd.push('-jar', 'server.jar', 'start');
	return execCmdNewTermAsync("SendSMS WS", cmd, binDir);
}