package com.orange.eventData.events.inEvents;


import javax.xml.namespace.QName;

import org.apache.commons.lang3.StringEscapeUtils;

import com.orange.eventData.events.MultipleCEPSupport;
import com.orange.eventData.events.inEvent;

/*************************************************************************/
/**
 * <p>This class defines GeolocationEvent  event.</p>
 * <p> for input and output event<p>
 * <p>
 * event defines several properties, that defines an 
 * event type : 
 * <ul>
 *   <li>A latitude</li>
 *   <li>A longitude</li>
 * </ul>
 * </p>
 *
 * PLAY project - GeolocationEvent generated by GPS or/and  Telco Enabler
 * @author Philippe Gibert BIZZ/DIAM/EMB
 */
public class GeolocationEvent extends inEvent implements MultipleCEPSupport {
	private static final long serialVersionUID = -7952260000684495296L;

	/**  latitude and longitude slots  for the  Event  */
	protected double latitude = -1;
	protected double longitude = -1;
	protected String userType = "";   /* Customer or Driver */
	protected String phoneNumber = "";

	public GeolocationEvent() {
	}
	
	public GeolocationEvent(double latitude, double longitude, String userType,
			String phoneNumber) {
		super();
		this.latitude = latitude;
		this.longitude = longitude;
		this.userType = userType;
		this.phoneNumber = phoneNumber;
	}
	
	public GeolocationEvent(String timeStamp, String uniqueId,
			String sequenceNumber,double latitude, double longitude, String userType,
			String phoneNumber) {
		super(timeStamp, uniqueId, sequenceNumber);
		this.latitude = latitude;
		this.longitude = longitude;
		this.userType = userType;
		this.phoneNumber = phoneNumber;
	}
	
	public double getLatitude() {
		return latitude;
	}
	
	public void setLatitude(double latitude) {
		this.latitude = latitude;
	}
	
	public double getLongitude() {
		return longitude;
	}
	
	public void setLongitude(double longitude) {
		this.longitude = longitude;
	}
	
	public String getUserType() {
		return userType;
	}

	public void setUserType(String userType) {
		this.userType = userType;
	}

	public String getPhoneNumber() {
		return phoneNumber;
	}

	public void setPhoneNumber(String phoneNumber) {
		this.phoneNumber = phoneNumber;
	}

	// facility to send directly to  CEP  for Sprint 0 whatever the transport is
	public String toStringCEP() {
		return "stream=GeolocationEvent,timestamp=" + timeStamp + ",uniqueId="
		+ uniqueId + ",sequenceNumber=" + sequenceNumber
		+ ",latitude=" + latitude + ",longitude=" + longitude+",userType="+userType+",phoneNumber="+phoneNumber ;
	}

	public String toStringCEP1() {
		return "stream=GeolocationEvent,timeStamp=" + "timeStamp" +
		",uniqueId=" + uniqueId + ",sequenceNumber=" + sequenceNumber+
		",latitude=" + latitude + ",longitude=" + longitude + ",userType=" + userType + ",phoneNumber="
		+ phoneNumber;
	}

	@Override
	public String toString() {
		return "GeolocationEvent [uniqueId=" + uniqueId + ", sequenceNumber="
		+ sequenceNumber + ", timeStamp=" + timeStamp + ", latitude="
		+ latitude + ", longitude=" + longitude + ", userType="
		+ userType + ", phoneNumber=" + phoneNumber + "]";
	}

	public String toXML() {
		return "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <GeolocationEvent xmlns=\"http://www.orange.org/TaxiEventType\" "+
		"xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" " +
		"xsi:schemaLocation=\"http://www.orange.org/TaxiEventType TaxiEventType.xsd\">"+
		"<uniqueId>"+uniqueId+"</uniqueId>"+
		"<sequenceNumber>"+sequenceNumber+"</sequenceNumber>"+
		"<timeStamp>"+timeStamp+"</timeStamp>"+
		"<latitude>"+latitude+"</latitude>"+
		"<longitude>"+longitude+"</longitude>"+
		"<userType>"+userType+"</userType>"+
		"<phoneNumber>"+phoneNumber+"</phoneNumber>"+
		"</GeolocationEvent>";
	}

	public String toCEP() {
		return "stream=GeolocationEvent,timeStamp=" + timeStamp +
		",uniqueId=" + uniqueId + ",sequenceNumber=" + sequenceNumber+
		",latitude=" + latitude + ",longitude=" + longitude + 
		",userType=" + userType + ",phoneNumber=" + phoneNumber;
	}

	public String toWSN() {
		return this.formatToWsn(new QName("http://www.orange.org/TaxiEventType", "GeolocationEvent" + "Topic", "evt"), "<OrangeLabsTaxiUC:GeolocationEvent "+
		"xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" " +
		"xmlns=\"http://www.orangelabs.org/taxiEventTypes\" " +
		"xsi:schemaLocation=\"http://www.orangelabs.org/TaxiEventType TaxiEventType.xsd\">"+
		"<uniqueId>"+uniqueId+"</uniqueId>"+
		"<sequenceNumber>"+sequenceNumber+"</sequenceNumber>"+
		"<timeStamp>"+timeStamp+"</timeStamp>"+
		"<latitude>"+latitude+"</latitude>"+
		"<longitude>"+longitude+"</longitude>"+
		"<userType>"+userType+"</userType>"+
		"<phoneNumber>"+phoneNumber+"</phoneNumber>"+
		"</OrangeLabsTaxiUC:GeolocationEvent>", null, null);
	}

	public String getRDFName() {
		return "TaxiUCGeoLocation";
	}

	public String toRDF(String AppID) {
		String pattern05 = AppID;
		String pattern07 = "TaxiUCGeoLocation";
		String pattern09 = "http://streams.event-processing.org/ids/TaxiUCGeoLocation#stream" ;

		String Header = "<mt:nativeMessage xmlns:mt=\"http://www.event-processing.org/wsn/msgtype/\" mt:syntax=\"application/x-trig\">\n";
		String Footer= "</mt:nativeMessage>\n";
		String str1 = 
			"@prefix :        <http://events.event-processing.org/types/> .\n"+
			"@prefix e:       <http://events.event-processing.org/ids/> .\n"+
			"@prefix dsb:     <http://www.petalslink.org/dsb/topicsns/> .\n"+
			"@prefix xsd:     <http://www.w3.org/2001/XMLSchema#> .\n"+
			"@prefix uctelco: <http://events.event-processing.org/uc/telco/> .\n"+
			"@prefix geo:     <http://www.w3.org/2003/01/geo/wgs84_pos#> .\n"+
			"e:#3# {\n"+
			"e:#3##event uctelco:sequenceNumber \"#4#\"^^xsd:integer ;\n"+
			"uctelco:uniqueId \"#6#\" ;\n"+
			"uctelco:userType \"#12#\" ;\n"+
			"uctelco:phoneNumber \"#13#\" ;\n"+
			"# but also some other data according to event format\n"+
			"a :#7# ;\n"+
			":endTime \"#8#\"^^xsd:dateTime ;\n"+
			":source <http://sources.event-processing.org/ids/#5##source> ;\n"+
			":stream <#9#> ; \n"+
			":location [ geo:lat \"#10#\"^^xsd:double ; geo:long \"#11#\"^^xsd:double ] .\n" +
			"}\n";
		String avaTemplate=  str1;
		int indexSep = this.uniqueId.indexOf(':');

		avaTemplate = avaTemplate.replaceFirst("#3#", this.uniqueId.substring(indexSep+1));
		avaTemplate = avaTemplate.replaceFirst("#3#", this.uniqueId.substring(indexSep+1));
		avaTemplate = avaTemplate.replaceFirst("#4#", this.sequenceNumber);
		avaTemplate = avaTemplate.replaceFirst("#5#", pattern05);
		avaTemplate = avaTemplate.replaceFirst("#6#", this.uniqueId);
		avaTemplate = avaTemplate.replaceFirst("#7#", pattern07);
		avaTemplate = avaTemplate.replaceFirst("#8#", this.timeStamp.replace(' ','T'));
		avaTemplate = avaTemplate.replaceFirst("#9#",pattern09 );
		// local part of the event
		avaTemplate = avaTemplate.replaceFirst("#10#", Double.toString(this.latitude));
		avaTemplate = avaTemplate.replaceFirst("#11#", Double.toString(this.longitude));
		avaTemplate = avaTemplate.replaceFirst("#12#", this.userType);
		avaTemplate = avaTemplate.replaceFirst("#13#", this.phoneNumber);

		if (AppID == "Android")
			return    StringEscapeUtils.escapeXml(avaTemplate) ;
		else 
			return Header + StringEscapeUtils.escapeXml(avaTemplate)  + Footer;

	}
}
