/*
 * Decompiled with CFR 0.152.
 */
package com.orange.eventData.events.inEvents;

import com.orange.eventData.events.inEvent;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringEscapeUtils;

public class SMSCustomerAlert
extends inEvent {
    protected String message;
    protected String customerNumber;
    private double latitude;
    private double longitude;

    public SMSCustomerAlert() {
    }

    public SMSCustomerAlert(String timeStamp, String uniqueId, String sequenceNumber) {
        super(timeStamp, uniqueId, sequenceNumber);
    }

    public SMSCustomerAlert(String timeStamp, String uniqueId, String sequenceNumber, String message, String customerNumber, double latitude, double longitude) {
        super(timeStamp, uniqueId, sequenceNumber);
        this.message = message;
        this.customerNumber = customerNumber;
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public String toStringCEP1() {
        return "stream=SMSCustomerAlert,uniqueId=" + this.uniqueId + ",sequenceNumber=" + this.sequenceNumber + ",timeStamp=" + this.timeStamp + ",customerNumber=" + this.customerNumber + ",latitude=" + this.latitude + ",longitude=" + this.longitude;
    }

    public String toRDF(String AppID) {
        String str1;
        String pattern05 = AppID;
        String pattern07 = "TaxiUCSMSCustomerAlert";
        String pattern09 = "http://streams.event-processing.org/ids/TaxiUCSMSCustomerAlert#stream";
        String Header = "<mt:nativeMessage xmlns:mt=\"http://www.event-processing.org/wsn/msgtype/\" mt:syntax=\"application/x-trig\">\n";
        String Footer = "</mt:nativeMessage>\n";
        String avaTemplate = str1 = "@prefix :        <http://events.event-processing.org/types/> .\n@prefix e:       <http://events.event-processing.org/ids/> .\n@prefix dsb:     <http://www.petalslink.org/dsb/topicsns/> .\n@prefix xsd:     <http://www.w3.org/2001/XMLSchema#> .\n@prefix uctelco: <http://events.event-processing.org/uc/telco/> .\n@prefix geo:     <http://www.w3.org/2003/01/geo/wgs84_pos#> .\ne:#3# {\ne:#3##event uctelco:sequenceNumber \"#4#\"^^xsd:integer ;\nuctelco:uniqueId \"#6#\" ;\nuctelco:message \"#10#\" ;\nuctelco:customerNumber \"#11#\" ;\n# but also some other data according to event format\na :#7# ;\n:endTime \"#8#\"^^xsd:dateTime ;\n:source <http://sources.event-processing.org/ids/#5##source> ;\n:stream <#9#> ; \n:location [ geo:lat \"#12#\"^^xsd:double ; geo:long \"#13#\"^^xsd:double ] .\n}\n";
        int indexSep = this.uniqueId.indexOf(58);
        avaTemplate = avaTemplate.replaceFirst("#3#", this.uniqueId.substring(indexSep + 1));
        avaTemplate = avaTemplate.replaceFirst("#3#", this.uniqueId.substring(indexSep + 1));
        avaTemplate = avaTemplate.replaceFirst("#4#", this.sequenceNumber);
        avaTemplate = avaTemplate.replaceFirst("#5#", pattern05);
        avaTemplate = avaTemplate.replaceFirst("#6#", this.uniqueId);
        avaTemplate = avaTemplate.replaceFirst("#7#", pattern07);
        avaTemplate = avaTemplate.replaceFirst("#8#", this.timeStamp.replace(' ', 'T'));
        avaTemplate = avaTemplate.replaceFirst("#9#", pattern09);
        avaTemplate = avaTemplate.replaceFirst("#10#", this.message);
        avaTemplate = avaTemplate.replaceFirst("#11#", this.customerNumber);
        avaTemplate = avaTemplate.replaceFirst("#12#", Double.toString(this.latitude));
        avaTemplate = avaTemplate.replaceFirst("#13#", Double.toString(this.longitude));
        if (AppID == "Android") {
            return StringEscapeUtils.escapeXml((String)avaTemplate);
        }
        return Header + StringEscapeUtils.escapeXml((String)avaTemplate) + Footer;
    }

    public String toString() {
        return "SMSCustomerAlert [uniqueId=" + this.uniqueId + ", sequenceNumber=" + this.sequenceNumber + ", timeStamp=" + this.timeStamp + ", message=" + this.message + ", customerNumber=" + this.customerNumber + ", latitude=" + this.latitude + ", longitude=" + this.longitude + "]";
    }

    public String toXML() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <SMSCustomerAlertEvent xmlns=\"http://www.orange.org/TaxiEventType\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.orange.org/TaxiEventType TaxiEventType.xsd\"><uniqueId>" + this.uniqueId + "</uniqueId>" + "<sequenceNumber>" + this.sequenceNumber + "</sequenceNumber>" + "<timeStamp>" + this.timeStamp + "</timeStamp>" + "<message>" + this.message + "</message>" + "<customerNumber>" + this.customerNumber + "</customerNumber>" + "<latitude>" + this.latitude + "</latitude>" + "<longitude>" + this.longitude + "</longitude>" + "</SMSCustomerAlert_Event>";
    }

    public String toWSN() {
        return this.formatToWsn(new QName("http://www.orange.org/TaxiEventType", "SMSCustomerAlertEventTopic", "evt"), "<OrangeLabsTaxiUC:SMSCustomerAlertEvent xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.orangelabs.org/taxiEventTypes\" xsi:schemaLocation=\"http://www.orangelabs.org/TaxiEventType TaxiEventType.xsd\"><uniqueId>" + this.uniqueId + "</uniqueId>" + "<sequenceNumber>" + this.sequenceNumber + "</sequenceNumber>" + "<timeStamp>" + this.timeStamp + "</timeStamp>" + "<message>" + this.message + "</message>" + "<customerNumber>" + this.customerNumber + "</customerNumber>" + "<latitude>" + this.latitude + "</latitude>" + "<longitude>" + this.longitude + "</longitude>" + "</OrangeLabsTaxiUC:SMSCustomerAlertEvent>", null, null);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String toStringCEP() {
        return "stream=SMSCustomerAlert,timestamp=" + this.timeStamp + ",uniqueId=" + this.uniqueId + ",sequenceNumber=" + this.sequenceNumber + ",customerNumber=" + this.customerNumber + ",latitude=" + this.latitude + ",longitude=" + this.longitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public String getCustomerNumber() {
        return this.customerNumber;
    }

    public void setCustomerNumber(String customerNumber) {
        this.customerNumber = customerNumber;
    }

    public double getLongitude() {
        return this.longitude;
    }
}

