/*
 * Decompiled with CFR 0.152.
 */
package com.orange.eventData.events.inEvents;

import com.orange.eventData.events.inEvent;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringEscapeUtils;

public class AvailabilityEvent
extends inEvent {
    protected CalendarStatus status;
    protected String userType;
    protected String phoneNumber;

    public AvailabilityEvent() {
    }

    public void setStatus(CalendarStatus status) {
        this.status = status;
    }

    public CalendarStatus getStatus() {
        return this.status;
    }

    public AvailabilityEvent(CalendarStatus status, String userType, String phoneNumber) {
        this.status = status;
        this.userType = userType;
        this.phoneNumber = phoneNumber;
    }

    public AvailabilityEvent(String timeStamp, String uniqueId, String sequenceNumber, CalendarStatus status, String userType, String phoneNumber) {
        super(timeStamp, uniqueId, sequenceNumber);
        this.status = status;
        this.userType = userType;
        this.phoneNumber = phoneNumber;
    }

    public String toStringCEP1() {
        return "stream=AvailabilityEvent,uniqueId=" + this.uniqueId + ",sequenceNumber=" + this.sequenceNumber + ",timeStamp=" + this.timeStamp + ",status=" + (Object)((Object)this.status) + ",userType=" + this.userType + ",phoneNumber=" + this.phoneNumber;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String toStringCEP() {
        return "Availability=timestamp=" + this.timeStamp + ", uniqueId=" + this.uniqueId + ", sequenceNumber=" + this.sequenceNumber + ", status=" + (Object)((Object)this.status);
    }

    public String toString() {
        return "AvailabilityEvent [uniqueId=" + this.uniqueId + ", sequenceNumber=" + this.sequenceNumber + ", timeStamp=" + this.timeStamp + ", status=" + (Object)((Object)this.status) + ", userType=" + this.userType + ", phoneNumber=" + this.phoneNumber + "]";
    }

    public String toXML() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <AvailabilityEvent xmlns=\"http://www.orange.org/TaxiEventType\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.orange.org/TaxiEventType TaxiEventType.xsd\"><uniqueId>" + this.uniqueId + "</uniqueId>" + "<sequenceNumber>" + this.sequenceNumber + "</sequenceNumber>" + "<timeStamp>" + this.timeStamp + "</timeStamp>" + "<status>" + (Object)((Object)this.status) + "</status>" + "<userType>" + this.userType + "</userType>" + "<phoneNumber>" + this.phoneNumber + "</phoneNumber>" + "</AvailabilityEvent>";
    }

    public String toWSN() {
        return this.formatToWsn(new QName("http://www.orange.org/TaxiEventType", "AvailabilityEventTopic", "evt"), "<OrangeLabsTaxiUC:AvailabilityEvent xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.orangelabs.org/taxiEventTypes\" xsi:schemaLocation=\"http://www.orangelabs.org/TaxiEventType TaxiEventType.xsd\"><uniqueId>" + this.uniqueId + "</uniqueId>" + "<sequenceNumber>" + this.sequenceNumber + "</sequenceNumber>" + "<timeStamp>" + this.timeStamp + "</timeStamp>" + "<status>" + (Object)((Object)this.status) + "</status>" + "<userType>" + this.userType + "</userType>" + "<phoneNumber>" + this.phoneNumber + "</phoneNumber>" + "</OrangeLabsTaxiUC:AvailabilityEvent>", null, null);
    }

    public String toRDF(String AppID) {
        String str1;
        String pattern07 = "TaxiUCAvailability";
        String pattern09 = "http://streams.event-processing.org/ids/TaxiUCAvailability#stream";
        String pattern05 = AppID;
        String Header = "<mt:nativeMessage xmlns:mt=\"http://www.event-processing.org/wsn/msgtype/\" mt:syntax=\"application/x-trig\">\n";
        String Footer = "</mt:nativeMessage>\n";
        String avaTemplate = str1 = "@prefix :        <http://events.event-processing.org/types/> .\n@prefix e:       <http://events.event-processing.org/ids/> .\n@prefix dsb:     <http://www.petalslink.org/dsb/topicsns/> .\n@prefix xsd:     <http://www.w3.org/2001/XMLSchema#> .\n@prefix uctelco: <http://events.event-processing.org/uc/telco/> .\n@prefix geo:     <http://www.w3.org/2003/01/geo/wgs84_pos#> .\ne:#3# {\ne:#3##event uctelco:sequenceNumber \"#4#\"^^xsd:integer ;\nuctelco:uniqueId \"#6#\" ;\nuctelco:phoneNumber \"#10#\" ;\nuctelco:status \"#11#\" ;\nuctelco:userType \"#12#\" ;\n# but also some other data according to event format\na :#7# ;\n:endTime \"#8#\"^^xsd:dateTime ;\n:source <http://sources.event-processing.org/ids/#5##source> ;\n:stream <#9#> .\n}\n";
        int indexSep = this.uniqueId.indexOf(58);
        avaTemplate = avaTemplate.replaceFirst("#3#", this.uniqueId.substring(indexSep + 1));
        avaTemplate = avaTemplate.replaceFirst("#3#", this.uniqueId.substring(indexSep + 1));
        avaTemplate = avaTemplate.replaceFirst("#4#", this.sequenceNumber);
        avaTemplate = avaTemplate.replaceFirst("#5#", pattern05);
        avaTemplate = avaTemplate.replaceFirst("#6#", this.uniqueId);
        avaTemplate = avaTemplate.replaceFirst("#7#", pattern07);
        avaTemplate = avaTemplate.replaceFirst("#8#", this.timeStamp.replace(' ', 'T'));
        avaTemplate = avaTemplate.replaceFirst("#9#", pattern09);
        avaTemplate = avaTemplate.replaceFirst("#10#", this.phoneNumber);
        avaTemplate = avaTemplate.replaceFirst("#11#", this.status.toString());
        avaTemplate = avaTemplate.replaceFirst("#12#", this.userType);
        if (AppID == "Android") {
            return StringEscapeUtils.escapeXml((String)avaTemplate);
        }
        return Header + StringEscapeUtils.escapeXml((String)avaTemplate) + Footer;
    }

    public static enum CalendarStatus {
        WORKING,
        HOLIDAY,
        MEETING;

    }
}

