/*
 * Decompiled with CFR 0.152.
 */
package com.orange.eventData.events.inEvents;

import com.orange.eventData.events.MultipleCEPSupport;
import com.orange.eventData.events.inEvent;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringEscapeUtils;

public class GeolocationEvent
extends inEvent
implements MultipleCEPSupport {
    private static final long serialVersionUID = -7952260000684495296L;
    protected double latitude = -1.0;
    protected double longitude = -1.0;
    protected String userType = "";
    protected String phoneNumber = "";

    public GeolocationEvent() {
    }

    public GeolocationEvent(double latitude, double longitude, String userType, String phoneNumber) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.userType = userType;
        this.phoneNumber = phoneNumber;
    }

    public GeolocationEvent(String timeStamp, String uniqueId, String sequenceNumber, double latitude, double longitude, String userType, String phoneNumber) {
        super(timeStamp, uniqueId, sequenceNumber);
        this.latitude = latitude;
        this.longitude = longitude;
        this.userType = userType;
        this.phoneNumber = phoneNumber;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String toStringCEP() {
        return "stream=GeolocationEvent,timestamp=" + this.timeStamp + ",uniqueId=" + this.uniqueId + ",sequenceNumber=" + this.sequenceNumber + ",latitude=" + this.latitude + ",longitude=" + this.longitude + ",userType=" + this.userType + ",phoneNumber=" + this.phoneNumber;
    }

    public String toStringCEP1() {
        return "stream=GeolocationEvent,timeStamp=timeStamp,uniqueId=" + this.uniqueId + ",sequenceNumber=" + this.sequenceNumber + ",latitude=" + this.latitude + ",longitude=" + this.longitude + ",userType=" + this.userType + ",phoneNumber=" + this.phoneNumber;
    }

    public String toString() {
        return "GeolocationEvent [uniqueId=" + this.uniqueId + ", sequenceNumber=" + this.sequenceNumber + ", timeStamp=" + this.timeStamp + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", userType=" + this.userType + ", phoneNumber=" + this.phoneNumber + "]";
    }

    @Override
    public String toXML() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <GeolocationEvent xmlns=\"http://www.orange.org/TaxiEventType\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.orange.org/TaxiEventType TaxiEventType.xsd\"><uniqueId>" + this.uniqueId + "</uniqueId>" + "<sequenceNumber>" + this.sequenceNumber + "</sequenceNumber>" + "<timeStamp>" + this.timeStamp + "</timeStamp>" + "<latitude>" + this.latitude + "</latitude>" + "<longitude>" + this.longitude + "</longitude>" + "<userType>" + this.userType + "</userType>" + "<phoneNumber>" + this.phoneNumber + "</phoneNumber>" + "</GeolocationEvent>";
    }

    @Override
    public String toCEP() {
        return "stream=GeolocationEvent,timeStamp=" + this.timeStamp + ",uniqueId=" + this.uniqueId + ",sequenceNumber=" + this.sequenceNumber + ",latitude=" + this.latitude + ",longitude=" + this.longitude + ",userType=" + this.userType + ",phoneNumber=" + this.phoneNumber;
    }

    @Override
    public String toWSN() {
        return this.formatToWsn(new QName("http://www.orange.org/TaxiEventType", "GeolocationEventTopic", "evt"), "<OrangeLabsTaxiUC:GeolocationEvent xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.orangelabs.org/taxiEventTypes\" xsi:schemaLocation=\"http://www.orangelabs.org/TaxiEventType TaxiEventType.xsd\"><uniqueId>" + this.uniqueId + "</uniqueId>" + "<sequenceNumber>" + this.sequenceNumber + "</sequenceNumber>" + "<timeStamp>" + this.timeStamp + "</timeStamp>" + "<latitude>" + this.latitude + "</latitude>" + "<longitude>" + this.longitude + "</longitude>" + "<userType>" + this.userType + "</userType>" + "<phoneNumber>" + this.phoneNumber + "</phoneNumber>" + "</OrangeLabsTaxiUC:GeolocationEvent>", null, null);
    }

    @Override
    public String getRDFName() {
        return "TaxiUCGeoLocation";
    }

    @Override
    public String toRDF(String AppID) {
        String str1;
        String pattern05 = AppID;
        String pattern07 = "TaxiUCGeoLocation";
        String pattern09 = "http://streams.event-processing.org/ids/TaxiUCGeoLocation#stream";
        String Header = "<mt:nativeMessage xmlns:mt=\"http://www.event-processing.org/wsn/msgtype/\" mt:syntax=\"application/x-trig\">\n";
        String Footer = "</mt:nativeMessage>\n";
        String avaTemplate = str1 = "@prefix :        <http://events.event-processing.org/types/> .\n@prefix e:       <http://events.event-processing.org/ids/> .\n@prefix dsb:     <http://www.petalslink.org/dsb/topicsns/> .\n@prefix xsd:     <http://www.w3.org/2001/XMLSchema#> .\n@prefix uctelco: <http://events.event-processing.org/uc/telco/> .\n@prefix geo:     <http://www.w3.org/2003/01/geo/wgs84_pos#> .\ne:#3# {\ne:#3##event uctelco:sequenceNumber \"#4#\"^^xsd:integer ;\nuctelco:uniqueId \"#6#\" ;\nuctelco:userType \"#12#\" ;\nuctelco:phoneNumber \"#13#\" ;\n# but also some other data according to event format\na :#7# ;\n:endTime \"#8#\"^^xsd:dateTime ;\n:source <http://sources.event-processing.org/ids/#5##source> ;\n:stream <#9#> ; \n:location [ geo:lat \"#10#\"^^xsd:double ; geo:long \"#11#\"^^xsd:double ] .\n}\n";
        int indexSep = this.uniqueId.indexOf(58);
        avaTemplate = avaTemplate.replaceFirst("#3#", this.uniqueId.substring(indexSep + 1));
        avaTemplate = avaTemplate.replaceFirst("#3#", this.uniqueId.substring(indexSep + 1));
        avaTemplate = avaTemplate.replaceFirst("#4#", this.sequenceNumber);
        avaTemplate = avaTemplate.replaceFirst("#5#", pattern05);
        avaTemplate = avaTemplate.replaceFirst("#6#", this.uniqueId);
        avaTemplate = avaTemplate.replaceFirst("#7#", pattern07);
        avaTemplate = avaTemplate.replaceFirst("#8#", this.timeStamp.replace(' ', 'T'));
        avaTemplate = avaTemplate.replaceFirst("#9#", pattern09);
        avaTemplate = avaTemplate.replaceFirst("#10#", Double.toString(this.latitude));
        avaTemplate = avaTemplate.replaceFirst("#11#", Double.toString(this.longitude));
        avaTemplate = avaTemplate.replaceFirst("#12#", this.userType);
        avaTemplate = avaTemplate.replaceFirst("#13#", this.phoneNumber);
        if (AppID == "Android") {
            return StringEscapeUtils.escapeXml((String)avaTemplate);
        }
        return Header + StringEscapeUtils.escapeXml((String)avaTemplate) + Footer;
    }
}

